/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemPartEffector;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONConfigClient;
import minecrafttransportsimulator.jsondefs.JSONConfigCraftingOverrides;
import minecrafttransportsimulator.jsondefs.JSONConfigExternalDamageOverrides;
import minecrafttransportsimulator.jsondefs.JSONConfigSettings;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.LanguageSystem;

public final class ConfigSystem {
    private static File settingsFile;
    private static File clientFile;
    private static File craftingFile;
    private static File externalDamageFile;
    public static JSONConfigSettings settings;
    public static JSONConfigClient client;
    public static JSONConfigExternalDamageOverrides externalDamageOverrides;
    private static File configDirectory;

    public static void loadFromDisk(File configDirectory, boolean onClient) {
        ConfigSystem.configDirectory = configDirectory;
        settingsFile = new File(configDirectory, "mtsconfig.json");
        if (settingsFile.exists()) {
            try {
                settings = JSONParser.parseStream(Files.newInputStream(settingsFile.toPath(), new OpenOption[0]), JSONConfigSettings.class, null, null);
            }
            catch (Exception e) {
                InterfaceManager.coreInterface.logError("ConfigSystem failed to parse settings file JSON.  Reverting to defaults.");
                InterfaceManager.coreInterface.logError(e.getMessage());
            }
        }
        if (settings == null) {
            settings = new JSONConfigSettings();
        }
        if (onClient) {
            clientFile = new File(configDirectory, "mtsconfigclient.json");
            if (clientFile.exists()) {
                try {
                    client = JSONParser.parseStream(Files.newInputStream(clientFile.toPath(), new OpenOption[0]), JSONConfigClient.class, null, null);
                }
                catch (Exception e) {
                    InterfaceManager.coreInterface.logError("ConfigSystem failed to parse client file JSON.  Reverting to defaults.");
                    InterfaceManager.coreInterface.logError(e.getMessage());
                }
            }
            if (client == null) {
                client = new JSONConfigClient();
            }
            if (ConfigSystem.client.controls.keysetID != InterfaceManager.inputInterface.getKeysetID()) {
                ConfigSystem.client.controls = new JSONConfigClient.JSONControls();
                ConfigSystem.client.controls.keysetID = InterfaceManager.inputInterface.getKeysetID();
            }
        }
        craftingFile = new File(settingsFile.getParentFile(), "mtscraftingoverrides.json");
        externalDamageFile = new File(settingsFile.getParentFile(), "mtsexternaldamageoverrides.json");
        File oldConfigFile = new File(configDirectory, "mts.cfg");
        if (oldConfigFile.exists()) {
            oldConfigFile.delete();
        }
    }

    public static void initOverrides() {
        if (((Boolean)ConfigSystem.settings.general.generateOverrideConfigs.value).booleanValue()) {
            try {
                JSONConfigCraftingOverrides overridesObject = new JSONConfigCraftingOverrides();
                overridesObject.overrides = new LinkedHashMap<String, Map<String, JSONConfigCraftingOverrides.JSONCraftingOverride>>();
                for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
                    JSONConfigCraftingOverrides.JSONCraftingOverride override;
                    Map<String, JSONConfigCraftingOverrides.JSONCraftingOverride> packOverrides = overridesObject.overrides.get(((AJSONItem)packItem.definition).packID);
                    if (packOverrides == null) {
                        packOverrides = new LinkedHashMap<String, JSONConfigCraftingOverrides.JSONCraftingOverride>();
                        overridesObject.overrides.put(((AJSONItem)packItem.definition).packID, packOverrides);
                    }
                    if ((override = packOverrides.get(((AJSONItem)packItem.definition).systemName)) == null) {
                        override = new JSONConfigCraftingOverrides.JSONCraftingOverride();
                        packOverrides.put(((AJSONItem)packItem.definition).systemName, override);
                    }
                    override.commonMaterialLists = ((AJSONItem)packItem.definition).general.materialLists;
                    if (packItem instanceof AItemSubTyped) {
                        if (override.extraMaterialLists == null) {
                            override.extraMaterialLists = new HashMap<String, List<List<String>>>();
                        }
                        JSONSubDefinition subDefinition = ((AItemSubTyped)packItem).subDefinition;
                        override.extraMaterialLists.put(subDefinition.subName, subDefinition.extraMaterialLists);
                    }
                    override.repairMaterialLists = ((AJSONItem)packItem.definition).general.repairMaterialLists;
                    if (!(packItem instanceof ItemPartEffector)) continue;
                    ItemPartEffector effectorItem = (ItemPartEffector)packItem;
                    if (((JSONPart)effectorItem.definition).effector.crafterInputs == null) continue;
                    override.autocrafterInputs = ((JSONPart)effectorItem.definition).effector.crafterInputs;
                    override.autocrafterOutputs = ((JSONPart)effectorItem.definition).effector.crafterOutputs;
                }
                JSONParser.exportStream(overridesObject, Files.newOutputStream(craftingFile.toPath(), new OpenOption[0]));
            }
            catch (Exception e) {
                InterfaceManager.coreInterface.logError("ConfigSystem failed to create fresh crafting overrides file.  Report to the mod author!");
                InterfaceManager.coreInterface.logError(e.getMessage());
            }
            LanguageSystem.dumpToFolder(new File(configDirectory, "IVLanguageDumps"));
            try {
                ConfigSystem.createDefaultExternalDamageOverrides();
                JSONParser.exportStream(externalDamageOverrides, Files.newOutputStream(externalDamageFile.toPath(), new OpenOption[0]));
            }
            catch (Exception e) {
                InterfaceManager.coreInterface.logError("ConfigSystem failed to create fresh external damage overrides file.  Report to the mod author!");
                InterfaceManager.coreInterface.logError(e.getMessage());
            }
        } else {
            if (craftingFile.exists()) {
                try {
                    JSONConfigCraftingOverrides overridesObject = JSONParser.parseStream(Files.newInputStream(craftingFile.toPath(), new OpenOption[0]), JSONConfigCraftingOverrides.class, null, null);
                    for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
                        JSONConfigCraftingOverrides.JSONCraftingOverride override;
                        Map<String, JSONConfigCraftingOverrides.JSONCraftingOverride> packOverrides = overridesObject.overrides.get(((AJSONItem)packItem.definition).packID);
                        if (packOverrides == null || (override = packOverrides.get(((AJSONItem)packItem.definition).systemName)) == null) continue;
                        if (override.commonMaterialLists != null) {
                            ((AJSONItem)packItem.definition).general.materialLists = override.commonMaterialLists;
                        }
                        if (override.extraMaterialLists != null) {
                            JSONSubDefinition subDefinition = ((AItemSubTyped)packItem).subDefinition;
                            List<List<String>> extraMaterialLists = override.extraMaterialLists.get(subDefinition.subName);
                            if (extraMaterialLists != null) {
                                subDefinition.extraMaterialLists = extraMaterialLists;
                            }
                        }
                        if (override.repairMaterialLists != null) {
                            ((AJSONItem)packItem.definition).general.repairMaterialLists = override.repairMaterialLists;
                        }
                        if (!(packItem instanceof ItemPartEffector)) continue;
                        ItemPartEffector effectorItem = (ItemPartEffector)packItem;
                        if (((JSONPart)effectorItem.definition).effector.crafterInputs != null) {
                            ((JSONPart)effectorItem.definition).effector.crafterInputs = override.autocrafterInputs;
                        }
                        if (((JSONPart)effectorItem.definition).effector.crafterOutputs == null) continue;
                        ((JSONPart)effectorItem.definition).effector.crafterOutputs = override.autocrafterOutputs;
                    }
                }
                catch (Exception e) {
                    InterfaceManager.coreInterface.logError("ConfigSystem failed to parse crafting override file JSON.  Crafting overrides will not be applied.");
                    InterfaceManager.coreInterface.logError(e.getMessage());
                }
            }
            if (externalDamageFile.exists()) {
                try {
                    externalDamageOverrides = JSONParser.parseStream(Files.newInputStream(externalDamageFile.toPath(), new OpenOption[0]), JSONConfigExternalDamageOverrides.class, null, null);
                }
                catch (Exception e) {
                    InterfaceManager.coreInterface.logError("ConfigSystem failed to parse external damage override file.  Overrides will not be applied.");
                    InterfaceManager.coreInterface.logError(e.getMessage());
                    ConfigSystem.createDefaultExternalDamageOverrides();
                }
            } else {
                ConfigSystem.createDefaultExternalDamageOverrides();
            }
        }
    }

    private static void createDefaultExternalDamageOverrides() {
        externalDamageOverrides = new JSONConfigExternalDamageOverrides();
        ConfigSystem.externalDamageOverrides.overrides = new LinkedHashMap<String, Map<String, Double>>();
        for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
            if (!(packItem instanceof ItemVehicle)) continue;
            if (!ConfigSystem.externalDamageOverrides.overrides.containsKey(((AJSONItem)packItem.definition).packID)) {
                ConfigSystem.externalDamageOverrides.overrides.put(((AJSONItem)packItem.definition).packID, new LinkedHashMap());
            }
            ConfigSystem.externalDamageOverrides.overrides.get(((AJSONItem)packItem.definition).packID).put(((AJSONItem)packItem.definition).systemName, 1.0);
        }
    }

    public static void saveToDisk() {
        try {
            JSONParser.exportStream(settings, Files.newOutputStream(settingsFile.toPath(), new OpenOption[0]));
            JSONParser.exportStream(client, Files.newOutputStream(clientFile.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            InterfaceManager.coreInterface.logError("ConfigSystem failed to save modified config files.  Report to the mod author!");
            InterfaceManager.coreInterface.logError(e.getMessage());
        }
    }
}

