/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.nio.ByteBuffer;

public interface IStreamDecoder {
    public static final int MAX_READ_SIZE = 49152;
    public static final int BUFFER_SIZE = 131072;

    public ByteBuffer readBlock();

    public void stop();

    public static ByteBuffer stereoToMono(ByteBuffer stereoBuffer) {
        ByteBuffer monoBuffer = ByteBuffer.allocateDirect(stereoBuffer.limit() / 2);
        while (stereoBuffer.hasRemaining()) {
            byte[] sampleSet = new byte[4];
            stereoBuffer.get(sampleSet);
            int leftSample = sampleSet[1] << 8 | sampleSet[0] & 0xFF;
            int rightSample = sampleSet[3] << 8 | sampleSet[2] & 0xFF;
            int combinedSample = (leftSample + rightSample) / 2;
            monoBuffer.put((byte)(combinedSample & 0xFF));
            monoBuffer.put((byte)(combinedSample >> 8));
        }
        monoBuffer.flip();
        return monoBuffer;
    }

    public int getSampleRate();
}

