/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketEntityVariableSet
extends APacketEntity<AEntityD_Definable<?>> {
    private final String variableKey;
    private final double variableValue;

    public PacketEntityVariableSet(ComputedVariable variable, double variableValue) {
        super(variable.entity);
        this.variableKey = variable.variableKey;
        this.variableValue = variableValue;
    }

    public PacketEntityVariableSet(ByteBuf buf) {
        super(buf);
        this.variableKey = PacketEntityVariableSet.readStringFromBuffer(buf);
        this.variableValue = buf.readDouble();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityVariableSet.writeStringToBuffer(this.variableKey, buf);
        buf.writeDouble(this.variableValue);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityD_Definable<?> entity) {
        entity.getOrCreateVariable(this.variableKey).setTo(this.variableValue, false);
        return true;
    }
}

