/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketEntityVariableIncrement
extends APacketEntity<AEntityD_Definable<?>> {
    private final String variableKey;
    private final double incrementValue;
    private final double minValue;
    private final double maxValue;

    public PacketEntityVariableIncrement(ComputedVariable variable, double incrementValue, double minValue, double maxValue) {
        super(variable.entity);
        this.variableKey = variable.variableKey;
        this.incrementValue = incrementValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public PacketEntityVariableIncrement(ComputedVariable variable, double incrementValue) {
        this(variable, incrementValue, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public PacketEntityVariableIncrement(ByteBuf buf) {
        super(buf);
        this.variableKey = PacketEntityVariableIncrement.readStringFromBuffer(buf);
        this.incrementValue = buf.readDouble();
        this.minValue = buf.readDouble();
        this.maxValue = buf.readDouble();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityVariableIncrement.writeStringToBuffer(this.variableKey, buf);
        buf.writeDouble(this.incrementValue);
        buf.writeDouble(this.minValue);
        buf.writeDouble(this.maxValue);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityD_Definable<?> entity) {
        return entity.getOrCreateVariable(this.variableKey).increment(this.incrementValue, this.minValue, this.maxValue, false);
    }
}

