/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketBase;

public class PacketEntityBulletHitBlock
extends APacketBase {
    private final UUID gunID;
    private final int bulletNumber;
    private final Point3D blockPosition;
    private final ABlockBase.Axis blockSide;

    public PacketEntityBulletHitBlock(PartGun gun, int bulletNumber, Point3D blockPosition, ABlockBase.Axis blockSide) {
        super(null);
        this.gunID = gun.uniqueUUID;
        this.bulletNumber = bulletNumber;
        this.blockPosition = blockPosition;
        this.blockSide = blockSide;
    }

    public PacketEntityBulletHitBlock(ByteBuf buf) {
        super(buf);
        this.gunID = PacketEntityBulletHitBlock.readUUIDFromBuffer(buf);
        this.bulletNumber = buf.readInt();
        this.blockPosition = PacketEntityBulletHitBlock.readPoint3dFromBuffer(buf);
        this.blockSide = ABlockBase.Axis.values()[buf.readByte()];
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityBulletHitBlock.writeUUIDToBuffer(this.gunID, buf);
        buf.writeInt(this.bulletNumber);
        PacketEntityBulletHitBlock.writePoint3dToBuffer(this.blockPosition, buf);
        buf.writeByte(this.blockSide.ordinal());
    }

    @Override
    public void handle(AWrapperWorld world) {
        EntityBullet.performBlockHitLogic(world.getBulletGun(this.gunID), this.bulletNumber, this.blockPosition, this.blockSide);
    }
}

