/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.AEntityCrafter;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketCrafterFuelAdd
extends APacketEntity<AEntityCrafter> {
    private final int fuelAmount;

    public PacketCrafterFuelAdd(AEntityCrafter crafter) {
        super(crafter);
        this.fuelAmount = crafter.ticksLeftOfFuel;
    }

    public PacketCrafterFuelAdd(ByteBuf buf) {
        super(buf);
        this.fuelAmount = buf.readInt();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.fuelAmount);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityCrafter crafter) {
        crafter.ticksFuelProvides = this.fuelAmount;
        crafter.ticksLeftOfFuel += crafter.ticksFuelProvides;
        if (crafter.definition.crafterType == JSONPart.CrafterComponentType.ELECTRIC) {
            crafter.powerToDrawPerTick = 1.0 / (double)this.fuelAmount;
        }
        return true;
    }
}

