/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import minecrafttransportsimulator.entities.instances.AEntityCrafter;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.instances.AGUIInventory;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPlayerItemTransfer;

public class AGUICrafter
extends AGUIInventory {
    private GUIComponentCutout fuelIcon;
    private GUIComponentCutout craftingProgress;
    private final AEntityCrafter crafter;
    private final int[] itemSlotParams;
    private final int[] fuelLevelParams;
    private final int[] progressLevelParams;

    public AGUICrafter(AEntityCrafter crafter, String texture, int[] itemSlotParams, int[] fuelLevelParams, int[] progressLevelParams) {
        super(texture);
        this.crafter = crafter;
        this.itemSlotParams = itemSlotParams;
        this.fuelLevelParams = fuelLevelParams;
        this.progressLevelParams = progressLevelParams;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.interactableSlotButtons.clear();
        this.interactableSlotIcons.clear();
        for (int i = 0; i < this.itemSlotParams.length / 2; ++i) {
            GUIComponentButton itemButton = new GUIComponentButton(this, this.guiLeft + this.itemSlotParams[i * 2], this.guiTop + this.itemSlotParams[i * 2 + 1], false){

                @Override
                public void onClicked(boolean leftSide) {
                    InterfaceManager.packetInterface.sendToServer(new PacketPlayerItemTransfer(AGUICrafter.this.crafter, AGUICrafter.this.player, AGUICrafter.this.interactableSlotButtons.indexOf(this), -1, false));
                }
            };
            this.addComponent(itemButton);
            this.interactableSlotButtons.add(itemButton);
            GUIComponentItem itemIcon = new GUIComponentItem(itemButton);
            this.addComponent(itemIcon);
            this.interactableSlotIcons.add(itemIcon);
            if (i != 0 || this.crafter.definition.crafterType == JSONPart.CrafterComponentType.STANDARD) continue;
            itemButton.visible = false;
        }
        int backplaneOffset = 36;
        switch (this.crafter.definition.crafterType) {
            case STANDARD: {
                break;
            }
            case FUEL: {
                backplaneOffset += 18;
                break;
            }
            case ELECTRIC: {
                backplaneOffset += 36;
            }
        }
        this.addComponent(new GUIComponentCutout(this, this.guiLeft + this.itemSlotParams[0], this.guiTop + this.itemSlotParams[1], 18, 18, 176, backplaneOffset));
        this.fuelIcon = new GUIComponentCutout(this, this.guiLeft + this.fuelLevelParams[0], this.guiTop + this.fuelLevelParams[1], this.fuelLevelParams[2], this.fuelLevelParams[3], this.fuelLevelParams[4], this.fuelLevelParams[5]);
        this.addComponent(this.fuelIcon);
        this.craftingProgress = new GUIComponentCutout(this, this.guiLeft + this.progressLevelParams[0], this.guiTop + this.progressLevelParams[1], this.progressLevelParams[2], this.progressLevelParams[3], this.progressLevelParams[4], this.progressLevelParams[5]);
        this.addComponent(this.craftingProgress);
    }

    @Override
    public void setStates() {
        int pixelsHigh;
        int pixelsWide;
        super.setStates();
        for (int i = 0; i < this.interactableSlotButtons.size(); ++i) {
            IWrapperItemStack stack = this.crafter.getStack(i);
            ((GUIComponentButton)this.interactableSlotButtons.get((int)i)).enabled = !stack.isEmpty();
            ((GUIComponentItem)this.interactableSlotIcons.get((int)i)).stack = stack;
        }
        boolean bl = this.fuelIcon.visible = this.crafter.ticksLeftOfFuel > 0;
        if (this.fuelIcon.visible) {
            if (this.fuelLevelParams[6] == 0) {
                this.fuelIcon.width = pixelsWide = (int)((double)this.fuelLevelParams[2] * ((double)this.crafter.ticksLeftOfFuel / (double)this.crafter.ticksFuelProvides));
                this.fuelIcon.textureSectionWidth = pixelsWide;
            } else {
                pixelsHigh = (int)Math.ceil((double)this.fuelLevelParams[3] * ((double)this.crafter.ticksLeftOfFuel / (double)this.crafter.ticksFuelProvides));
                this.fuelIcon.position.y = -(this.fuelIcon.constructedY + this.fuelLevelParams[3] - pixelsHigh);
                this.fuelIcon.height = pixelsHigh;
                this.fuelIcon.textureSectionHeight = pixelsHigh;
                this.fuelIcon.textureYOffset = this.fuelLevelParams[5] + this.fuelLevelParams[3] - pixelsHigh;
            }
        }
        if (this.crafter.ticksNeededToCraft > 0 && this.crafter.ticksLeftToCraft > 0) {
            if (this.progressLevelParams[6] == 0) {
                this.craftingProgress.width = pixelsWide = (int)((double)this.progressLevelParams[2] * ((double)(this.crafter.ticksNeededToCraft - this.crafter.ticksLeftToCraft) / (double)this.crafter.ticksNeededToCraft));
                this.craftingProgress.textureSectionWidth = pixelsWide;
            } else {
                this.craftingProgress.height = pixelsHigh = (int)Math.ceil((double)this.progressLevelParams[3] * ((double)(this.crafter.ticksNeededToCraft - this.crafter.ticksLeftToCraft) / (double)this.crafter.ticksNeededToCraft));
                this.craftingProgress.textureSectionHeight = pixelsHigh;
            }
            this.craftingProgress.visible = true;
        } else {
            this.craftingProgress.visible = false;
        }
    }

    @Override
    protected void handlePlayerItemClick(int slotClicked) {
        InterfaceManager.packetInterface.sendToServer(new PacketPlayerItemTransfer(this.crafter, this.player, -1, slotClicked, false));
    }

    @Override
    protected int getPlayerInventoryOffset() {
        return 142;
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.crafter.isValid;
    }

    @Override
    public int getWidth() {
        return 176;
    }

    @Override
    public int getHeight() {
        return 166;
    }
}

