/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BlockHitResult;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityPlacedPart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitBlock;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitExternalEntity;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitGeneric;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class EntityBullet
extends AEntityD_Definable<JSONBullet> {
    public final PartGun gun;
    public final int bulletNumber;
    private final boolean isBomb;
    public final double initialVelocity;
    private final double velocityToAddEachTick;
    private final Point3D motionToAddEachTick;
    private final int despawnTime;
    private final BoundingBox proxBounds;
    public boolean waitingOnActionPacket;
    private int impactDespawnTimer = -1;
    private Point3D targetPosition;
    private final Point3D helperPoint = new Point3D();
    public double targetDistance;
    private double distanceTraveled;
    public double armorPenetrated;
    private Point3D targetVector;
    private Point3D normalizedConeVector = new Point3D();
    private Point3D normalizedEntityVector = new Point3D();
    private PartEngine engineTargeted;
    private IWrapperEntity externalEntityTargeted;
    public HitType lastHit;
    public ABlockBase.Axis sideHit;
    private BlockHitResult hitBlock;
    private Point3D relativeGunPos;
    private Point3D prevRelativeGunPos;
    private final List<AEntityF_Multipart<?>> multiparts = new ArrayList();

    public EntityBullet(Point3D position, Point3D motion, RotationMatrix orientation, PartGun gun, int bulletNumber) {
        super(gun.world, position, motion, ZERO_FOR_CONSTRUCTOR, gun.lastLoadedBullet);
        this.gun = gun;
        this.bulletNumber = bulletNumber;
        gun.currentBullet = this;
        this.isBomb = ((JSONPart)gun.definition).gun.muzzleVelocity == 0;
        this.boundingBox.widthRadius = (double)((JSONBullet)this.definition).bullet.diameter / 1000.0 / 2.0;
        this.boundingBox.heightRadius = (double)((JSONBullet)this.definition).bullet.diameter / 1000.0 / 2.0;
        this.boundingBox.depthRadius = (double)((JSONBullet)this.definition).bullet.diameter / 1000.0 / 2.0;
        this.initialVelocity = motion.length();
        if (((JSONBullet)this.definition).bullet.accelerationTime > 0) {
            this.velocityToAddEachTick = ((double)((JSONBullet)this.definition).bullet.maxVelocity / 20.0 - motion.length()) / (double)((JSONBullet)this.definition).bullet.accelerationTime;
            this.motionToAddEachTick = new Point3D(0.0, 0.0, this.velocityToAddEachTick).rotate(gun.orientation);
        } else {
            this.velocityToAddEachTick = 0.0;
            this.motionToAddEachTick = null;
        }
        this.despawnTime = ((JSONBullet)this.definition).bullet.despawnTime != 0 ? ((JSONBullet)this.definition).bullet.despawnTime : 200;
        this.proxBounds = ((JSONBullet)this.definition).bullet.proximityFuze != 0.0f ? new BoundingBox(position.copy(), ((JSONBullet)this.definition).bullet.proximityFuze) : null;
        this.orientation.set(orientation);
        this.prevOrientation.set(orientation);
    }

    public EntityBullet(Point3D position, Point3D motion, RotationMatrix orientation, PartGun gun, int bulletNumber, Point3D targetPosition) {
        this(position, motion, orientation, gun, bulletNumber);
        this.targetPosition = targetPosition;
    }

    public EntityBullet(Point3D position, Point3D motion, RotationMatrix orientation, PartGun gun, int bulletNumber, PartEngine engineTargeted) {
        this(position, motion, orientation, gun, bulletNumber, engineTargeted.position);
        this.engineTargeted = engineTargeted;
        engineTargeted.vehicleOn.missilesIncoming.add(this);
        this.displayDebugMessage("LOCKON ENGINE " + ((JSONPart)engineTargeted.definition).systemName + " @ " + this.targetPosition);
    }

    public EntityBullet(Point3D position, Point3D motion, RotationMatrix orientation, PartGun gun, int bulletNumber, IWrapperEntity externalEntityTargeted) {
        this(position, motion, orientation, gun, bulletNumber, externalEntityTargeted.getPosition().copy());
        this.externalEntityTargeted = externalEntityTargeted;
        this.displayDebugMessage("LOCKON ENTITY " + externalEntityTargeted.getName() + " @ " + externalEntityTargeted.getPosition());
    }

    @Override
    public void update() {
        super.update();
        if (this.hitBlock != null) {
            if (this.world.isClient()) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitBlock(this.gun, this.bulletNumber, this.hitBlock.blockPosition, this.hitBlock.side));
            } else {
                EntityBullet.performBlockHitLogic(this.gun, this.bulletNumber, this.hitBlock.blockPosition, this.hitBlock.side);
            }
            this.hitBlock = null;
        }
        if (this.impactDespawnTimer >= 0) {
            if (this.impactDespawnTimer-- == 0) {
                this.remove();
            }
            return;
        }
        if (this.ticksExisted > (long)(((JSONBullet)this.definition).bullet.burnTime + this.despawnTime)) {
            if (((JSONBullet)this.definition).bullet.isLongRange ^ this.world.isClient()) {
                this.displayDebugMessage("TIMEOUT");
            }
            this.remove();
            return;
        }
        if (!this.world.isInsideBorder(this.position)) {
            this.displayDebugMessage("OUTSIDE OF WORLD");
            this.remove();
            return;
        }
        if (!this.waitingOnActionPacket) {
            boolean notAcceleratingYet;
            if (this.ticksExisted > 1L) {
                this.distanceTraveled += this.velocity;
            }
            if (this.ticksExisted > (long)((JSONBullet)this.definition).bullet.burnTime || this.ticksExisted < (long)((JSONBullet)this.definition).bullet.accelerationDelay) {
                if (((JSONBullet)this.definition).bullet.slowdownSpeed > 0.0f) {
                    this.motion.add(this.motion.copy().normalize().scale(-((JSONBullet)this.definition).bullet.slowdownSpeed));
                }
                this.motion.y -= (double)((JSONBullet)this.definition).bullet.gravitationalVelocity;
            }
            boolean bl = notAcceleratingYet = ((JSONBullet)this.definition).bullet.accelerationDelay != 0 && this.ticksExisted < (long)((JSONBullet)this.definition).bullet.accelerationDelay;
            if (this.velocityToAddEachTick != 0.0 && !notAcceleratingYet && this.ticksExisted - (long)((JSONBullet)this.definition).bullet.accelerationDelay < (long)((JSONBullet)this.definition).bullet.accelerationTime) {
                this.motionToAddEachTick.set(0.0, 0.0, this.velocityToAddEachTick).rotate(this.orientation);
                this.motion.add(this.motionToAddEachTick);
            }
            if (((JSONBullet)this.definition).bullet.turnRate > 0.0f && !notAcceleratingYet) {
                switch (((JSONBullet)this.definition).bullet.guidanceType) {
                    case PASSIVE: {
                        break;
                    }
                    case SEMI_ACTIVE: {
                        if (this.externalEntityTargeted != null) {
                            if (this.externalEntityTargeted.isValid()) {
                                this.targetPosition.set(this.externalEntityTargeted.getPosition()).add(0.0, this.externalEntityTargeted.getBounds().heightRadius, 0.0);
                                break;
                            }
                            if (this.gun.entityTarget == null) {
                                this.targetPosition = null;
                                break;
                            }
                            this.externalEntityTargeted = null;
                            this.targetPosition = null;
                            break;
                        }
                        if (this.engineTargeted == null) break;
                        if (this.gun.engineTarget == null) {
                            this.targetPosition = null;
                        }
                        if (this.engineTargeted.isValid) break;
                        this.engineTargeted.vehicleOn.missilesIncoming.remove(this);
                        this.engineTargeted = null;
                        this.targetPosition = null;
                        break;
                    }
                    case ACTIVE: {
                        double targetAngle;
                        Point3D startPoint = this.position;
                        Point3D searchVector = new Point3D(0.0, 0.0, ((JSONBullet)this.definition).bullet.seekerRange).rotate(this.orientation);
                        double coneAngle = ((JSONBullet)this.definition).bullet.seekerMaxAngle;
                        if (this.externalEntityTargeted != null) {
                            this.normalizedConeVector.set(searchVector).normalize();
                            this.normalizedEntityVector.set(this.externalEntityTargeted.getPosition()).subtract(startPoint).normalize();
                            targetAngle = Math.abs(Math.toDegrees(Math.acos(this.normalizedConeVector.dotProduct(this.normalizedEntityVector, false))));
                            if (this.externalEntityTargeted.isValid() && targetAngle < coneAngle || this.world.getBlockHit(startPoint, this.targetPosition) != null || this.targetPosition.distanceTo(this.position) > (double)((JSONBullet)this.definition).bullet.seekerRange) {
                                this.targetPosition.set(this.externalEntityTargeted.getPosition()).add(0.0, this.externalEntityTargeted.getBounds().heightRadius, 0.0);
                                break;
                            }
                            this.externalEntityTargeted = null;
                            this.targetPosition = null;
                            break;
                        }
                        if (this.engineTargeted == null) break;
                        this.normalizedConeVector.set(searchVector).normalize();
                        this.normalizedEntityVector.set(this.engineTargeted.vehicleOn.position).subtract(startPoint).normalize();
                        targetAngle = Math.abs(Math.toDegrees(Math.acos(this.normalizedConeVector.dotProduct(this.normalizedEntityVector, false))));
                        if (this.engineTargeted.isValid && !(targetAngle > coneAngle) && this.world.getBlockHit(startPoint, this.targetPosition) == null && !(this.targetPosition.distanceTo(this.position) > (double)((JSONBullet)this.definition).bullet.seekerRange)) break;
                        this.engineTargeted.vehicleOn.missilesIncoming.remove(this);
                        this.engineTargeted = null;
                        this.targetPosition = null;
                        break;
                    }
                }
                if (this.targetPosition != null) {
                    if (this.targetVector == null) {
                        this.targetVector = new Point3D();
                    }
                    double ticksToTarget = this.targetPosition.distanceTo(this.position) / (this.velocity / 20.0);
                    if (this.engineTargeted != null && (((JSONPart)this.gun.definition).gun.targetType == JSONPart.TargetType.ALL || ((JSONPart)this.gun.definition).gun.targetType == JSONPart.TargetType.AIRCRAFT || ((JSONPart)this.gun.definition).gun.targetType == JSONPart.TargetType.GROUND)) {
                        this.targetVector.set(this.targetPosition).addScaled(this.engineTargeted.vehicleOn.motion, this.engineTargeted.vehicleOn.speedFactor / 20.0 * ticksToTarget).subtract(this.position).reOrigin(this.orientation).getAngles(true);
                    } else if (this.externalEntityTargeted != null && (((JSONPart)this.gun.definition).gun.targetType == JSONPart.TargetType.ALL || ((JSONPart)this.gun.definition).gun.targetType == JSONPart.TargetType.SOFT)) {
                        this.targetVector.set(this.targetPosition).addScaled(this.externalEntityTargeted.getVelocity(), this.externalEntityTargeted.getVelocity().length() / 20.0 * ticksToTarget).subtract(this.position).reOrigin(this.orientation).getAngles(true);
                    } else {
                        this.targetVector.set(this.targetPosition).subtract(this.position).reOrigin(this.orientation).getAngles(true);
                    }
                    if (this.ticksExisted > (long)((JSONBullet)this.definition).bullet.guidanceDelay) {
                        if (this.targetVector.y > (double)((JSONBullet)this.definition).bullet.turnRate) {
                            this.targetVector.y = ((JSONBullet)this.definition).bullet.turnRate;
                        } else if (this.targetVector.y < (double)(-((JSONBullet)this.definition).bullet.turnRate)) {
                            this.targetVector.y = -((JSONBullet)this.definition).bullet.turnRate;
                        }
                        this.orientation.rotateY(this.targetVector.y);
                        if (this.targetVector.x > (double)((JSONBullet)this.definition).bullet.turnRate) {
                            this.targetVector.x = ((JSONBullet)this.definition).bullet.turnRate;
                        } else if (this.targetVector.x < (double)(-((JSONBullet)this.definition).bullet.turnRate)) {
                            this.targetVector.x = -((JSONBullet)this.definition).bullet.turnRate;
                        }
                        this.orientation.rotateX(this.targetVector.x);
                        this.targetVector.set(0.0, 0.0, this.motion.length()).rotate(this.orientation);
                        if (this.ticksExisted > (long)((JSONBullet)this.definition).bullet.burnTime) {
                            this.motion.y -= (double)((JSONBullet)this.definition).bullet.gravitationalVelocity;
                            this.motion.set(this.targetVector.x, this.motion.y, this.targetVector.z);
                        } else {
                            this.motion.set(this.targetVector);
                        }
                        this.targetDistance = this.targetPosition.distanceTo(this.position);
                    }
                }
            }
            if ((((JSONBullet)this.definition).bullet.isLongRange || !(this.gun.lastController instanceof IWrapperPlayer)) ^ this.world.isClient() && (!this.world.isClient() || InterfaceManager.clientInterface.getClientPlayer().getID().equals(this.gun.lastController.getID()))) {
                double amount = ((JSONBullet)this.definition).bullet.isHeat ? (double)((JSONBullet)this.definition).bullet.damage : this.velocity / this.initialVelocity * (double)((JSONBullet)this.definition).bullet.damage * (Double)ConfigSystem.settings.damage.bulletDamageFactor.value * (Double)((Map)ConfigSystem.settings.damage.packBulletDamageFactors.value).get(((JSONBullet)this.gun.lastLoadedBullet.definition).packID);
                Damage damage = new Damage(this.gun, this.boundingBox, amount);
                AEntityF_Multipart<?> hitMultipart = null;
                Collection<BoundingBoxHitResult> hitMultipartBoxes = null;
                IWrapperEntity hitExternalEntity = null;
                this.hitBlock = this.world.getBlockHit(this.position, this.motion);
                List<IWrapperEntity> attackedEntities = this.world.attackEntities(damage, this.motion, true);
                for (IWrapperEntity entity : attackedEntities) {
                    if (entity.equals(this.gun.lastController) || this.hitBlock != null && this.position.isFirstCloserThanSecond(this.hitBlock.hitPosition, entity.getPosition())) continue;
                    if (hitExternalEntity != null) {
                        this.helperPoint.set(hitExternalEntity.getPosition());
                        if (this.position.isFirstCloserThanSecond(this.helperPoint, entity.getPosition())) continue;
                    }
                    hitExternalEntity = entity;
                }
                if (hitExternalEntity != null) {
                    this.hitBlock = null;
                }
                this.multiparts.clear();
                this.multiparts.addAll(this.world.getEntitiesOfType(EntityVehicleF_Physics.class));
                this.multiparts.addAll(this.world.getEntitiesOfType(EntityPlacedPart.class));
                Point3D endPoint = this.position.copy().add(this.motion);
                BoundingBox bulletMovementBounds = new BoundingBox(this.position, endPoint);
                for (AEntityF_Multipart<?> multipart : this.multiparts) {
                    Collection<BoundingBoxHitResult> hitResults;
                    if (multipart.allParts.contains(this.gun) || (hitResults = multipart.getHitBoxes(this.position, endPoint, bulletMovementBounds, true)) == null) continue;
                    boolean anyHitboxCanBeHit = false;
                    for (BoundingBoxHitResult hitResult : hitResults) {
                        boolean hitboxCanBeHit = true;
                        if (hitMultipart != null) {
                            for (BoundingBoxHitResult oldHitResult : hitMultipartBoxes) {
                                if (!this.position.isFirstCloserThanSecond(oldHitResult.position, hitResult.position)) continue;
                                hitboxCanBeHit = false;
                                break;
                            }
                            if (!hitboxCanBeHit) break;
                        }
                        if (hitboxCanBeHit && this.hitBlock != null && this.position.isFirstCloserThanSecond(this.hitBlock.hitPosition, hitResult.position)) {
                            hitboxCanBeHit = false;
                        }
                        if (hitboxCanBeHit && hitExternalEntity != null && this.position.isFirstCloserThanSecond(hitExternalEntity.getPosition(), hitResult.position)) {
                            hitboxCanBeHit = false;
                        }
                        if (!hitboxCanBeHit) continue;
                        anyHitboxCanBeHit = true;
                        break;
                    }
                    if (!anyHitboxCanBeHit) continue;
                    hitMultipart = multipart;
                    hitMultipartBoxes = hitResults;
                }
                if (hitMultipart != null && hitMultipart.attackProjectile(damage, this, hitMultipartBoxes) != null) {
                    return;
                }
                if (hitExternalEntity != null) {
                    if (this.world.isClient()) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitExternalEntity(hitExternalEntity, damage));
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitGeneric(this.gun, this.bulletNumber, hitExternalEntity.getPosition(), ABlockBase.Axis.getFromVector(this.motion), HitType.ENTITY));
                        this.waitingOnActionPacket = true;
                    } else {
                        EntityBullet.performExternalEntityHitLogic(hitExternalEntity, damage);
                        EntityBullet.performGenericHitLogic(this.gun, this.bulletNumber, hitExternalEntity.getPosition(), ABlockBase.Axis.getFromVector(this.motion), HitType.ENTITY);
                    }
                    this.displayDebugMessage("HIT MC ENTITY " + hitExternalEntity.getName());
                    return;
                }
                if (this.hitBlock != null) {
                    if (this.hitBlock.side.xOffset > 0) {
                        this.hitBlock.hitPosition.x -= 1.0E-6;
                    }
                    if (this.hitBlock.side.yOffset > 0) {
                        this.hitBlock.hitPosition.y -= 1.0E-6;
                    }
                    if (this.hitBlock.side.zOffset > 0) {
                        this.hitBlock.hitPosition.z -= 1.0E-6;
                    }
                    if (this.world.isClient()) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitGeneric(this.gun, this.bulletNumber, this.hitBlock.hitPosition, this.hitBlock.side, HitType.BLOCK));
                        this.waitingOnActionPacket = true;
                    } else {
                        EntityBullet.performGenericHitLogic(this.gun, this.bulletNumber, this.hitBlock.hitPosition, this.hitBlock.side, HitType.BLOCK);
                    }
                    this.displayDebugMessage("HIT BLOCK AT " + this.hitBlock.blockPosition + " WITH ACTUAL POSITION " + this.hitBlock.hitPosition);
                    return;
                }
                if (((JSONBullet)this.definition).bullet.proximityFuze != 0.0f && this.distanceTraveled > (double)(((JSONBullet)this.definition).bullet.proximityFuze * 3.0f)) {
                    HitType hitType = null;
                    Point3D targetToHit = null;
                    if (this.targetPosition != null) {
                        if (this.position.distanceTo(this.targetPosition) < (double)((JSONBullet)this.definition).bullet.proximityFuze + this.velocity) {
                            targetToHit = this.targetPosition;
                            hitType = this.engineTargeted != null ? HitType.VEHICLE : HitType.ENTITY;
                            this.displayDebugMessage("PROX FUZE HIT TRACKED TARGET");
                        }
                    } else {
                        this.hitBlock = this.world.getBlockHit(this.position, this.motion.copy().normalize().scale((double)((JSONBullet)this.definition).bullet.proximityFuze + this.velocity));
                        if (this.hitBlock != null) {
                            targetToHit = this.hitBlock.hitPosition;
                            hitType = HitType.BLOCK;
                            this.displayDebugMessage("PROX FUZE HIT BLOCK");
                        } else {
                            Point3D stepDelta = this.motion.copy().normalize().scale(((JSONBullet)this.definition).bullet.proximityFuze);
                            int maxSteps = (int)Math.floor(this.velocity / (double)((JSONBullet)this.definition).bullet.proximityFuze);
                            this.proxBounds.globalCenter.set(this.position);
                            for (int step = 0; step < maxSteps; ++step) {
                                for (AEntityF_Multipart<?> multipart : this.multiparts) {
                                    if (!multipart.allParts.contains(this.gun) && multipart.encompassingBox.intersects(this.proxBounds)) {
                                        for (BoundingBox box : multipart.allCollisionBoxes) {
                                            if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.ATTACK) && !box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.BULLET) || !box.globalCenter.isDistanceToCloserThan(this.proxBounds.globalCenter, ((JSONBullet)this.definition).bullet.proximityFuze)) continue;
                                            targetToHit = box.globalCenter.copy();
                                            hitType = HitType.VEHICLE;
                                            this.displayDebugMessage("PROX FUZE HIT VEHICLE");
                                            break;
                                        }
                                    }
                                    if (targetToHit == null) continue;
                                    break;
                                }
                                if (targetToHit == null) {
                                    for (IWrapperEntity entity : this.world.getEntitiesWithin(this.proxBounds)) {
                                        Point3D entityPos = entity.getPosition();
                                        if (!entityPos.isDistanceToCloserThan(this.proxBounds.globalCenter, ((JSONBullet)this.definition).bullet.proximityFuze)) continue;
                                        targetToHit = entityPos.copy();
                                        hitType = HitType.ENTITY;
                                        this.displayDebugMessage("PROX FUZE HIT ENTITY " + entity.getName());
                                        break;
                                    }
                                }
                                if (targetToHit != null) break;
                                this.proxBounds.globalCenter.add(stepDelta);
                            }
                        }
                    }
                    if (hitType != null) {
                        double distanceToTarget = this.position.distanceTo(targetToHit);
                        if (distanceToTarget > (double)((JSONBullet)this.definition).bullet.proximityFuze) {
                            this.position.interpolate(targetToHit, (distanceToTarget - (double)((JSONBullet)this.definition).bullet.proximityFuze) / (double)((JSONBullet)this.definition).bullet.proximityFuze);
                        }
                        if (this.world.isClient()) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitGeneric(this.gun, this.bulletNumber, this.position, ABlockBase.Axis.getFromVector(this.motion), hitType));
                            this.waitingOnActionPacket = true;
                        } else {
                            EntityBullet.performGenericHitLogic(this.gun, this.bulletNumber, this.position, ABlockBase.Axis.getFromVector(this.motion), hitType);
                        }
                        return;
                    }
                }
                if (((JSONBullet)this.definition).bullet.airBurstDelay != 0 && this.ticksExisted > (long)((JSONBullet)this.definition).bullet.airBurstDelay) {
                    if (this.world.isClient()) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityBulletHitGeneric(this.gun, this.bulletNumber, this.position, ABlockBase.Axis.NONE, HitType.BURST));
                        this.waitingOnActionPacket = true;
                    } else {
                        EntityBullet.performGenericHitLogic(this.gun, this.bulletNumber, this.position, ABlockBase.Axis.NONE, HitType.BURST);
                    }
                    this.displayDebugMessage("BURST");
                    return;
                }
            }
            this.position.add(this.motion);
            if (!(this.isBomb || ((JSONBullet)this.definition).bullet.accelerationDelay != 0 && this.ticksExisted <= (long)((JSONBullet)this.definition).bullet.accelerationDelay)) {
                this.orientation.setToVector(this.motion, true);
            }
            if (this.relativeGunPos != null) {
                this.prevRelativeGunPos.set(this.relativeGunPos);
                this.relativeGunPos.set(this.position).subtract(this.gun.position).reOrigin(this.gun.orientation);
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (((JSONPart)this.gun.definition).gun.lockOnType == JSONPart.LockOnType.MANUAL) {
            this.gun.activeManualBullets.remove(this);
        }
        if (this.engineTargeted != null) {
            this.engineTargeted.vehicleOn.missilesIncoming.remove(this);
        }
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return true;
    }

    public double getRelativePos(int axisIndex, float partialTicks) {
        if (this.relativeGunPos == null) {
            this.relativeGunPos = this.position.copy().subtract(this.gun.position).reOrigin(this.gun.orientation);
            this.prevRelativeGunPos = this.relativeGunPos.copy();
        }
        switch (axisIndex) {
            case 1: {
                return partialTicks != 0.0f ? this.prevRelativeGunPos.x + (this.relativeGunPos.x - this.prevRelativeGunPos.x) * (double)partialTicks : this.relativeGunPos.x;
            }
            case 2: {
                return partialTicks != 0.0f ? this.prevRelativeGunPos.y + (this.relativeGunPos.y - this.prevRelativeGunPos.y) * (double)partialTicks : this.relativeGunPos.y;
            }
            case 3: {
                return partialTicks != 0.0f ? this.prevRelativeGunPos.z + (this.relativeGunPos.z - this.prevRelativeGunPos.z) * (double)partialTicks : this.relativeGunPos.z;
            }
        }
        throw new IllegalArgumentException("There are only three axis in the world you idiot!");
    }

    public static void performEntityHitLogic(AEntityE_Interactable<?> entity, Damage damage) {
        if (!entity.world.isClient()) {
            entity.attack(damage);
        }
    }

    public static void performExternalEntityHitLogic(IWrapperEntity entity, Damage damage) {
        if (!entity.getWorld().isClient()) {
            entity.attack(damage);
        }
    }

    public static void performBlockHitLogic(PartGun gun, int bulletNumber, Point3D blockPosition, ABlockBase.Axis blockSide) {
        if (!gun.world.isClient()) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityBulletHitBlock(gun, bulletNumber, blockPosition, blockSide));
            if (((JSONBullet)gun.lastLoadedBullet.definition).bullet.types.contains((Object)JSONBullet.BulletType.WATER)) {
                gun.world.extinguish(blockPosition, blockSide);
            } else if (((Boolean)ConfigSystem.settings.damage.bulletBlockBreaking.value).booleanValue()) {
                float hardnessHit = gun.world.getBlockHardness(blockPosition);
                if (hardnessHit > 0.0f && (double)hardnessHit <= Math.random() * (double)0.3f + (double)(0.3f * ((JSONBullet)gun.lastLoadedBullet.definition).bullet.diameter / 20.0f)) {
                    gun.world.destroyBlock(blockPosition, true);
                } else if (((JSONBullet)gun.lastLoadedBullet.definition).bullet.types.contains((Object)JSONBullet.BulletType.INCENDIARY)) {
                    gun.world.setToFire(blockPosition, blockSide);
                }
            }
        } else if (((JSONBullet)gun.lastLoadedBullet.definition).bullet.types.isEmpty()) {
            InterfaceManager.clientInterface.playBlockBreakSound(blockPosition);
        }
    }

    public static void performGenericHitLogic(PartGun gun, int bulletNumber, Point3D position, ABlockBase.Axis hitSide, HitType hitType) {
        EntityBullet bullet;
        if (!gun.world.isClient()) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityBulletHitGeneric(gun, bulletNumber, position, hitSide, hitType));
        }
        if (!gun.world.isClient() && ((Boolean)ConfigSystem.settings.damage.bulletExplosions.value).booleanValue() && ((JSONBullet)gun.lastLoadedBullet.definition).bullet.types.contains((Object)JSONBullet.BulletType.EXPLOSIVE)) {
            float blastSize = ((JSONBullet)gun.lastLoadedBullet.definition).bullet.blastStrength == 0.0f ? ((JSONBullet)gun.lastLoadedBullet.definition).bullet.diameter / 10.0f : ((JSONBullet)gun.lastLoadedBullet.definition).bullet.blastStrength;
            Point3D explosionPosition = position.copy();
            if (hitType == HitType.BLOCK) {
                explosionPosition.add(hitSide.xOffset, hitSide.yOffset, hitSide.zOffset);
            }
            gun.world.spawnExplosion(explosionPosition, blastSize, ((JSONBullet)gun.lastLoadedBullet.definition).bullet.types.contains((Object)JSONBullet.BulletType.INCENDIARY) && (Boolean)ConfigSystem.settings.damage.bulletBlockBreaking.value != false, (Boolean)ConfigSystem.settings.damage.bulletBlockBreaking.value);
        }
        if ((bullet = gun.world.getBullet(gun.uniqueUUID, bulletNumber)) != null) {
            bullet.position.set(position);
            bullet.lastHit = hitType;
            bullet.sideHit = hitSide;
            bullet.impactDespawnTimer = ((JSONBullet)bullet.definition).bullet.impactDespawnTime;
            if (bullet.world.isClient()) {
                bullet.spawnParticles(0.0f);
                bullet.updateSounds(0.0f);
            }
        }
        if (gun.currentBullet != null && gun.currentBullet.bulletNumber <= bulletNumber) {
            gun.currentBullet = null;
        }
    }

    public void displayDebugMessage(String message) {
        if (((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue() && this.gun.lastController instanceof IWrapperPlayer) {
            if (!this.world.isClient()) {
                IWrapperPlayer player = (IWrapperPlayer)this.gun.lastController;
                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.SYSTEM_DEBUG, message));
            } else {
                ((IWrapperPlayer)this.gun.lastController).displayChatMessage(LanguageSystem.SYSTEM_DEBUG, message);
            }
        }
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "bullet_hit": {
                return new ComputedVariable(this, variable, partialTicks -> this.lastHit != null ? 1.0 : 0.0, false);
            }
            case "bullet_burntime": {
                return new ComputedVariable(this, variable, partialTicks -> this.ticksExisted > (long)((JSONBullet)this.definition).bullet.burnTime ? 0.0 : (double)((long)((JSONBullet)this.definition).bullet.burnTime - this.ticksExisted), false);
            }
            case "bullet_hit_block": {
                return new ComputedVariable(this, variable, partialTicks -> HitType.BLOCK == this.lastHit ? 1.0 : 0.0, false);
            }
            case "bullet_hit_entity": {
                return new ComputedVariable(this, variable, partialTicks -> HitType.ENTITY == this.lastHit ? 1.0 : 0.0, false);
            }
            case "bullet_hit_vehicle": {
                return new ComputedVariable(this, variable, partialTicks -> HitType.VEHICLE == this.lastHit ? 1.0 : 0.0, false);
            }
            case "bullet_hit_armor": {
                return new ComputedVariable(this, variable, partialTicks -> HitType.ARMOR == this.lastHit ? 1.0 : 0.0, false);
            }
            case "bullet_hit_burst": {
                return new ComputedVariable(this, variable, partialTicks -> HitType.BURST == this.lastHit ? 1.0 : 0.0, false);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    @Override
    public boolean shouldSync() {
        return false;
    }

    @Override
    public boolean shouldSavePosition() {
        return false;
    }

    public static enum HitType {
        BLOCK,
        ENTITY,
        VEHICLE,
        ARMOR,
        BURST;

    }
}

