/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityEnergyCharger;
import minecrafttransportsimulator.blocks.tileentities.instances.ATileEntityFuelPump;
import minecrafttransportsimulator.entities.instances.AEntityVehicleE_Powered;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.items.instances.ItemPartInteractable;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketTileEntityChargerBattery;
import minecrafttransportsimulator.systems.LanguageSystem;

public class TileEntityCharger
extends ATileEntityFuelPump
implements ITileEntityEnergyCharger {
    public double internalBuffer;
    private static final int MAX_BUFFER = 1000;

    public TileEntityCharger(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        IWrapperItemStack stack = player.getHeldStack();
        AItemBase item = stack.getItem();
        if (item instanceof ItemPartInteractable) {
            ItemPartInteractable interactable = (ItemPartInteractable)item;
            if (((JSONPart)interactable.definition).interactable.interactionType == JSONPart.InteractableComponentType.BATTERY) {
                if (this.internalBuffer == 1000.0) {
                    IWrapperNBT data = stack.getData();
                    if (data == null) {
                        data = InterfaceManager.coreInterface.getNewNBTWrapper();
                    }
                    if (!data.getBoolean("batteryCharged")) {
                        data.setBoolean("batteryCharged", true);
                        stack.setData(data);
                        this.internalBuffer = 0.0;
                        InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityChargerBattery(this));
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_BATTERY_CHARGED, new Object[0]));
                    }
                } else {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_BATTERY_CHARGERLOW, new Object[0]));
                }
                return true;
            }
        }
        return super.interact(player);
    }

    @Override
    protected boolean hasFuel() {
        return this.internalBuffer > 0.0;
    }

    @Override
    protected AEntityVehicleE_Powered.FuelTankResult checkPump(EntityVehicleF_Physics vehicle) {
        for (APart part : vehicle.allParts) {
            if (!(part instanceof PartEngine) || ((JSONPart)part.definition).engine.type != JSONPart.EngineType.ELECTRIC) continue;
            return AEntityVehicleE_Powered.FuelTankResult.VALID;
        }
        return AEntityVehicleE_Powered.FuelTankResult.INVALID;
    }

    @Override
    public double fuelVehicle(double amount) {
        if (amount > this.internalBuffer) {
            amount = this.internalBuffer;
        }
        amount = this.connectedVehicle.fuelTank.fill("electricity", "wildcard", amount, true);
        this.internalBuffer -= amount;
        return amount;
    }

    @Override
    public double getChargeAmount() {
        double amountPurchasedRemaining;
        double amount = 1000.0 - this.internalBuffer;
        if (!this.isCreative && amount > (amountPurchasedRemaining = (double)this.fuelPurchased - this.fuelDispensedThisPurchase - this.internalBuffer)) {
            amount = amountPurchasedRemaining;
        }
        return amount;
    }

    @Override
    public void chargeEnergy(double amount) {
        this.internalBuffer += amount;
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "charger_active": {
                return new ComputedVariable(this, variable, partialTicks -> this.connectedVehicle != null ? 1.0 : 0.0, false);
            }
            case "charger_dispensed": {
                return new ComputedVariable(this, variable, partialTicks -> this.fuelDispensedThisConnection, false);
            }
            case "charger_free": {
                return new ComputedVariable(this, variable, partialTicks -> this.isCreative ? 1.0 : 0.0, false);
            }
            case "charger_purchased": {
                return new ComputedVariable(this, variable, partialTicks -> this.fuelPurchased, false);
            }
            case "charger_vehicle_percentage": {
                return new ComputedVariable(this, variable, partialTicks -> this.connectedVehicle != null ? this.connectedVehicle.fuelTank.getFluidLevel() / (double)this.connectedVehicle.fuelTank.getMaxLevel() : 0.0, false);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }
}

