/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLaneConnection;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;

public class RoadClickData {
    public final TileEntityRoad roadClicked;
    public final JSONRoadComponent.JSONLaneSector sectorClicked;
    public final boolean lanesOccupied;
    public final boolean clickedStart;
    public final Point3D genPosition;
    public final RotationMatrix genRotation;

    public RoadClickData(TileEntityRoad roadClicked, JSONRoadComponent.JSONLaneSector sectorClicked, boolean clickedStart, boolean curveStart) {
        this.roadClicked = roadClicked;
        this.sectorClicked = sectorClicked;
        this.clickedStart = clickedStart;
        if (((JSONRoadComponent)roadClicked.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC)) {
            if (clickedStart) {
                this.genRotation = new RotationMatrix().rotateY(180.0).multiply(roadClicked.dynamicCurve.startRotation);
                this.genPosition = curveStart ? new Point3D(((JSONRoadComponent)roadClicked.definition).road.roadWidth, 0.0, 0.0).rotate(roadClicked.dynamicCurve.startRotation) : new Point3D();
                this.genPosition.add(roadClicked.dynamicCurve.startPos);
            } else {
                this.genRotation = new RotationMatrix().rotateY(180.0).multiply(roadClicked.dynamicCurve.endRotation);
                this.genPosition = !curveStart ? new Point3D(-((JSONRoadComponent)roadClicked.definition).road.roadWidth, 0.0, 0.0).rotate(roadClicked.dynamicCurve.endRotation) : new Point3D();
                this.genPosition.add(roadClicked.dynamicCurve.endPos);
            }
            this.lanesOccupied = this.areDynamicLanesOccupied();
        } else {
            this.genRotation = new RotationMatrix().set(roadClicked.orientation).rotateY(180.0).multiply(sectorClicked.sectorStartAngles);
            this.genPosition = sectorClicked.sectorStartPos.copy().rotate(roadClicked.orientation).add(roadClicked.position);
            if (curveStart) {
                this.genPosition.add(new Point3D(-sectorClicked.borderOffset, 0.0, 0.0).rotate(this.genRotation));
            }
            this.lanesOccupied = this.areStaticLanesOccupied();
        }
    }

    private boolean areDynamicLanesOccupied() {
        for (RoadLane lane : this.roadClicked.lanes) {
            for (List<RoadLaneConnection> curveConnections : this.clickedStart ? lane.priorConnections : lane.nextConnections) {
                if (curveConnections.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areStaticLanesOccupied() {
        for (RoadLane lane : this.roadClicked.lanes) {
            if (lane.sectorNumber != ((JSONRoadComponent)this.roadClicked.definition).road.sectors.indexOf(this.sectorClicked)) continue;
            for (List<RoadLaneConnection> curveConnections : lane.priorConnections) {
                if (curveConnections.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

