/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketTileEntityLoaderConnection;

public abstract class ATileEntityLoader
extends TileEntityDecor {
    public PartInteractable connectedPart;

    public ATileEntityLoader(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
    }

    @Override
    public void update() {
        super.update();
        if (!this.world.isClient()) {
            if (this.connectedPart == null) {
                if (this.ticksExisted % 20L == 0L) {
                    this.updateNearestPart();
                }
            } else if (!this.connectedPart.isValid || !this.connectedPart.position.isDistanceToCloserThan(this.position, 10.0)) {
                this.updateNearestPart();
            }
            if (this.connectedPart != null) {
                if (this.isUnloader()) {
                    this.doUnloading();
                } else {
                    this.doLoading();
                }
            }
        }
    }

    protected void updateNearestPart() {
        PartInteractable nearestPart = null;
        double nearestDistance = 10.0;
        if (this.canOperate()) {
            for (PartInteractable interactablePart : this.world.getEntitiesOfType(PartInteractable.class)) {
                if (!this.canLoadPart(interactablePart) || !interactablePart.position.isDistanceToCloserThan(this.position, nearestDistance)) continue;
                nearestPart = interactablePart;
            }
        }
        if (nearestPart != null) {
            this.connectToPart(nearestPart);
            InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityLoaderConnection(this, true));
        } else if (this.connectedPart != null) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityLoaderConnection(this, false));
            this.connectToPart(null);
        }
    }

    public void connectToPart(PartInteractable part) {
        this.connectedPart = part;
    }

    public abstract boolean isUnloader();

    protected abstract boolean canOperate();

    protected abstract boolean canLoadPart(PartInteractable var1);

    protected abstract void doLoading();

    protected abstract void doUnloading();
}

