/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import minecrafttransportsimulator.baseclasses.Point3D;

public class RotationMatrix {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;
    public final Point3D angles = new Point3D();
    private final Point3D lastAngles = new Point3D();

    public RotationMatrix() {
        this.setToZero();
    }

    public RotationMatrix set(RotationMatrix other) {
        this.angles.set(other.angles);
        this.lastAngles.set(other.lastAngles);
        this.m00 = other.m00;
        this.m01 = other.m01;
        this.m02 = other.m02;
        this.m10 = other.m10;
        this.m11 = other.m11;
        this.m12 = other.m12;
        this.m20 = other.m20;
        this.m21 = other.m21;
        this.m22 = other.m22;
        return this;
    }

    public RotationMatrix multiply(RotationMatrix other) {
        double t00 = this.m00 * other.m00 + this.m01 * other.m10 + this.m02 * other.m20;
        double t01 = this.m00 * other.m01 + this.m01 * other.m11 + this.m02 * other.m21;
        double t02 = this.m00 * other.m02 + this.m01 * other.m12 + this.m02 * other.m22;
        double t10 = this.m10 * other.m00 + this.m11 * other.m10 + this.m12 * other.m20;
        double t11 = this.m10 * other.m01 + this.m11 * other.m11 + this.m12 * other.m21;
        double t12 = this.m10 * other.m02 + this.m11 * other.m12 + this.m12 * other.m22;
        double t20 = this.m20 * other.m00 + this.m21 * other.m10 + this.m22 * other.m20;
        double t21 = this.m20 * other.m01 + this.m21 * other.m11 + this.m22 * other.m21;
        double t22 = this.m20 * other.m02 + this.m21 * other.m12 + this.m22 * other.m22;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
        return this;
    }

    public RotationMatrix multiplyTranspose(RotationMatrix other) {
        double t00 = this.m00 * other.m00 + this.m01 * other.m01 + this.m02 * other.m02;
        double t01 = this.m00 * other.m10 + this.m01 * other.m11 + this.m02 * other.m12;
        double t02 = this.m00 * other.m20 + this.m01 * other.m21 + this.m02 * other.m22;
        double t10 = this.m10 * other.m00 + this.m11 * other.m01 + this.m12 * other.m02;
        double t11 = this.m10 * other.m10 + this.m11 * other.m11 + this.m12 * other.m12;
        double t12 = this.m10 * other.m20 + this.m11 * other.m21 + this.m12 * other.m22;
        double t20 = this.m20 * other.m00 + this.m21 * other.m01 + this.m22 * other.m02;
        double t21 = this.m20 * other.m10 + this.m21 * other.m11 + this.m22 * other.m12;
        double t22 = this.m20 * other.m20 + this.m21 * other.m21 + this.m22 * other.m22;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
        return this;
    }

    public RotationMatrix setToZero() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public RotationMatrix setToAngles(Point3D angles) {
        this.angles.set(angles);
        this.updateToAngles();
        return this;
    }

    public RotationMatrix setToVector(Point3D vector, boolean normalize) {
        this.angles.set(vector);
        if (normalize) {
            this.angles.normalize();
        }
        double pitch = -Math.toDegrees(Math.asin(this.angles.y));
        this.angles.y = Math.toDegrees(Math.atan2(this.angles.x, this.angles.z));
        this.angles.x = pitch;
        this.angles.z = 0.0;
        this.updateToAngles();
        return this;
    }

    public Point3D convertToAngles() {
        this.angles.x = Math.toDegrees(-Math.asin(this.m12));
        this.angles.y = Math.toDegrees(Math.atan2(this.m02, this.m22));
        this.angles.z = this.m12 == -1.0 ? 0.0 : (this.m12 == 1.0 ? 0.0 : Math.toDegrees(Math.atan2(this.m10, this.m11)));
        return this.angles;
    }

    public void bypassAngles() {
        this.angles.set(0.0, 0.0, 0.0);
        this.lastAngles.set(this.angles);
    }

    public RotationMatrix rotateX(double angle) {
        if (angle != 0.0) {
            double sin = Math.sin(Math.toRadians(angle));
            double cos = Math.cos(Math.toRadians(angle));
            double t01 = this.m01 * cos + this.m02 * sin;
            double t02 = this.m01 * -sin + this.m02 * cos;
            double t11 = this.m11 * cos + this.m12 * sin;
            double t12 = this.m11 * -sin + this.m12 * cos;
            double t21 = this.m21 * cos + this.m22 * sin;
            double t22 = this.m21 * -sin + this.m22 * cos;
            this.m01 = t01;
            this.m02 = t02;
            this.m11 = t11;
            this.m12 = t12;
            this.m21 = t21;
            this.m22 = t22;
        }
        return this;
    }

    public RotationMatrix rotateY(double angle) {
        if (angle != 0.0) {
            double sin = Math.sin(Math.toRadians(angle));
            double cos = Math.cos(Math.toRadians(angle));
            double t00 = this.m00 * cos + this.m02 * -sin;
            double t02 = this.m00 * sin + this.m02 * cos;
            double t10 = this.m10 * cos + this.m12 * -sin;
            double t12 = this.m10 * sin + this.m12 * cos;
            double t20 = this.m20 * cos + this.m22 * -sin;
            double t22 = this.m20 * sin + this.m22 * cos;
            this.m00 = t00;
            this.m02 = t02;
            this.m10 = t10;
            this.m12 = t12;
            this.m20 = t20;
            this.m22 = t22;
        }
        return this;
    }

    public RotationMatrix rotateZ(double angle) {
        if (angle != 0.0) {
            double sin = Math.sin(Math.toRadians(angle));
            double cos = Math.cos(Math.toRadians(angle));
            double t00 = this.m00 * cos + this.m01 * sin;
            double t01 = this.m00 * -sin + this.m01 * cos;
            double t10 = this.m10 * cos + this.m11 * sin;
            double t11 = this.m10 * -sin + this.m11 * cos;
            double t20 = this.m20 * cos + this.m21 * sin;
            double t21 = this.m20 * -sin + this.m21 * cos;
            this.m00 = t00;
            this.m01 = t01;
            this.m10 = t10;
            this.m11 = t11;
            this.m20 = t20;
            this.m21 = t21;
        }
        return this;
    }

    public RotationMatrix setToAxisAngle(double x, double y, double z, double angle) {
        if (angle != 0.0) {
            double sin = Math.sin(Math.toRadians(angle));
            double cos = Math.cos(Math.toRadians(angle));
            double invCos = 1.0 - cos;
            double xz = x * z;
            double xy = x * y;
            double yz = y * z;
            this.m00 = invCos * x * x + cos;
            this.m01 = invCos * xy - sin * z;
            this.m02 = invCos * xz + sin * y;
            this.m10 = invCos * xy + sin * z;
            this.m11 = invCos * y * y + cos;
            this.m12 = invCos * yz - sin * x;
            this.m20 = invCos * xz - sin * y;
            this.m21 = invCos * yz + sin * x;
            this.m22 = invCos * z * z + cos;
        } else {
            this.setToZero();
        }
        return this;
    }

    public RotationMatrix setToAxisAngle(Point3D point, double angle) {
        return this.setToAxisAngle(point.x, point.y, point.z, angle);
    }

    public Point3D rotate(Point3D point) {
        if (!this.lastAngles.equals(this.angles)) {
            this.updateToAngles();
        }
        double tx = this.m00 * point.x + this.m01 * point.y + this.m02 * point.z;
        double ty = this.m10 * point.x + this.m11 * point.y + this.m12 * point.z;
        point.z = this.m20 * point.x + this.m21 * point.y + this.m22 * point.z;
        point.x = tx;
        point.y = ty;
        return point;
    }

    public Point3D reOrigin(Point3D point) {
        if (!this.lastAngles.equals(this.angles)) {
            this.updateToAngles();
        }
        double tx = this.m00 * point.x + this.m10 * point.y + this.m20 * point.z;
        double ty = this.m01 * point.x + this.m11 * point.y + this.m21 * point.z;
        point.z = this.m02 * point.x + this.m12 * point.y + this.m22 * point.z;
        point.x = tx;
        point.y = ty;
        return point;
    }

    public RotationMatrix updateToAngles() {
        this.setToZero();
        this.rotateY(this.angles.y);
        this.rotateX(this.angles.x);
        this.rotateZ(this.angles.z);
        this.lastAngles.set(this.angles);
        return this;
    }

    public void interploate(RotationMatrix start, RotationMatrix end, double delta) {
        double segment2;
        double segment1;
        double quatEndw;
        double netValue = 1.0 + start.m00 + start.m11 + start.m22;
        double quatStartw = netValue <= 0.0 ? 0.0 : Math.sqrt(netValue) / 2.0;
        netValue = 1.0 + end.m00 + end.m11 + end.m22;
        double d = quatEndw = netValue <= 0.0 ? 0.0 : Math.sqrt(netValue) / 2.0;
        if (quatStartw < 1.0E-6 && quatEndw < 1.0E-6) {
            this.set(start);
            return;
        }
        double quatStarti = 1.0 / (4.0 * quatStartw) * (start.m21 - start.m12);
        double quatEndi = 1.0 / (4.0 * quatEndw) * (end.m21 - end.m12);
        double quatStartj = 1.0 / (4.0 * quatStartw) * (start.m02 - start.m20);
        double quatEndj = 1.0 / (4.0 * quatEndw) * (end.m02 - end.m20);
        double quatStartk = 1.0 / (4.0 * quatStartw) * (start.m10 - start.m01);
        double quatEndk = 1.0 / (4.0 * quatEndw) * (end.m10 - end.m01);
        double dotProduct = quatStarti * quatEndi + quatStartj * quatEndj + quatStartk * quatEndk + quatStartw * quatEndw;
        if (dotProduct < 0.0) {
            dotProduct = -dotProduct;
            quatEndi = -quatEndi;
            quatEndj = -quatEndj;
            quatEndk = -quatEndk;
            quatEndw = -quatEndw;
        }
        if (1.0 - dotProduct > 1.0E-6) {
            double angle = Math.acos(dotProduct);
            double sinAngle = Math.sin(angle);
            segment1 = Math.sin((1.0 - delta) * angle) / sinAngle;
            segment2 = Math.sin(delta * angle) / sinAngle;
        } else {
            segment1 = 1.0 - delta;
            segment2 = delta;
        }
        double quatNetr = segment1 * quatStartw + segment2 * quatEndw;
        double quatNeti = segment1 * quatStarti + segment2 * quatEndi;
        double quatNetj = segment1 * quatStartj + segment2 * quatEndj;
        double quatNetk = segment1 * quatStartk + segment2 * quatEndk;
        this.m00 = 1.0 - 2.0 * quatNetj * quatNetj - 2.0 * quatNetk * quatNetk;
        this.m10 = 2.0 * (quatNeti * quatNetj + quatNetr * quatNetk);
        this.m20 = 2.0 * (quatNeti * quatNetk - quatNetr * quatNetj);
        this.m01 = 2.0 * (quatNeti * quatNetj - quatNetr * quatNetk);
        this.m11 = 1.0 - 2.0 * quatNeti * quatNeti - 2.0 * quatNetk * quatNetk;
        this.m21 = 2.0 * (quatNetj * quatNetk + quatNetr * quatNeti);
        this.m02 = 2.0 * (quatNeti * quatNetk + quatNetr * quatNetj);
        this.m12 = 2.0 * (quatNetj * quatNetk - quatNetr * quatNeti);
        this.m22 = 1.0 - 2.0 * quatNeti * quatNeti - 2.0 * quatNetj * quatNetj;
        this.bypassAngles();
    }
}

