/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import mcinterface1122.PacketEntityCSHandshakeClient;
import mcinterface1122.PacketEntityCSHandshakeServer;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperPlayer;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IInterfacePacket;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

class InterfacePacket
implements IInterfacePacket {
    private static final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("mts");
    private static final BiMap<Byte, Class<? extends APacketBase>> packetMappings = HashBiMap.create();

    InterfacePacket() {
    }

    public static void init() {
        byte packetIndex;
        network.registerMessage(WrapperHandler.class, WrapperPacket.class, 0, Side.CLIENT);
        network.registerMessage(WrapperHandler.class, WrapperPacket.class, 1, Side.SERVER);
        byte by = packetIndex = 0;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by, PacketEntityCSHandshakeClient.class);
        byte by2 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by2, PacketEntityCSHandshakeServer.class);
        APacketBase.initPackets(packetIndex);
    }

    @Override
    public void registerPacket(byte packetIndex, Class<? extends APacketBase> packetClass) {
        packetMappings.put((Object)packetIndex, packetClass);
    }

    @Override
    public byte getPacketIndex(APacketBase packet) {
        return (Byte)packetMappings.inverse().get(packet.getClass());
    }

    @Override
    public void sendToServer(APacketBase packet) {
        network.sendToServer((IMessage)new WrapperPacket(packet));
    }

    @Override
    public void sendToAllClients(APacketBase packet) {
        network.sendToAll((IMessage)new WrapperPacket(packet));
    }

    @Override
    public void sendToPlayer(APacketBase packet, IWrapperPlayer player) {
        network.sendTo((IMessage)new WrapperPacket(packet), (EntityPlayerMP)((WrapperPlayer)player).player);
    }

    private static AWrapperWorld getServerWorld(MessageContext ctx) {
        return WrapperWorld.getWrapperFor(ctx.getServerHandler().field_147369_b.field_70170_p);
    }

    @Override
    public void writeDataToBuffer(IWrapperNBT data, ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.func_150786_a(((WrapperNBT)data).tag);
    }

    @Override
    public WrapperNBT readDataFromBuffer(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        try {
            return new WrapperNBT(pb.func_150793_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class WrapperHandler
    implements IMessageHandler<WrapperPacket, IMessage> {
        public IMessage onMessage(WrapperPacket message, MessageContext ctx) {
            if (message.packet.runOnMainThread()) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                    AWrapperWorld world = ctx.side.isServer() ? InterfacePacket.getServerWorld(ctx) : InterfaceManager.clientInterface.getClientWorld();
                    if (world != null) {
                        message.packet.handle(world);
                    }
                });
            } else if (ctx.side.isServer()) {
                message.packet.handle(InterfacePacket.getServerWorld(ctx));
            } else {
                message.packet.handle(InterfaceManager.clientInterface.getClientWorld());
            }
            return null;
        }
    }

    public static class WrapperPacket
    implements IMessage {
        private APacketBase packet;

        public WrapperPacket() {
        }

        public WrapperPacket(APacketBase packet) {
            this.packet = packet;
        }

        public void fromBytes(ByteBuf buf) {
            byte packetIndex = buf.readByte();
            try {
                Class packetClass = (Class)packetMappings.get((Object)packetIndex);
                this.packet = (APacketBase)packetClass.getConstructor(ByteBuf.class).newInstance(buf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            this.packet.writeToBuffer(buf);
        }
    }
}

