/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.input.Keyboard;

public class ClientUtils {
    private ClientUtils() {
    }

    public static boolean hasShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean hasCtrlDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static void renderBoxInLevel(double minX, double maxX, double minZ, double maxZ, double height, int rgbColor) {
        float r = (float)(rgbColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgbColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgbColor & 0xFF) / 255.0f;
        double shrinkFactor = 0.002f;
        minX += shrinkFactor;
        minZ += shrinkFactor;
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        RenderGlobal.func_189694_a((double)minX, (double)shrinkFactor, (double)minZ, (double)(maxX -= shrinkFactor), (double)(height -= shrinkFactor), (double)(maxZ -= shrinkFactor), (float)r, (float)g, (float)b, (float)1.0f);
        GlStateManager.func_179145_e();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        GlStateManager.func_179098_w();
    }

    public static void fillHorizontalGradient(int zLevel, int left, int top, int right, int bottom, int fromColor, int toColor) {
        float fromAlpha = (float)(fromColor >> 24 & 0xFF) / 255.0f;
        float fromRed = (float)(fromColor >> 16 & 0xFF) / 255.0f;
        float fromGreen = (float)(fromColor >> 8 & 0xFF) / 255.0f;
        float fromBlue = (float)(fromColor & 0xFF) / 255.0f;
        float toAlpha = (float)(toColor >> 24 & 0xFF) / 255.0f;
        float toRed = (float)(toColor >> 16 & 0xFF) / 255.0f;
        float toGreen = (float)(toColor >> 8 & 0xFF) / 255.0f;
        float toBlue = (float)(toColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(toRed, toGreen, toBlue, toAlpha).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(fromRed, fromGreen, fromBlue, fromAlpha).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(fromRed, fromGreen, fromBlue, fromAlpha).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(toRed, toGreen, toBlue, toAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float[] RGBtoHSB(int r, int g, int b) {
        float hue;
        int cmin;
        float[] hsb = new float[3];
        int cmax = r > g ? r : g;
        int n = cmin = r < g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsb[0] = hue;
        hsb[1] = saturation;
        hsb[2] = brightness;
        return hsb;
    }
}

