/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blocks.SecureRedstoneInterfaceBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SecureRedstoneInterfaceDishModel;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class SecureRedstoneInterfaceRenderer
extends TileEntitySpecialRenderer<SecureRedstoneInterfaceBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/blocks/secure_redstone_interface_dish.png");
    private final SecureRedstoneInterfaceDishModel model = new SecureRedstoneInterfaceDishModel();

    public void render(SecureRedstoneInterfaceBlockEntity be, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state;
        BlockEntityRenderDelegate.DISGUISED_BLOCK.tryRenderDelegate(be, x, y, z, partialTicks, destroyStage, alpha);
        if (!be.isModuleEnabled(ModuleType.DISGUISE) && !((Boolean)(state = be.func_145831_w().func_180495_p(be.func_174877_v())).func_177229_b((IProperty)SecureRedstoneInterfaceBlock.SENDER)).booleanValue()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            this.adjustForRotation(state);
            GlStateManager.func_179137_b((double)0.0, (double)-0.4999, (double)0.0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
            this.model.rotate(Utils.lerp(partialTicks, be.getOriginalDishRotationDegrees(), be.getDishRotationDegrees()));
            this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
        }
    }

    private void adjustForRotation(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)SecureRedstoneInterfaceBlock.FACING);
        switch (facing) {
            case DOWN: {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            default: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }
}

