/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdateSliderValue
implements IMessage {
    private BlockPos pos;
    private int id;
    private double value;

    public UpdateSliderValue() {
    }

    public UpdateSliderValue(BlockPos pos, int id, double v) {
        this.pos = pos;
        this.id = id;
        this.value = v;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.id);
        buf.writeDouble(this.value);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.id = buf.readInt();
        this.value = buf.readDouble();
    }

    public static class Handler
    implements IMessageHandler<UpdateSliderValue, IMessage> {
        public IMessage onMessage(UpdateSliderValue message, MessageContext context) {
            Utils.addScheduledTask(context.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                TileEntity te = player.field_70170_p.func_175625_s(message.pos);
                if (!player.func_175149_v() && te instanceof ICustomizable && !(te instanceof IOwnable) || ((IOwnable)te).isOwnedBy((Entity)player)) {
                    Option<?> o = ((ICustomizable)te).customOptions()[message.id];
                    if (o instanceof Option.DoubleOption) {
                        ((Option.DoubleOption)o).setValue(message.value);
                    } else if (o instanceof Option.IntOption) {
                        ((Option.IntOption)o).setValue((int)message.value);
                    }
                    ((ICustomizable)te).onOptionChanged(((ICustomizable)te).customOptions()[message.id]);
                    if (te instanceof CustomizableBlockEntity) {
                        ((CustomizableBlockEntity)te).sync();
                    }
                }
            });
            return null;
        }
    }
}

