/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CheckBriefcasePasscode
implements IMessage {
    private String passcode;

    public CheckBriefcasePasscode() {
    }

    public CheckBriefcasePasscode(String passcode) {
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.passcode);
    }

    public void fromBytes(ByteBuf buf) {
        this.passcode = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<CheckBriefcasePasscode, IMessage> {
        public IMessage onMessage(CheckBriefcasePasscode message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand((EntityPlayer)player, SCContent.briefcase);
                if (!briefcase.func_190926_b()) {
                    NBTTagCompound tag;
                    String tagCode;
                    if (PasscodeUtils.isOnCooldown((EntityPlayer)player)) {
                        PlayerUtils.sendMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentString("SecurityCraft"), (ITextComponent)Utils.localize("messages.securitycraft:passcodeProtected.onCooldown", new Object[0]), TextFormatting.RED);
                        if (ConfigHandler.passcodeSpamLogWarningEnabled) {
                            SecurityCraft.LOGGER.warn(String.format(ConfigHandler.passcodeSpamLogWarning, player.func_146103_bH().getName(), Utils.localize(SCContent.briefcase, new Object[0]).func_150261_e(), player.field_70170_p.field_73011_w.func_186058_p() + " " + player.func_180425_c()));
                        }
                        return;
                    }
                    if (!briefcase.func_77942_o()) {
                        briefcase.func_77982_d(new NBTTagCompound());
                    }
                    if ((tagCode = (tag = briefcase.func_77978_p()).func_74779_i("passcode")).length() == 4) {
                        BriefcaseItem.hashAndSetPasscode(tag, PasscodeUtils.hashPasscodeWithoutSalt(tagCode), p -> BriefcaseItem.checkPasscode(player, message.passcode, PasscodeUtils.bytesToString(p), tag));
                    } else {
                        BriefcaseItem.checkPasscode(player, message.passcode, tagCode, tag);
                    }
                }
            });
            return null;
        }
    }
}

