/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blocks.CageTrapBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class UniversalBlockRemoverItem
extends Item {
    private static final ITextComponent DISABLED_ITEM_TOOLTIP = new TextComponentTranslation("tooltip.securitycraft:universal_block_remover.disabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!ConfigHandler.vanillaToolBlockBreaking) {
            TileEntity be = world.func_175625_s(pos);
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (be != null && this.isOwnableBlock(block, be)) {
                boolean isDefault;
                if (be instanceof DisplayCaseBlockEntity && ((DisplayCaseBlockEntity)be).isOpen() && ((DisplayCaseBlockEntity)be).getDisplayedStack().func_190926_b()) {
                    return EnumActionResult.PASS;
                }
                IOwnable ownable = (IOwnable)be;
                Owner owner = ownable.getOwner();
                boolean bl = isDefault = owner.getName().equals("owner") && owner.getUUID().equals("ownerUUID");
                if (!(ConfigHandler.allowBreakingNonOwnedBlocks || isDefault && state.func_177230_c() == SCContent.frame || ownable.isOwnedBy((Entity)player))) {
                    if (!(block instanceof IBlockMine || be.func_145838_q() instanceof IDisguisable && !(((ItemBlock)((IDisguisable)be.func_145838_q()).getDisguisedStack((IBlockAccess)world, pos).func_77973_b()).func_179223_d() instanceof IDisguisable))) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(owner)), TextFormatting.RED);
                        return EnumActionResult.SUCCESS;
                    }
                    return EnumActionResult.FAIL;
                }
                if (be instanceof IModuleInventory) {
                    ((IModuleInventory)be).dropAllModules();
                }
                if (block == SCContent.laserBlock) {
                    LaserBlockBlockEntity te = (LaserBlockBlockEntity)be;
                    for (ItemStack module : te.getInventory()) {
                        if (module.func_190926_b()) continue;
                        te.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)module.func_77973_b()).getModuleType(), false), te);
                    }
                    if (!world.field_72995_K) {
                        world.func_175655_b(pos, true);
                        LaserBlock.destroyAdjacentLasers(world, pos);
                        player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                    }
                } else if (block == SCContent.cageTrap) {
                    if (!world.field_72995_K) {
                        CageTrapBlock.disassembleIronBars(state, world, pos, owner);
                        world.func_175655_b(pos, true);
                        player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                    }
                } else {
                    InventoryScannerBlockEntity te;
                    if (block == SCContent.inventoryScanner && (te = InventoryScannerBlock.getConnectedInventoryScanner(world, pos)) != null) {
                        te.getInventory().clear();
                    }
                    if (!world.field_72995_K) {
                        world.func_175655_b(pos, true);
                        block.func_176206_d(world, pos, state);
                        player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public void func_77624_a(ItemStack stack, World level, List<String> tooltipComponents, ITooltipFlag tooltipFlag) {
        if (ConfigHandler.vanillaToolBlockBreaking) {
            tooltipComponents.add(DISABLED_ITEM_TOOLTIP.func_150254_d());
        }
        super.func_77624_a(stack, level, tooltipComponents, tooltipFlag);
    }

    private boolean isOwnableBlock(Block block, TileEntity tileEntity) {
        return tileEntity instanceof OwnableBlockEntity || tileEntity instanceof IOwnable || block instanceof OwnableBlock;
    }
}

