/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ReinforcedLapisAndCoalBlock
extends OwnableBlock
implements IOverlayDisplay,
IReinforcedBlock {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public ReinforcedLapisAndCoalBlock() {
        super(Material.field_151576_e);
        this.func_149722_s();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.LAPIS)));
    }

    @Override
    public float func_180647_a(IBlockState state, EntityPlayer player, World level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.defaultPlayerRelativeBlockHardness(x$0, x$1, x$2, x$3), this.convertToVanillaState((IBlockState)state).func_177230_c().field_149782_v, state, player, level, pos);
    }

    @Override
    public boolean canHarvestBlock(IBlockAccess level, BlockPos pos, EntityPlayer player) {
        return ConfigHandler.alwaysDrop || super.canHarvestBlock(level, pos, player);
    }

    public Material func_149688_o(IBlockState state) {
        return this.convertToVanillaState(state).func_185904_a();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getSoundType(vanillaState, world, pos, entity);
    }

    public String getHarvestTool(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestTool(vanillaState);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().isToolEffective(type, vanillaState);
    }

    public int getHarvestLevel(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestLevel(vanillaState);
    }

    public boolean func_149751_l(IBlockState state) {
        return this.convertToVanillaState(state).func_185895_e();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getColor();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        EnumType[] values;
        for (EnumType type : values = EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.reinforcedLapisAndCoalBlocks), 1, this.func_176201_c(state));
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return state.func_177230_c() == this;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(Blocks.field_150368_y, Blocks.field_150402_ci);
    }

    @Override
    public IBlockState convertToReinforcedState(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150368_y) {
            return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.LAPIS));
        }
        if (block == Blocks.field_150402_ci) {
            return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.COAL));
        }
        return state;
    }

    @Override
    public IBlockState convertToVanillaState(IBlockState state) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case LAPIS: {
                return Blocks.field_150368_y.func_176223_P();
            }
            case COAL: {
                return Blocks.field_150402_ci.func_176223_P();
            }
        }
        return state;
    }

    @Override
    public ItemStack convertToReinforcedStack(ItemStack stackToConvert, Block blockToConvert) {
        int index = this.getVanillaBlocks().indexOf(blockToConvert);
        if (index >= 0) {
            return new ItemStack((Block)this, 1, index);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack convertToVanillaStack(ItemStack stackToConvert) {
        int meta = stackToConvert.func_77960_j();
        if (meta >= 0 && meta <= 1) {
            return new ItemStack(this.getVanillaBlocks().get(meta));
        }
        return ItemStack.field_190927_a;
    }

    public static enum EnumType implements IStringSerializable
    {
        LAPIS(0, "lapis", MapColor.field_151652_H),
        COAL(1, "coal", MapColor.field_151646_E);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor color;

        private EnumType(int meta, String name, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.color = color;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public MapColor getColor() {
            return this.color;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

