/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableFenceGateBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ReinforcedFenceGateBlock
extends OwnableFenceGateBlock
implements IReinforcedBlock {
    private final Block vanillaBlock;

    public ReinforcedFenceGateBlock(BlockPlanks.EnumType type, Block vanillaBlock) {
        super(type, SoundEvents.field_187613_bi, SoundEvents.field_187610_bh);
        this.vanillaBlock = vanillaBlock;
        this.func_149672_a(SoundType.field_185848_a);
        this.destroyTimeForOwner = this.getVanillaBlocks().get((int)0).field_149782_v;
    }

    @Override
    public boolean canHarvestBlock(IBlockAccess level, BlockPos pos, EntityPlayer player) {
        return ConfigHandler.alwaysDrop || super.canHarvestBlock(level, pos, player);
    }

    public Material func_149688_o(IBlockState state) {
        return this.convertToVanillaState(state).func_185904_a();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getSoundType(vanillaState, world, pos, entity);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess level, BlockPos pos) {
        return this.convertToVanillaState(state).func_185909_g(level, pos);
    }

    public String getHarvestTool(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestTool(vanillaState);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().isToolEffective(type, vanillaState);
    }

    public int getHarvestLevel(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestLevel(vanillaState);
    }

    public boolean func_149751_l(IBlockState state) {
        return this.convertToVanillaState(state).func_185895_e();
    }

    public boolean func_180639_a(World level, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        AllowlistOnlyBlockEntity be;
        TileEntity te = level.func_175625_s(pos);
        if (te instanceof AllowlistOnlyBlockEntity && ((be = (AllowlistOnlyBlockEntity)te).isOwnedBy((Entity)player) || be.isAllowed((Entity)player))) {
            if (((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue()) {
                state = state.func_177226_a((IProperty)field_176466_a, (Comparable)Boolean.valueOf(false));
                level.func_180501_a(pos, state, 10);
            } else {
                EnumFacing playerRotation = EnumFacing.func_176733_a((double)player.field_70177_z);
                if (state.func_177229_b((IProperty)field_185512_D) == playerRotation.func_176734_d()) {
                    state = state.func_177226_a((IProperty)field_185512_D, (Comparable)playerRotation);
                }
                state = state.func_177226_a((IProperty)field_176466_a, (Comparable)Boolean.valueOf(true));
                level.func_180501_a(pos, state, 10);
            }
            boolean isOpen = (Boolean)state.func_177229_b((IProperty)field_176466_a);
            level.func_184133_a(null, pos, isOpen ? this.openSound : this.closeSound, SoundCategory.BLOCKS, 1.0f, SecurityCraft.RANDOM.nextFloat() * 0.1f + 0.9f);
        }
        return true;
    }

    @Override
    public boolean func_189539_a(IBlockState state, World level, BlockPos pos, int id, int param) {
        TileEntity be = level.func_175625_s(pos);
        return be != null && be.func_145842_c(id, param);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new AllowlistOnlyBlockEntity();
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(this.vanillaBlock);
    }
}

