/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.GlobalPos;
import net.geforcemods.securitycraft.network.client.InteractWithFrame;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class FrameBlock
extends OwnableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public FrameBlock(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185852_e);
        this.destroyTimeForOwner = 5.0f;
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public float func_180647_a(IBlockState state, EntityPlayer player, World level, BlockPos pos) {
        return BlockUtils.getDestroyProgress(this::defaultPlayerRelativeBlockHardness, this.destroyTimeForOwner, state, player, level, pos, true);
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == state.func_177229_b((IProperty)FACING) ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (stack.func_77973_b() == SCContent.cameraMonitor && te instanceof FrameBlockEntity) {
            FrameBlockEntity be = (FrameBlockEntity)te;
            if (!ConfigHandler.frameFeedViewingEnabled) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.frame, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:frame.disabled", new Object[0]), TextFormatting.RED);
            } else if (!be.isOwnedBy((Entity)player)) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.frame, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", be.getOwner().getName()), TextFormatting.RED);
            } else if (stack.func_77942_o()) {
                List<Pair<GlobalPos, String>> cameras = CameraMonitorItem.getCameraPositions(stack.func_77978_p());
                if (!cameras.isEmpty()) {
                    if (be.applyCameraPositions(stack) && !world.field_72995_K) {
                        be.unsetCurrentCameraOnServer();
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.frame, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:frame.camerasSet", new Object[0]), TextFormatting.GREEN);
                    }
                } else {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.frame, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:frame.emptyMonitor", new Object[0]), TextFormatting.RED);
                }
            }
            return true;
        }
        if (stack.func_77973_b() == SCContent.keyPanel) {
            return false;
        }
        if (te instanceof FrameBlockEntity) {
            FrameBlockEntity be = (FrameBlockEntity)te;
            boolean ownedByUser = be.isOwnedBy((Entity)player);
            if (be.isDisabled()) {
                player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (!ConfigHandler.frameFeedViewingEnabled) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.frame, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:frame.disabled", new Object[0]), TextFormatting.RED);
            } else if (!world.field_72995_K && player instanceof EntityPlayerMP && (ownedByUser || be.isAllowed((Entity)player)) && !be.getCameraPositions().isEmpty()) {
                SecurityCraft.network.sendTo((IMessage)new InteractWithFrame(pos, ownedByUser), (EntityPlayerMP)player);
            }
            return true;
        }
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta > 6));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 6 : 0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World level, IBlockState state) {
        return new FrameBlockEntity();
    }
}

