/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.playerupgrade;

import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import com.lothrazar.cyclicmagic.util.UtilFurnace;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlayerAbilitiesModule
extends BaseEventModule
implements IHasConfig {
    private static final int LADDER_ROTATIONLIMIT = -78;
    private static final double LADDER_SPEED = 0.1;
    private boolean signSkullName;
    private boolean easyEnderChest;
    private boolean fastLadderClimb;
    private boolean nameVillagerTag;
    private boolean passThroughClick;
    private boolean armorStandSwap;
    private boolean stardewFurnace;
    private static final EntityEquipmentSlot[] armorStandEquipment = new EntityEquipmentSlot[]{EntityEquipmentSlot.OFFHAND, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (this.passThroughClick) {
            EnumFacing face;
            BlockPos posBehind;
            IBlockState stuffBehind;
            EntityPlayer entityPlayer = event.getEntityPlayer();
            BlockPos pos = event.getPos();
            World worldObj = event.getWorld();
            if (pos == null) {
                return;
            }
            if (entityPlayer.func_70093_af()) {
                return;
            }
            IBlockState state = event.getWorld().func_180495_p(pos);
            if (state != null && (state.func_177230_c() == Blocks.field_150444_as || state.func_177230_c() == Blocks.field_180394_cL) && (stuffBehind = worldObj.func_180495_p(posBehind = pos.func_177972_a((face = EnumFacing.func_82600_a((int)state.func_177230_c().func_176201_c(state))).func_176734_d()))) != null && stuffBehind.func_177230_c() != null && worldObj.func_175625_s(posBehind) != null) {
                stuffBehind.func_177230_c().func_180639_a(worldObj, posBehind, stuffBehind, entityPlayer, event.getHand(), event.getFace(), 0.0f, 0.0f, 0.0f);
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer entityPlayer;
        if (this.nameVillagerTag) {
            entityPlayer = event.getEntityPlayer();
            ItemStack held = entityPlayer.func_184586_b(event.getHand());
            Entity target = event.getTarget();
            if (held != null && held.func_77973_b() == Items.field_151057_cb && held.func_82837_s() && target instanceof EntityVillager) {
                EntityVillager v = (EntityVillager)target;
                v.func_96094_a(held.func_82833_r());
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
                }
                event.setCanceled(true);
            }
        }
        if (this.passThroughClick) {
            EntityItemFrame frame;
            EnumFacing face;
            BlockPos pos;
            BlockPos posBehind;
            IBlockState stuffBehind;
            entityPlayer = event.getEntityPlayer();
            Entity target = event.getTarget();
            World worldObj = event.getWorld();
            if (target instanceof EntityItemFrame && !entityPlayer.func_70093_af() && (stuffBehind = worldObj.func_180495_p(posBehind = (pos = target.func_180425_c()).func_177972_a((face = (frame = (EntityItemFrame)target).func_184172_bi()).func_176734_d()).func_177977_b())) != null && stuffBehind.func_177230_c() != null && worldObj.func_175625_s(posBehind) != null) {
                stuffBehind.func_177230_c().func_180639_a(worldObj, posBehind, stuffBehind, entityPlayer, event.getHand(), face, 0.0f, 0.0f, 0.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.signSkullName) {
            EntityPlayer entityPlayer = event.getEntityPlayer();
            BlockPos pos = event.getPos();
            World worldObj = event.getWorld();
            if (pos == null) {
                return;
            }
            ItemStack held = entityPlayer.func_184614_ca();
            if (held == null) {
                held = entityPlayer.func_184592_cb();
            }
            TileEntity container = worldObj.func_175625_s(pos);
            if (held != null && held.func_77973_b() == Items.field_151144_bL && held.func_77952_i() == 3 && container != null && container instanceof TileEntitySign) {
                TileEntitySign sign = (TileEntitySign)container;
                String firstLine = sign.field_145915_a[0].func_150260_c();
                if (firstLine == null) {
                    firstLine = "";
                }
                if (firstLine.isEmpty() || firstLine.split(" ").length == 0) {
                    held.func_77982_d(null);
                } else {
                    firstLine = firstLine.split(" ")[0];
                    NBTTagCompound nbt = UtilNBT.getItemStackNBT(held);
                    nbt.func_74778_a("SkullOwner", firstLine);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (this.fastLadderClimb && event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).func_70617_f_() && !player.func_70093_af() && player.field_191988_bg == 0.0f && player.field_70125_A < -78.0f) {
            player.func_70024_g(0.0, 0.1, 0.0);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        World worldObj = event.getWorld();
        ItemStack held = event.getItemStack();
        if (this.stardewFurnace) {
            if (entityPlayer.field_71075_bZ.field_75098_d || pos == null || held.func_77973_b() instanceof ItemPickaxe) {
                return;
            }
            int playerSlot = 0;
            boolean wasMain = event.getHand() == EnumHand.MAIN_HAND;
            playerSlot = wasMain ? entityPlayer.field_71071_by.field_70461_c : 40;
            TileEntity tile = worldObj.func_175625_s(pos);
            if (tile instanceof TileEntityFurnace) {
                TileEntityFurnace furnace = (TileEntityFurnace)tile;
                if (held.func_190926_b()) {
                    UtilFurnace.extractFurnaceOutput(furnace, entityPlayer);
                } else if (UtilFurnace.canBeSmelted(held) && !(held.func_77973_b() instanceof ItemTool)) {
                    UtilFurnace.tryMergeStackIntoSlot(furnace, entityPlayer, playerSlot, 0);
                } else if (UtilFurnace.isFuel(held)) {
                    UtilFurnace.tryMergeStackIntoSlot(furnace, entityPlayer, playerSlot, 1);
                }
            }
        }
        if (this.easyEnderChest && !held.func_190926_b() && held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150477_bB)) {
            entityPlayer.func_71007_a((IInventory)entityPlayer.func_71005_bN());
        }
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (this.armorStandSwap) {
            if (event.getWorld().field_72995_K) {
                return;
            }
            if (event.getTarget() == null || !(event.getTarget() instanceof EntityArmorStand)) {
                return;
            }
            EntityArmorStand entityStand = (EntityArmorStand)event.getTarget();
            EntityPlayer player = event.getEntityPlayer();
            if (!player.func_70093_af()) {
                return;
            }
            event.setCanceled(true);
            for (EntityEquipmentSlot slot : armorStandEquipment) {
                ItemStack itemPlayer = player.func_184582_a(slot);
                ItemStack itemArmorstand = entityStand.func_184582_a(slot);
                player.func_184201_a(slot, itemArmorstand);
                entityStand.func_184201_a(slot, itemPlayer);
            }
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.player";
        this.nameVillagerTag = config.getBoolean("Villager Nametag", category, true, "Let players name villagers with nametags");
        this.stardewFurnace = config.getBoolean("Furnace Speed", category, true, "Stardew Furnaces: Quickly fill a furnace by hitting it with fuel or an item, or interact with an empty hand to pull out the results [Inspired by Stardew Valley.  Left click only]");
        this.passThroughClick = config.getBoolean("Pass-Through Click", category, true, "Open chests (and other containers) by passing right through the attached signs, banners, and item frames");
        this.easyEnderChest = config.getBoolean("Easy Enderchest", category, true, "Open ender chest without placing it down, just attack with it");
        this.fastLadderClimb = config.getBoolean("Faster Ladders", category, true, "Allows you to quickly climb ladders by looking up instead of moving forward");
        config.addCustomCategoryComment(category, "Player Abilities and interactions");
        this.signSkullName = config.getBoolean("Name Player Skulls with Sign", category, true, "Use a player skull on a sign to name the skull based on the top line");
        category = "cyclicmagic.blocks";
        this.armorStandSwap = config.getBoolean("ArmorStandSwap", category, true, "Swap armor with a stand whenever you interact while sneaking");
    }
}

