/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.findspawner;

import com.lothrazar.cyclicmagic.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.entity.RenderBall;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EntityDungeonEye
extends EntityThrowableDispensable {
    private static final double DISTLIMIT = 0.8;
    private static final double VERT = (double)0.015f;
    private static final double HORIZ = 0.0025;
    private double targetX;
    private double targetY;
    private double targetZ;
    private boolean isLost = true;

    public EntityDungeonEye(World worldIn) {
        super(worldIn);
    }

    public EntityDungeonEye(World worldIn, EntityLivingBase ent) {
        super(worldIn, ent);
    }

    public EntityDungeonEye(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74780_a("sp_target_x", this.targetX);
        compound.func_74780_a("sp_target_y", this.targetY);
        compound.func_74780_a("sp_target_z", this.targetZ);
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
        compound.func_74757_a("isLost", this.isLost);
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.targetX = compound.func_74769_h("sp_target_x");
        this.targetY = compound.func_74769_h("sp_target_y");
        this.targetZ = compound.func_74769_h("sp_target_z");
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
        this.isLost = compound.func_74767_n("isLost");
    }

    public void moveTowards(BlockPos pos) {
        this.targetX = pos.func_177958_n();
        this.targetY = pos.func_177956_o();
        this.targetZ = pos.func_177952_p();
        this.isLost = false;
        this.func_70186_c(this.targetX, this.targetY, this.targetZ, this.func_70185_h(), 0.01f);
    }

    public void kill() {
        this.field_70170_p.func_175718_b(2003, new BlockPos((Entity)this), 0);
        this.func_184185_a(SoundEvents.field_193777_bb, 1.0f, 1.0f);
        this.func_70106_y();
    }

    public void func_70071_h_() {
        if (this.isLost) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            double distX = Math.abs(this.targetX - this.field_70165_t);
            double distY = Math.abs(this.targetY - this.field_70163_u);
            double distZ = Math.abs(this.targetZ - this.field_70161_v);
            float distance = (float)Math.sqrt(distX * distX + distZ * distZ);
            float distLine = (float)Math.sqrt(distX * distX + distZ * distZ + distY * distY);
            float atan = (float)MathHelper.func_181159_b((double)(this.targetZ - this.field_70161_v), (double)(this.targetX - this.field_70165_t));
            double horizFactor = (double)f + (double)(distance - f) * 0.0025;
            if (distLine < 1.0f) {
                horizFactor *= 0.8;
                this.field_70181_x *= 0.8;
                this.func_70106_y();
            }
            this.field_70159_w = Math.cos(atan) * horizFactor;
            this.field_70179_y = Math.sin(atan) * horizFactor;
            this.field_70181_x = 14.0 * distY / (double)distLine * (double)0.015f;
            if (distX < 0.8 && distZ < 0.8) {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                if (distY < 0.8) {
                    this.field_70181_x = 0.0;
                }
            }
            if (this.field_70163_u < this.targetY) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x *= -1.0;
                }
            } else if (this.field_70181_x > 0.0) {
                this.field_70181_x *= -1.0;
            }
            double speedHReduction = 1.0;
            double speedVReduction = 1.0;
            if (this.field_70173_aa < 20) {
                speedHReduction = 2.2;
                speedVReduction = 12.2;
            }
            if (this.field_70173_aa < 40) {
                speedHReduction = 1.8;
                speedVReduction = 10.0;
            } else if (this.field_70173_aa < 100) {
                speedHReduction = 1.2;
                speedVReduction = 6.0;
            } else if (this.field_70173_aa < 150) {
                speedHReduction = 1.1;
                speedVReduction = 2.0;
            } else if (this.field_70173_aa < 500) {
                speedHReduction = 1.0;
                speedVReduction = 1.1;
            }
            this.field_70159_w /= speedHReduction;
            this.field_70181_x /= speedVReduction;
            this.field_70179_y /= speedHReduction;
        }
        if (this.field_70173_aa > 9999) {
            this.func_70106_y();
        }
        if (this.field_70159_w == 0.0 && this.field_70181_x == 0.0 && this.field_70179_y == 0.0) {
            this.func_70106_y();
        }
        int particleCount = this.field_70173_aa < 100 ? 30 : 14;
        float f3 = 0.25f;
        for (int i = 0; i < particleCount; ++i) {
            this.func_130014_f_().func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t - this.field_70159_w * (double)f3 + this.field_70146_Z.nextDouble() * 0.6 - 0.3, this.field_70163_u - this.field_70181_x * (double)f3 - 0.5, this.field_70161_v - this.field_70179_y * (double)f3 + this.field_70146_Z.nextDouble() * 0.6 - 0.3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
        }
    }

    @Override
    protected void processImpact(RayTraceResult mop) {
        this.func_70106_y();
    }

    public static class FactoryDungeon
    implements IRenderFactory<EntityDungeonEye> {
        public Render<? super EntityDungeonEye> createRenderFor(RenderManager rm) {
            return new RenderBall(rm, "dungeon");
        }
    }
}

