/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.capability;

import com.lothrazar.cyclicmagic.capability.IPlayerExtendedProperties;
import com.lothrazar.cyclicmagic.item.ItemAppleStep;
import com.lothrazar.cyclicmagic.item.ItemHeartContainer;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class InstancePlayerExtendedProperties
implements IPlayerExtendedProperties {
    private static final String OLD_MHEALTH = "mhealth";
    private static final String MOD_HEALTH = "modhealth";
    private static final String NBT_TODO = "todo";
    private static final String HAS_INVENTORY_EXTENDED = "hasInventoryExtended";
    private static final String HAS_INVENTORY_CRAFTING = "hasInventoryCrafting";
    private static final String IS_SLEEPING = "isSleeping";
    private static final String KEY_BOOLEAN = "ghost_on";
    private static final String KEY_TIMER = "ghost_timer";
    private static final String KEY_EATLOC = "ghost_location";
    private static final String KEY_EATDIM = "ghost_dim";
    private static final String KEY_STEP = "cyclicmagic_step";
    private static final String KEY_STEPFORCE = "cyclicmagic_stepforced";
    private static final String KEY_FLYING = "cyclicmagic_flying";
    private boolean foreStepHeightOff = false;
    private boolean isStepOn = ItemAppleStep.defaultPlayerStepUp;
    private boolean isSleeping = false;
    private boolean hasInventoryCrafting = false;
    private boolean hasInventoryExtended = false;
    private String todo = "";
    private int healthModifier = ItemHeartContainer.heartModifierInitial * 2;
    private boolean isChorusSpectator = false;
    private BlockPos chorusStart = null;
    private int chorusDim = 0;
    private int chorusSeconds = 0;
    private int flyingSeconds = 0;

    @Override
    public boolean isSleeping() {
        return this.isSleeping;
    }

    @Override
    public void setSleeping(boolean value) {
        this.isSleeping = value;
    }

    @Override
    public boolean hasInventoryCrafting() {
        return this.hasInventoryCrafting;
    }

    @Override
    public void setInventoryCrafting(boolean value) {
        this.hasInventoryCrafting = value;
    }

    @Override
    public boolean hasInventoryExtended() {
        return this.hasInventoryExtended;
    }

    @Override
    public void setInventoryExtended(boolean value) {
        this.hasInventoryExtended = value;
    }

    @Override
    public NBTTagCompound getDataAsNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74774_a(IS_SLEEPING, (byte)(this.isSleeping() ? 1 : 0));
        tags.func_74774_a(HAS_INVENTORY_CRAFTING, (byte)(this.hasInventoryCrafting() ? 1 : 0));
        tags.func_74774_a(HAS_INVENTORY_EXTENDED, (byte)(this.hasInventoryExtended() ? 1 : 0));
        tags.func_74778_a(NBT_TODO, this.getTODO());
        tags.func_74768_a(MOD_HEALTH, this.getMaxHealthModifier());
        tags.func_74757_a(KEY_BOOLEAN, this.isChorusSpectator);
        tags.func_74778_a(KEY_EATLOC, UtilNBT.posToStringCSV(this.chorusStart));
        tags.func_74768_a(KEY_EATDIM, this.chorusDim);
        tags.func_74768_a(KEY_TIMER, this.chorusSeconds);
        tags.func_74757_a(KEY_STEP, this.isStepOn);
        tags.func_74757_a(KEY_STEPFORCE, this.foreStepHeightOff);
        tags.func_74768_a(KEY_FLYING, this.flyingSeconds);
        return tags;
    }

    @Override
    public void setDataFromNBT(NBTTagCompound nbt) {
        String[] p;
        NBTTagCompound tags = !(nbt instanceof NBTTagCompound) ? new NBTTagCompound() : nbt;
        this.setFlyingTimer(tags.func_74762_e(KEY_FLYING));
        this.setSleeping(tags.func_74771_c(IS_SLEEPING) == 1);
        this.setInventoryCrafting(tags.func_74771_c(HAS_INVENTORY_CRAFTING) == 1);
        this.setInventoryExtended(tags.func_74771_c(HAS_INVENTORY_EXTENDED) == 1);
        this.setTODO(tags.func_74779_i(NBT_TODO));
        if (tags.func_74764_b(OLD_MHEALTH)) {
            int healthModifier = tags.func_74762_e(OLD_MHEALTH) - 20;
            this.setMaxHealthModifier(healthModifier);
            tags.func_74768_a(MOD_HEALTH, healthModifier);
            tags.func_82580_o(OLD_MHEALTH);
        }
        this.setMaxHealthModifier(tags.func_74762_e(MOD_HEALTH));
        this.setChorusDim(tags.func_74762_e(KEY_EATDIM));
        this.setChorusTimer(tags.func_74762_e(KEY_TIMER));
        this.setChorusOn(tags.func_74767_n(KEY_BOOLEAN));
        this.setStepHeightOn(tags.func_74767_n(KEY_STEP));
        this.setForceStepOff(tags.func_74767_n(KEY_STEPFORCE));
        String posCSV = tags.func_74779_i(KEY_EATLOC);
        if (posCSV != null && posCSV.length() > 0 && (p = posCSV.split(",")) != null && p.length == 3) {
            this.setChorusStart(new BlockPos(Double.parseDouble(p[0]), Double.parseDouble(p[1]), Double.parseDouble(p[2])));
        }
    }

    @Override
    public String getTODO() {
        return this.todo;
    }

    @Override
    public void setTODO(String value) {
        this.todo = value;
    }

    @Override
    public int getMaxHealthModifier() {
        return this.healthModifier;
    }

    @Override
    public void setMaxHealthModifier(int value) {
        this.healthModifier = value;
    }

    @Override
    public boolean getChorusOn() {
        return this.isChorusSpectator;
    }

    @Override
    public void setChorusOn(boolean f) {
        this.isChorusSpectator = f;
    }

    @Override
    public BlockPos getChorusStart() {
        return this.chorusStart;
    }

    @Override
    public void setChorusStart(BlockPos s) {
        this.chorusStart = s;
    }

    @Override
    public int getChorusDim() {
        return this.chorusDim;
    }

    @Override
    public void setChorusDim(int d) {
        this.chorusDim = d;
    }

    @Override
    public int getChorusTimer() {
        return this.chorusSeconds;
    }

    @Override
    public void setChorusTimer(int d) {
        this.chorusSeconds = d;
    }

    @Override
    public boolean isStepHeightOn() {
        return this.isStepOn;
    }

    @Override
    public void setStepHeightOn(boolean b) {
        this.isStepOn = b;
    }

    @Override
    public boolean doForceStepOff() {
        return this.foreStepHeightOff;
    }

    @Override
    public void setForceStepOff(boolean b) {
        this.foreStepHeightOff = b;
    }

    @Override
    public int getFlyingTimer() {
        return this.flyingSeconds;
    }

    @Override
    public void setFlyingTimer(int d) {
        this.flyingSeconds = d;
    }
}

