/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.capability;

import net.minecraftforge.energy.EnergyStorage;

public class EnergyStore
extends EnergyStorage {
    public EnergyStore(int capAndIO) {
        this(capAndIO, capAndIO, capAndIO);
    }

    public EnergyStore(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract, 0);
    }

    public void setEnergyStored(int en) {
        if (en < 0) {
            en = 0;
        }
        this.energy = Math.min(en, this.capacity);
    }

    public int emptyCapacity() {
        return this.capacity - this.energy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive() || this.getMaxEnergyStored() <= this.getEnergyStored()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            int newEnergy = energyReceived + this.getEnergyStored();
            this.setEnergyStored(Math.min(this.getMaxEnergyStored(), newEnergy));
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() - energyExtracted);
        }
        return energyExtracted;
    }
}

