/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.builderpattern;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.builderpattern.PatternBuilderTESR;
import com.lothrazar.cyclicmagic.block.builderpattern.TileEntityPatternBuilder;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.block.core.IBlockHasTESR;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPatternBuilder
extends BlockBaseHasTile
implements IHasRecipe,
IBlockHasTESR,
IContent {
    public static int FUEL_COST = 0;
    private boolean enabled;

    public BlockPatternBuilder() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setTranslucent();
        this.setGuiId(14);
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityPatternBuilder();
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), "rbr", "did", "rmr", Character.valueOf('b'), Blocks.field_150430_aB, Character.valueOf('d'), "gemDiamond", Character.valueOf('i'), Blocks.field_150432_aD, Character.valueOf('m'), Blocks.field_189877_df, Character.valueOf('r'), "dustRedstone");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPatternBuilder.class, (TileEntitySpecialRenderer)new PatternBuilderTESR());
    }

    @Override
    public String getContentName() {
        return "builder_pattern";
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, this.getContentName(), GuideCategory.BLOCKMACHINE);
        BlockRegistry.registerTileEntity(TileEntityPatternBuilder.class, this.getContentName() + "_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("PatternReplicator", "cyclicmagic.content", true, this.getContentName() + " Set false to delete - requires restart");
        FUEL_COST = config.getInt("builder_pattern", "cyclicmagic.FuelCost", 1, 0, 500000, "Fuel/Energy/RF cost to run machine");
    }
}

