/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.items;

import com.mrcrayfish.furniture.blocks.IPowered;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLightSwitch
extends ItemBlock {
    public ItemLightSwitch(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (GuiScreen.func_146272_n()) {
            String info = I18n.func_135052_a((String)"cfm.light_switch.info", (Object[])new Object[0]);
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
        } else {
            String info = I18n.func_135052_a((String)"cfm.light_switch.desc", (Object[])new Object[0]);
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"cfm.info", (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            heldItem.func_77982_d(null);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        NBTTagList lights;
        IBlockState state;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!player.func_70093_af() && (state = world.func_180495_p(pos)).func_177230_c() instanceof IPowered) {
            this.addLight(heldItem, pos);
            return EnumActionResult.SUCCESS;
        }
        if (this.field_150939_a.func_176198_a(world, pos.func_177972_a(side), side) && (lights = this.getLights(heldItem)) != null) {
            for (int i = 0; i < lights.func_74745_c(); ++i) {
                BlockPos placedPos;
                NBTBase nbtBase = lights.func_179238_g(i);
                BlockPos lightPos = BlockPos.func_177969_a((long)((NBTTagLong)nbtBase).func_150291_c());
                double distance = Math.sqrt(lightPos.func_177957_d((double)(placedPos = pos.func_177972_a(side)).func_177958_n() + 0.5, (double)placedPos.func_177956_o() + 0.5, (double)placedPos.func_177952_p() + 0.5));
                if (!(distance > 16.0)) continue;
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private void addLight(ItemStack stack, BlockPos pos) {
        NBTTagList tagList;
        NBTTagCompound entityTagCompound;
        NBTTagCompound tagCompound = this.createTag(stack);
        if (!tagCompound.func_150297_b("BlockEntityTag", 10)) {
            tagCompound.func_74782_a("BlockEntityTag", (NBTBase)new NBTTagCompound());
        }
        if (!(entityTagCompound = tagCompound.func_74775_l("BlockEntityTag")).func_150297_b("lights", 9)) {
            entityTagCompound.func_74782_a("lights", (NBTBase)new NBTTagList());
        }
        if (!this.containsLight(tagList = (NBTTagList)entityTagCompound.func_74781_a("lights"), pos)) {
            tagList.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
        }
    }

    private boolean containsLight(NBTTagList tagList, BlockPos pos) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagLong tagLong = (NBTTagLong)tagList.func_179238_g(i);
            if (tagLong.func_150291_c() != pos.func_177986_g()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private NBTTagList getLights(ItemStack stack) {
        NBTTagCompound entityTagCompound;
        NBTTagCompound tagCompound = this.createTag(stack);
        if (tagCompound.func_150297_b("BlockEntityTag", 10) && (entityTagCompound = tagCompound.func_74775_l("BlockEntityTag")).func_150297_b("lights", 9)) {
            return (NBTTagList)entityTagCompound.func_74781_a("lights");
        }
        return null;
    }

    private NBTTagCompound createTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

