/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.worldgen;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.util.NBTExtras;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public abstract class WorldGenWizardryStructure
implements IWorldGenerator {
    private static final Map<String, WorldGenWizardryStructure> generators = new HashMap<String, WorldGenWizardryStructure>();
    private final Random random;
    private World world;
    private MapGenStructureData structureData;
    protected final Long2ObjectMap<StructureBoundingBox> structureMap = new Long2ObjectOpenHashMap(1024);

    public WorldGenWizardryStructure() {
        this.random = new Random();
        generators.put(this.getStructureName(), this);
    }

    public abstract long getRandomSeedModifier();

    public abstract ResourceLocation getStructureFile(Random var1);

    public abstract String getStructureName();

    public Rotation[] getValidRotations() {
        return Rotation.values();
    }

    public Mirror[] getValidMirrors() {
        return new Mirror[]{Mirror.NONE, Mirror.LEFT_RIGHT};
    }

    public abstract boolean canGenerate(Random var1, World var2, int var3, int var4);

    @Nullable
    protected abstract BlockPos attemptPosition(Template var1, PlacementSettings var2, Random var3, World var4, int var5, int var6, String var7);

    public abstract void spawnStructure(Random var1, World var2, BlockPos var3, Template var4, PlacementSettings var5, ResourceLocation var6);

    protected void postGenerate(Random random, World world, PlacementSettings settings) {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!world.func_72912_H().func_76089_r()) {
            return;
        }
        random.setSeed(random.nextLong() + this.getRandomSeedModifier());
        this.initializeStructureData(world);
        if (this.canGenerate(random, world, chunkX, chunkZ)) {
            BlockPos origin;
            ResourceLocation structureFile = this.getStructureFile(random);
            Template template = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), structureFile);
            BlockPos size = template.func_186259_a();
            if (size.func_177958_n() == 0 || size.func_177956_o() == 0 || size.func_177952_p() == 0) {
                Wizardry.logger.warn("Structure template file {} is missing or empty! If you're trying to disable structure spawning, pointing to a non-existent location is NOT the correct way to do so; use the structure dimension lists instead.", (Object)structureFile);
            }
            Rotation[] rotations = this.getValidRotations();
            Mirror[] mirrors = this.getValidMirrors();
            PlacementSettings settings = new PlacementSettings().func_186220_a(rotations[random.nextInt(rotations.length)]).func_186214_a(mirrors[random.nextInt(mirrors.length)]);
            int triesLeft = 10;
            do {
                origin = this.attemptPosition(template, settings, random, world, chunkX, chunkZ, structureFile.toString());
            } while (--triesLeft > 0 && origin == null);
            if (origin == null) {
                return;
            }
            StructureBoundingBox box = new StructureBoundingBox((Vec3i)origin, (Vec3i)origin.func_177971_a((Vec3i)template.func_186257_a(settings.func_186215_c())).func_177982_a(-1, -1, -1));
            if (!Wizardry.settings.fastWorldgen) {
                for (WorldGenWizardryStructure generator : generators.values()) {
                    StructureBoundingBox otherbox = (StructureBoundingBox)generator.structureMap.get(ChunkPos.func_77272_a((int)(origin.func_177958_n() >> 4), (int)(origin.func_177952_p() >> 4)));
                    if (otherbox == null || !otherbox.func_78884_a(box)) continue;
                    return;
                }
            }
            settings.func_186223_a(box);
            origin = template.func_189961_a(origin, settings.func_186212_b(), settings.func_186215_c());
            this.spawnStructure(random, world, origin, template, settings, structureFile);
            this.postGenerate(random, world, settings);
            this.structureMap.put(ChunkPos.func_77272_a((int)(origin.func_177958_n() >> 4), (int)(origin.func_177952_p() >> 4)), (Object)settings.func_186213_g());
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("ChunkX", chunkX);
            tag.func_74768_a("ChunkZ", chunkZ);
            NBTExtras.storeTagSafely(tag, "BB", (NBTBase)settings.func_186213_g().func_151535_h());
            this.structureData.func_143043_a(tag, chunkX, chunkZ);
            this.structureData.func_76185_a();
        }
    }

    protected void initializeStructureData(World world) {
        if (world != this.world) {
            this.world = world;
            this.structureData = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, this.getStructureName());
            this.structureMap.clear();
            if (this.structureData == null) {
                this.structureData = new MapGenStructureData(this.getStructureName());
                world.getPerWorldStorage().func_75745_a(this.getStructureName(), (WorldSavedData)this.structureData);
            } else {
                NBTTagCompound nbt = this.structureData.func_143041_a();
                for (String s : nbt.func_150296_c()) {
                    NBTTagCompound entry;
                    NBTBase nbtbase = nbt.func_74781_a(s);
                    if (nbtbase.func_74732_a() != 10 || !(entry = (NBTTagCompound)nbtbase).func_74764_b("ChunkX") || !entry.func_74764_b("ChunkZ") || !entry.func_74764_b("BB")) continue;
                    int i = entry.func_74762_e("ChunkX");
                    int j = entry.func_74762_e("ChunkZ");
                    int[] coords = entry.func_74759_k("BB");
                    this.structureMap.put(ChunkPos.func_77272_a((int)i, (int)j), (Object)new StructureBoundingBox(coords));
                }
            }
        }
    }

    public boolean isInsideStructure(World world, double x, double y, double z) {
        long[] chunks;
        this.initializeStructureData(world);
        int chunkX = (int)x >> 4;
        int chunkZ = (int)z >> 4;
        if (!world.func_190526_b(chunkX, chunkZ)) {
            Wizardry.logger.warn("Testing whether position ({}, {}, {}) is inside a structure, but that chunk hasn't been generated yet", (Object)x, (Object)y, (Object)z);
            return false;
        }
        for (long chunkPos : chunks = new long[]{ChunkPos.func_77272_a((int)(chunkX - 1), (int)(chunkZ - 1)), ChunkPos.func_77272_a((int)(chunkX - 1), (int)chunkZ), ChunkPos.func_77272_a((int)(chunkX - 1), (int)(chunkZ + 1)), ChunkPos.func_77272_a((int)chunkX, (int)(chunkZ - 1)), ChunkPos.func_77272_a((int)chunkX, (int)chunkZ), ChunkPos.func_77272_a((int)chunkX, (int)(chunkZ + 1)), ChunkPos.func_77272_a((int)(chunkX + 1), (int)(chunkZ - 1)), ChunkPos.func_77272_a((int)(chunkX + 1), (int)chunkZ), ChunkPos.func_77272_a((int)(chunkX + 1), (int)(chunkZ + 1))}) {
            if (!this.structureMap.containsKey(chunkPos) || !((StructureBoundingBox)this.structureMap.get(chunkPos)).func_175898_b(new Vec3i(x, y, z))) continue;
            return true;
        }
        return false;
    }

    public BlockPos getNearestStructurePos(World world, BlockPos pos, boolean findUnexplored) {
        int j = pos.func_177958_n() >> 4;
        int k = pos.func_177952_p() >> 4;
        for (int l = 0; l <= 1000; ++l) {
            for (int i1 = -l; i1 <= l; ++i1) {
                boolean flag = i1 == -l || i1 == l;
                for (int j1 = -l; j1 <= l; ++j1) {
                    boolean flag1;
                    boolean bl = flag1 = j1 == -l || j1 == l;
                    if (!flag && !flag1) continue;
                    int k1 = j + i1;
                    int l1 = k + j1;
                    this.random.setSeed((long)(k1 ^ l1) ^ world.func_72905_C());
                    this.random.nextInt();
                    if (!this.canGenerate(this.random, world, k1, l1) || findUnexplored && world.func_190526_b(k1, l1)) continue;
                    return new BlockPos((k1 << 4) + 8, 64, (l1 << 4) + 8);
                }
            }
        }
        return null;
    }

    public static WorldGenWizardryStructure byName(String name) {
        return generators.get(name);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerMP && event.player.field_70173_aa % 20 == 0) {
            WizardryAdvancementTriggers.visit_structure.trigger((EntityPlayerMP)event.player);
        }
    }
}

