/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.particle.ParticleWizardry;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class ParticleBuilder {
    public static final ParticleBuilder instance = new ParticleBuilder();
    private boolean building = false;
    private ResourceLocation type;
    private double x;
    private double y;
    private double z;
    private double vx;
    private double vy;
    private double vz;
    private float r;
    private float g;
    private float b;
    private float fr;
    private float fg;
    private float fb;
    private double radius;
    private double rpt;
    private int lifetime;
    private boolean gravity;
    private boolean shaded;
    private boolean collide;
    private float scale;
    private Entity entity;
    private float yaw;
    private float pitch;
    private double tx;
    private double ty;
    private double tz;
    private double tvx;
    private double tvy;
    private double tvz;
    private Entity target;
    private long seed;
    private double length;

    private ParticleBuilder() {
        this.reset();
    }

    public static ParticleBuilder create(ResourceLocation type) {
        return instance.particle(type);
    }

    public ParticleBuilder particle(ResourceLocation type) {
        if (this.building) {
            throw new IllegalStateException("Already building! Particle being built: " + this.getCurrentParticleString());
        }
        this.type = type;
        this.building = true;
        return this;
    }

    private String getCurrentParticleString() {
        return String.format("[ Type: %s, Position: (%s, %s, %s), Velocity: (%s, %s, %s), Colour: (%s, %s, %s), Fade Colour: (%s, %s, %s), Radius: %s, Revs/tick: %s, Lifetime: %s, Gravity: %s, Shaded: %s, Scale: %s, Entity: %s ]", this.type, this.x, this.y, this.z, this.vx, this.vy, this.vz, Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.fr), Float.valueOf(this.fg), Float.valueOf(this.fb), this.radius, this.rpt, this.lifetime, this.gravity, this.shaded, Float.valueOf(this.scale), this.entity);
    }

    public ParticleBuilder pos(double x, double y, double z) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public ParticleBuilder pos(Vec3d pos) {
        return this.pos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public ParticleBuilder vel(double vx, double vy, double vz) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        return this;
    }

    public ParticleBuilder vel(Vec3d vel) {
        return this.vel(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
    }

    public ParticleBuilder clr(float r, float g, float b) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.r = MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f);
        this.g = MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f);
        this.b = MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder clr(int r, int g, int b) {
        return this.clr((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ParticleBuilder clr(int hex) {
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        return this.clr(r, g, b);
    }

    public ParticleBuilder fade(float r, float g, float b) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.fr = MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f);
        this.fg = MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f);
        this.fb = MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f);
        return this;
    }

    public ParticleBuilder fade(int r, int g, int b) {
        return this.fade((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ParticleBuilder fade(int hex) {
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        return this.fade(r, g, b);
    }

    public ParticleBuilder scale(float scale) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.scale = scale;
        return this;
    }

    public ParticleBuilder time(int lifetime) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.lifetime = lifetime;
        return this;
    }

    public ParticleBuilder seed(long seed) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.seed = seed;
        return this;
    }

    public ParticleBuilder spin(double radius, double speed) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.radius = radius;
        this.rpt = speed;
        return this;
    }

    public ParticleBuilder gravity(boolean gravity) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.gravity = gravity;
        return this;
    }

    public ParticleBuilder shaded(boolean shaded) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.shaded = shaded;
        return this;
    }

    public ParticleBuilder collide(boolean collide) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.collide = collide;
        return this;
    }

    public ParticleBuilder entity(Entity entity) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.entity = entity;
        return this;
    }

    public ParticleBuilder face(float yaw, float pitch) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.yaw = yaw;
        this.pitch = pitch;
        return this;
    }

    public ParticleBuilder face(EnumFacing direction) {
        return this.face(direction.func_185119_l(), direction.func_176740_k().func_176720_b() ? (float)(direction.func_176743_c().func_179524_a() * 90) : 0.0f);
    }

    public ParticleBuilder target(double x, double y, double z) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.tx = x;
        this.ty = y;
        this.tz = z;
        return this;
    }

    public ParticleBuilder target(Vec3d pos) {
        return this.target(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public ParticleBuilder tvel(double vx, double vy, double vz) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.tvx = vx;
        this.tvy = vy;
        this.tvz = vz;
        return this;
    }

    public ParticleBuilder tvel(Vec3d vel) {
        return this.tvel(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
    }

    public ParticleBuilder length(double length) {
        this.length = length;
        return this;
    }

    public ParticleBuilder target(Entity target) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        this.target = target;
        return this;
    }

    public void spawn(World world) {
        if (!this.building) {
            throw new IllegalStateException("Not building yet!");
        }
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0 && this.entity == null) {
            Wizardry.logger.warn("Spawning particle at (0, 0, 0) - are you sure the position/entity has been set correctly?");
        }
        if (!world.field_72995_K) {
            Wizardry.logger.warn("ParticleBuilder.spawn(...) called on the server side! ParticleBuilder has prevented a server crash, but calling it on the server will do nothing. Consider adding a world.isRemote check.");
            this.reset();
            return;
        }
        ParticleWizardry particle = Wizardry.proxy.createParticle(this.type, world, this.x, this.y, this.z);
        if (particle == null) {
            this.reset();
            return;
        }
        if (!(Double.isNaN(this.vx) || Double.isNaN(this.vy) || Double.isNaN(this.vz))) {
            particle.setVelocity(this.vx, this.vy, this.vz);
        }
        if (this.r >= 0.0f && this.g >= 0.0f && this.b >= 0.0f) {
            particle.func_70538_b(this.r, this.g, this.b);
        }
        if (this.fr >= 0.0f && this.fg >= 0.0f && this.fb >= 0.0f) {
            particle.setFadeColour(this.fr, this.fg, this.fb);
        }
        if (this.lifetime >= 0) {
            particle.func_187114_a(this.lifetime);
        }
        if (this.radius > 0.0) {
            particle.setSpin(this.radius, this.rpt);
        }
        if (!Float.isNaN(this.yaw) && !Float.isNaN(this.pitch)) {
            particle.setFacing(this.yaw, this.pitch);
        }
        if (this.seed != 0L) {
            particle.setSeed(this.seed);
        }
        if (!(Double.isNaN(this.tvx) || Double.isNaN(this.tvy) || Double.isNaN(this.tvz))) {
            particle.setTargetVelocity(this.tvx, this.tvy, this.tvz);
        }
        if (this.length > 0.0) {
            particle.setLength(this.length);
        }
        particle.func_70541_f(this.scale);
        particle.setGravity(this.gravity);
        particle.setShaded(this.shaded);
        particle.setCollisions(this.collide);
        particle.setEntity(this.entity);
        particle.setTargetPosition(this.tx, this.ty, this.tz);
        particle.setTargetEntity(this.target);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        this.reset();
    }

    private void reset() {
        this.building = false;
        this.type = null;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.vx = Double.NaN;
        this.vy = Double.NaN;
        this.vz = Double.NaN;
        this.r = -1.0f;
        this.g = -1.0f;
        this.b = -1.0f;
        this.fr = -1.0f;
        this.fg = -1.0f;
        this.fb = -1.0f;
        this.radius = 0.0;
        this.rpt = 0.0;
        this.lifetime = -1;
        this.gravity = false;
        this.shaded = false;
        this.collide = false;
        this.scale = 1.0f;
        this.entity = null;
        this.yaw = Float.NaN;
        this.pitch = Float.NaN;
        this.tx = Double.NaN;
        this.ty = Double.NaN;
        this.tz = Double.NaN;
        this.tvx = Double.NaN;
        this.tvy = Double.NaN;
        this.tvz = Double.NaN;
        this.target = null;
        this.seed = 0L;
        this.length = -1.0;
    }

    public static ParticleBuilder create(ResourceLocation type, Entity entity) {
        double x = entity.field_70165_t + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N;
        double y = entity.field_70163_u + entity.field_70170_p.field_73012_v.nextDouble() * (double)entity.field_70131_O;
        double z = entity.field_70161_v + (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N;
        return instance.particle(type).pos(x, y, z);
    }

    public static ParticleBuilder create(ResourceLocation type, Random random, double x, double y, double z, double radius, boolean move) {
        double px = x + (random.nextDouble() * 2.0 - 1.0) * radius;
        double py = y + (random.nextDouble() * 2.0 - 1.0) * radius;
        double pz = z + (random.nextDouble() * 2.0 - 1.0) * radius;
        if (move) {
            return instance.particle(type).pos(px, py, pz).vel(px - x, py - y, pz - z);
        }
        return instance.particle(type).pos(px, py, pz);
    }

    public static void spawnShockParticles(World world, double x, double y, double z) {
        for (int i = 0; i < 8; ++i) {
            double px = x + world.field_73012_v.nextDouble() - 0.5;
            double py = y + world.field_73012_v.nextDouble() - 0.5;
            double pz = z + world.field_73012_v.nextDouble() - 0.5;
            ParticleBuilder.create(Type.SPARK).pos(px, py, pz).spawn(world);
            px = x + world.field_73012_v.nextDouble() - 0.5;
            py = y + world.field_73012_v.nextDouble() - 0.5;
            pz = z + world.field_73012_v.nextDouble() - 0.5;
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, px, py, pz, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static void spawnHealParticles(World world, EntityLivingBase entity) {
        for (int i = 0; i < 10; ++i) {
            double x = entity.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = entity.field_70163_u + (double)entity.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = entity.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create(Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(1.0f, 1.0f, 0.3f).spawn(world);
        }
        ParticleBuilder.create(Type.BUFF).entity((Entity)entity).clr(1.0f, 1.0f, 0.3f).spawn(world);
    }

    public static class Type {
        public static final ResourceLocation BEAM = new ResourceLocation("ebwizardry", "beam");
        public static final ResourceLocation BLOCK_HIGHLIGHT = new ResourceLocation("ebwizardry", "block_highlight");
        public static final ResourceLocation BUFF = new ResourceLocation("ebwizardry", "buff");
        public static final ResourceLocation CLOUD = new ResourceLocation("ebwizardry", "cloud");
        public static final ResourceLocation DARK_MAGIC = new ResourceLocation("ebwizardry", "dark_magic");
        public static final ResourceLocation DUST = new ResourceLocation("ebwizardry", "dust");
        public static final ResourceLocation FLASH = new ResourceLocation("ebwizardry", "flash");
        public static final ResourceLocation GUARDIAN_BEAM = new ResourceLocation("ebwizardry", "guardian_beam");
        public static final ResourceLocation ICE = new ResourceLocation("ebwizardry", "ice");
        public static final ResourceLocation LEAF = new ResourceLocation("ebwizardry", "leaf");
        public static final ResourceLocation LIGHTNING = new ResourceLocation("ebwizardry", "lightning");
        public static final ResourceLocation LIGHTNING_PULSE = new ResourceLocation("ebwizardry", "lightning_pulse");
        public static final ResourceLocation MAGIC_BUBBLE = new ResourceLocation("ebwizardry", "magic_bubble");
        public static final ResourceLocation MAGIC_FIRE = new ResourceLocation("ebwizardry", "magic_fire");
        public static final ResourceLocation PATH = new ResourceLocation("ebwizardry", "path");
        public static final ResourceLocation SCORCH = new ResourceLocation("ebwizardry", "scorch");
        public static final ResourceLocation SNOW = new ResourceLocation("ebwizardry", "snow");
        public static final ResourceLocation SPARK = new ResourceLocation("ebwizardry", "spark");
        public static final ResourceLocation SPARKLE = new ResourceLocation("ebwizardry", "sparkle");
        public static final ResourceLocation SPHERE = new ResourceLocation("ebwizardry", "sphere");
        public static final ResourceLocation VINE = new ResourceLocation("ebwizardry", "vine");
    }
}

