/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import com.google.common.collect.Streams;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MinionDamage;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class EntityUtils {
    private static final DataParameter<Boolean> POWERED = (DataParameter)ObfuscationReflectionHelper.getPrivateValue(EntityCreeper.class, null, (String)"field_184714_b");

    private EntityUtils() {
    }

    public static List<EntityLivingBase> getLivingWithinRadius(double radius, double x, double y, double z, World world) {
        return EntityUtils.getEntitiesWithinRadius(radius, x, y, z, world, EntityLivingBase.class);
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(double radius, double x, double y, double z, World world, Class<T> entityType) {
        AxisAlignedBB aabb = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entityList = world.func_72872_a(entityType, aabb);
        for (int i = 0; i < entityList.size(); ++i) {
            if (!(((Entity)entityList.get(i)).func_70011_f(x, y, z) > radius)) continue;
            entityList.remove(i);
            break;
        }
        return entityList;
    }

    public static List<EntityLivingBase> getLivingWithinCylinder(double radius, double x, double y, double z, double height, World world) {
        return EntityUtils.getEntitiesWithinCylinder(radius, x, y, z, height, world, EntityLivingBase.class);
    }

    public static <T extends Entity> List<T> getEntitiesWithinCylinder(double radius, double x, double y, double z, double height, World world, Class<T> entityType) {
        AxisAlignedBB aabb = new AxisAlignedBB(x - radius, y, z - radius, x + radius, y + height, z + radius);
        List entityList = world.func_72872_a(entityType, aabb);
        for (Entity entity : entityList) {
            if (!(entity.func_70011_f(x, entity.field_70163_u, z) > radius)) continue;
            entityList.remove(entity);
            break;
        }
        return entityList;
    }

    @Nullable
    public static Entity getEntityByUUID(World world, @Nullable UUID id) {
        if (id == null) {
            return null;
        }
        for (Entity entity : world.field_72996_f) {
            if (entity == null || entity.func_110124_au() == null || !entity.func_110124_au().equals(id)) continue;
            return entity;
        }
        return null;
    }

    @Nullable
    public static Entity getRider(Entity entity) {
        return !entity.func_184188_bt().isEmpty() ? (Entity)entity.func_184188_bt().get(0) : null;
    }

    public static void undoGravity(Entity entity) {
        if (!entity.func_189652_ae()) {
            double gravity = 0.04;
            if (entity instanceof EntityThrowable) {
                gravity = 0.03;
            } else if (entity instanceof EntityArrow) {
                gravity = 0.05;
            } else if (entity instanceof EntityLivingBase) {
                gravity = 0.08;
            }
            entity.field_70181_x += gravity;
        }
    }

    public static void applyStandardKnockback(Entity attacker, EntityLivingBase target) {
        EntityUtils.applyStandardKnockback(attacker, target, 0.4f);
    }

    public static void applyStandardKnockback(Entity attacker, EntityLivingBase target, float strength) {
        double dx = attacker.field_70165_t - target.field_70165_t;
        double dz = attacker.field_70161_v - target.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        target.func_70653_a(attacker, strength, dx, dz);
    }

    public static Vec3d findSpaceForTeleport(Entity entity, Vec3d destination, boolean accountForPassengers) {
        World world = entity.field_70170_p;
        AxisAlignedBB box = entity.func_174813_aQ();
        if (accountForPassengers) {
            for (Entity passenger : entity.func_184188_bt()) {
                box = box.func_111270_a(passenger.func_174813_aQ());
            }
        }
        box = box.func_191194_a(destination.func_178786_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
        Iterable cuboid = BlockPos.func_191532_a((int)MathHelper.func_76128_c((double)box.field_72340_a), (int)MathHelper.func_76128_c((double)box.field_72338_b), (int)MathHelper.func_76128_c((double)box.field_72339_c), (int)MathHelper.func_76128_c((double)box.field_72336_d), (int)MathHelper.func_76128_c((double)box.field_72337_e), (int)MathHelper.func_76128_c((double)box.field_72334_f));
        if (Streams.stream((Iterable)cuboid).noneMatch(b -> world.func_184143_b(new AxisAlignedBB(b)))) {
            return destination;
        }
        double dx = box.field_72336_d - box.field_72340_a;
        double dy = box.field_72337_e - box.field_72338_b;
        double dz = box.field_72334_f - box.field_72339_c;
        int nx = MathHelper.func_76143_f((double)dx) / 2;
        int px = MathHelper.func_76143_f((double)dx) - nx;
        int ny = MathHelper.func_76143_f((double)dy) / 2;
        int py = MathHelper.func_76143_f((double)dy) - ny;
        int nz = MathHelper.func_76143_f((double)dz) / 2;
        int pz = MathHelper.func_76143_f((double)dz) - nz;
        List nearby = Streams.stream((Iterable)BlockPos.func_191532_a((int)(MathHelper.func_76128_c((double)box.field_72340_a) - 1), (int)(MathHelper.func_76128_c((double)box.field_72338_b) - 1), (int)(MathHelper.func_76128_c((double)box.field_72339_c) - 1), (int)(MathHelper.func_76128_c((double)box.field_72336_d) + 1), (int)(MathHelper.func_76128_c((double)box.field_72337_e) + 1), (int)(MathHelper.func_76128_c((double)box.field_72334_f) + 1))).collect(Collectors.toList());
        List possiblePositions = Streams.stream((Iterable)cuboid).collect(Collectors.toList());
        while (!nearby.isEmpty()) {
            BlockPos pos = (BlockPos)nearby.remove(0);
            if (!world.func_184143_b(new AxisAlignedBB(pos))) continue;
            Predicate<BlockPos> nearSolidBlock = b -> b.func_177958_n() >= pos.func_177958_n() - nx && b.func_177958_n() <= pos.func_177958_n() + px && b.func_177956_o() >= pos.func_177956_o() - ny && b.func_177956_o() <= pos.func_177956_o() + py && b.func_177952_p() >= pos.func_177952_p() - nz && b.func_177952_p() <= pos.func_177952_p() + pz;
            nearby.removeIf(nearSolidBlock);
            possiblePositions.removeIf(nearSolidBlock);
        }
        if (possiblePositions.isEmpty()) {
            return null;
        }
        BlockPos nearest = possiblePositions.stream().min(Comparator.comparingDouble(b -> destination.func_186679_c((double)b.func_177958_n() + 0.5, (double)b.func_177956_o() + 0.5, (double)b.func_177952_p() + 0.5))).get();
        return GeometryUtils.getFaceCentre(nearest, EnumFacing.DOWN);
    }

    public static boolean attackEntityWithoutKnockback(Entity entity, DamageSource source, float amount) {
        double vx = entity.field_70159_w;
        double vy = entity.field_70181_x;
        double vz = entity.field_70179_y;
        boolean succeeded = entity.func_70097_a(source, amount);
        entity.field_70159_w = vx;
        entity.field_70181_x = vy;
        entity.field_70179_y = vz;
        return succeeded;
    }

    public static boolean isMeleeDamage(DamageSource source) {
        if (!(source instanceof MinionDamage) && source.func_76364_f() != source.func_76346_g()) {
            return false;
        }
        if (source.func_76352_a()) {
            return false;
        }
        if (source.func_76363_c()) {
            return false;
        }
        if (!(source instanceof MinionDamage) && source instanceof IElementalDamage) {
            return false;
        }
        if (!(source.func_76346_g() instanceof EntityLivingBase)) {
            return false;
        }
        return !(source.func_76346_g() instanceof EntityPlayer) || source.func_188404_v() == null || !(source.func_188404_v().func_72438_d(source.func_76346_g().func_174791_d()) > ((EntityLivingBase)source.func_76346_g()).func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
    }

    public static boolean isLiving(Entity entity) {
        return entity instanceof EntityLivingBase && !(entity instanceof EntityArmorStand);
    }

    public static boolean isPlayerOp(EntityPlayer player, MinecraftServer server) {
        return server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }

    public static boolean canDamageBlocks(@Nullable Entity entity, World world) {
        if (entity == null) {
            return Wizardry.settings.dispenserBlockDamage;
        }
        if (entity instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_175142_cm() && Wizardry.settings.playerBlockDamage;
        }
        return ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entity);
    }

    public static boolean isCasting(EntityLivingBase caster, Spell spell) {
        if (!spell.isContinuous) {
            return false;
        }
        if (caster instanceof EntityPlayer) {
            ItemStack stack;
            WizardData data = WizardData.get((EntityPlayer)caster);
            if (data != null && data.currentlyCasting() == spell) {
                return true;
            }
            if (caster.func_184587_cr() && caster.func_184612_cw() >= spell.getChargeup() && (stack = caster.func_184586_b(caster.func_184600_cs())).func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)stack.func_77973_b()).getCurrentSpell(stack) == spell) {
                return true;
            }
        } else if (caster instanceof ISpellCaster && ((ISpellCaster)caster).getContinuousSpell() == spell) {
            return true;
        }
        return false;
    }

    public static int getDefaultAimingError(EnumDifficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return 10;
            }
            case NORMAL: {
                return 6;
            }
            case HARD: {
                return 2;
            }
        }
        return 10;
    }

    public static void chargeCreeper(EntityCreeper creeper) {
        creeper.func_184212_Q().func_187227_b(POWERED, (Object)true);
    }

    public static void playSoundAtPlayer(EntityPlayer player, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, category, volume, pitch);
    }

    public static void playSoundAtPlayer(EntityPlayer player, SoundEvent sound, float volume, float pitch) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, SoundCategory.PLAYERS, volume, pitch);
    }

    public static final class Operations {
        public static final int ADD = 0;
        public static final int MULTIPLY_FLAT = 1;
        public static final int MULTIPLY_CUMULATIVE = 2;

        private Operations() {
        }
    }
}

