/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.tileentity;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockPedestal;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.packet.PacketConquerShrine;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.potion.PotionContainment;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityShrineCore
extends TileEntity
implements ITickable {
    private static final double ACTIVATION_RADIUS = 5.0;
    private boolean activated = false;
    private boolean conquered = false;
    private long regenerationTime = 0L;
    private long lastRegenerationTime = 0L;
    private Element shrineElement;
    private AxisAlignedBB containmentField;
    private final UUID[] linkedWizards = new UUID[3];
    private TileEntity linkedContainer;
    private BlockPos linkedContainerPos;
    private final Set<UUID> lootedPlayers = new HashSet<UUID>();

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        this.initContainmentField(pos);
    }

    private void initContainmentField(BlockPos pos) {
        float r = PotionContainment.getContainmentDistance(0);
        this.containmentField = new AxisAlignedBB((double)(-r), (double)(-r), (double)(-r), (double)r, (double)r, (double)r).func_191194_a(GeometryUtils.getCentre(pos));
    }

    public void linkContainer(TileEntity container) {
        this.linkedContainer = container;
    }

    public void setShrineElement(Element element) {
        this.shrineElement = element;
    }

    public boolean canPlayerLoot(EntityPlayer player) {
        if (Wizardry.settings.shrineAllowMultipleLoot) {
            return true;
        }
        return !this.lootedPlayers.contains(player.func_110124_au());
    }

    public void recordPlayerLoot(EntityPlayer player) {
        if (!Wizardry.settings.shrineAllowMultipleLoot) {
            this.lootedPlayers.add(player.func_110124_au());
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        if (this.linkedContainer == null && this.linkedContainerPos != null) {
            this.linkContainer(this.field_145850_b.func_175625_s(this.linkedContainerPos));
        }
        if (this.conquered && Wizardry.settings.shrineRegenerationEnabled && this.regenerationTime > 0L && this.field_145850_b.func_82737_E() >= this.regenerationTime) {
            this.regenerate();
            return;
        }
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        if (!(this.activated || this.conquered || this.field_145850_b.func_184137_a(x, y, z, 5.0, false) == null || this.lastRegenerationTime != 0L && this.field_145850_b.func_82737_E() - this.lastRegenerationTime <= 100L)) {
            this.activated = true;
            if (this.field_145850_b.field_72995_K) {
                ParticleBuilder.create(ParticleBuilder.Type.SPHERE).pos(x, y + 1.0, z).clr(15754389).scale(5.0f).time(12).spawn(this.field_145850_b);
            }
            this.field_145850_b.func_184134_a(x, y, z, WizardrySounds.BLOCK_PEDESTAL_ACTIVATE, SoundCategory.BLOCKS, 1.5f, 1.0f, false);
            if (!this.field_145850_b.field_72995_K) {
                EntityEvilWizard[] wizards = new EntityEvilWizard[this.linkedWizards.length];
                for (int i = 0; i < this.linkedWizards.length; ++i) {
                    EntityEvilWizard wizard = new EntityEvilWizard(this.field_145850_b);
                    float angle = this.field_145850_b.field_73012_v.nextFloat() * 2.0f * (float)Math.PI;
                    double x1 = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)(5.0f * MathHelper.func_76126_a((float)angle));
                    double z1 = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)(5.0f * MathHelper.func_76134_b((float)angle));
                    Integer y1 = BlockUtils.getNearestFloor(this.field_145850_b, new BlockPos(x1, (double)this.field_174879_c.func_177956_o(), z1), 8);
                    if (y1 == null) {
                        x1 = this.field_174879_c.func_177958_n() + 1;
                        y1 = this.field_174879_c.func_177956_o();
                        z1 = this.field_174879_c.func_177952_p();
                    }
                    wizard.func_70012_b(x1, (double)y1.intValue() + 0.5, z1, 0.0f, 0.0f);
                    wizard.setElement((Element)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockPedestal.ELEMENT)));
                    wizard.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
                    wizard.hasStructure = true;
                    this.field_145850_b.func_72838_d((Entity)wizard);
                    wizards[i] = wizard;
                    this.linkedWizards[i] = wizard.func_110124_au();
                }
                for (EntityEvilWizard wizard : wizards) {
                    wizard.groupUUIDs.addAll(Arrays.asList(this.linkedWizards));
                }
            }
            this.containNearbyTargets();
        }
        if (!this.areWizardsDead() && this.activated && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.containNearbyTargets();
        }
        if (this.activated && this.areWizardsDead() && !this.field_145850_b.field_72995_K) {
            this.conquer();
        }
    }

    private boolean areWizardsDead() {
        for (UUID uuid : this.linkedWizards) {
            Entity entity = EntityUtils.getEntityByUUID(this.field_145850_b, uuid);
            if (!(entity instanceof EntityEvilWizard) || !entity.func_70089_S()) continue;
            return false;
        }
        return true;
    }

    public void conquer() {
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        if (!this.field_145850_b.field_72995_K) {
            WizardryPacketHandler.net.sendToAllAround((IMessage)new PacketConquerShrine.Message(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), x, y, z, 64.0));
            this.removeContainmentFromNearbyTargets();
            if (Wizardry.settings.shrineRegenerationEnabled) {
                this.conquered = true;
                this.regenerationTime = this.field_145850_b.func_82737_E() + (long)Wizardry.settings.shrineRegenerationTime * 1200L;
                this.activated = false;
                Arrays.fill(this.linkedWizards, null);
                this.handleChestLootDrop();
                this.func_70296_d();
                if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == WizardryBlocks.runestone_pedestal) {
                    this.shrineElement = (Element)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockPedestal.ELEMENT));
                } else {
                    Wizardry.logger.warn("What's going on?! A shrine core is being conquered but the block at its position is not a runestone pedestal!");
                }
            } else {
                BlockPos chestPos = this.field_174879_c.func_177984_a();
                TileEntity chestTileEntity = this.field_145850_b.func_175625_s(chestPos);
                if (chestTileEntity instanceof TileEntityChest) {
                    TileEntityChest chest = (TileEntityChest)chestTileEntity;
                    NBTExtras.removeUniqueId(chest.getTileData(), "arcaneLockOwner");
                    chest.func_70296_d();
                    this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                }
                if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == WizardryBlocks.runestone_pedestal) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, WizardryBlocks.runestone_pedestal.func_176223_P().func_177226_a(BlockPedestal.ELEMENT, this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockPedestal.ELEMENT)));
                } else {
                    Wizardry.logger.warn("What's going on?! A shrine core is being conquered but the block at its position is not a runestone pedestal!");
                }
                this.field_145850_b.func_147457_a((TileEntity)this);
            }
        }
        if (this.linkedContainer == null) {
            this.linkedContainer = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        }
        if (this.linkedContainer != null) {
            NBTExtras.removeUniqueId(this.linkedContainer.getTileData(), "arcaneLockOwner");
        }
        this.field_145850_b.func_184134_a(x, y, z, WizardrySounds.BLOCK_PEDESTAL_CONQUER, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        if (this.field_145850_b.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.SPHERE).scale(5.0f).pos(x, y + 1.0, z).clr(15754389).time(12).spawn(this.field_145850_b);
            for (int i = 0; i < 5; ++i) {
                float brightness = 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE, this.field_145850_b.field_73012_v, x, y + 1.0, z, 1.0, true).clr(1.0f, brightness, brightness).spawn(this.field_145850_b);
            }
        }
    }

    private void regenerate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.removeContainmentFromNearbyTargets();
        this.conquered = false;
        this.regenerationTime = 0L;
        this.activated = false;
        Arrays.fill(this.linkedWizards, null);
        this.lastRegenerationTime = this.field_145850_b.func_82737_E();
        BlockPos chestPos = this.field_174879_c.func_177984_a();
        this.field_145850_b.func_175656_a(chestPos, Blocks.field_150486_ae.func_176223_P());
        TileEntity chestTileEntity = this.field_145850_b.func_175625_s(chestPos);
        if (chestTileEntity instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)chestTileEntity;
            chest.func_189404_a(new ResourceLocation("ebwizardry", "chests/shrine"), this.field_145850_b.field_73012_v.nextLong());
        }
        if (chestTileEntity != null) {
            this.linkContainer(chestTileEntity);
            chestTileEntity.getTileData().func_186854_a("arcaneLockOwner", new UUID(0L, 0L));
            chestTileEntity.func_70296_d();
            IBlockState blockState = this.field_145850_b.func_180495_p(chestPos);
            this.field_145850_b.markAndNotifyBlock(chestPos, null, blockState, blockState, 3);
            this.field_145850_b.func_184138_a(chestPos, blockState, blockState, 3);
        }
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        if (this.field_145850_b.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.SPHERE).pos(x, y + 1.0, z).clr(15754389).scale(5.0f).time(12).spawn(this.field_145850_b);
        }
        this.field_145850_b.func_184134_a(x, y, z, WizardrySounds.BLOCK_PEDESTAL_ACTIVATE, SoundCategory.BLOCKS, 1.5f, 1.0f, false);
        this.func_70296_d();
    }

    private void handleChestLootDrop() {
        TileEntity chestTileEntity;
        BlockPos chestPos = this.field_174879_c.func_177984_a();
        if (this.field_145850_b.func_180495_p(chestPos).func_177230_c() == Blocks.field_150486_ae && (chestTileEntity = this.field_145850_b.func_175625_s(chestPos)) instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)chestTileEntity;
            EntityPlayer conqueringPlayer = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 20.0, false);
            if (conqueringPlayer != null && !this.canPlayerLoot(conqueringPlayer)) {
                if (!this.field_145850_b.field_72995_K) {
                    conqueringPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("wizardry.shrine_already_looted", new Object[0]));
                }
                chest.func_189404_a(null, this.field_145850_b.field_73012_v.nextLong());
                if (this.field_145850_b.func_180495_p(chestPos).func_177230_c() == Blocks.field_150486_ae) {
                    this.field_145850_b.func_175698_g(chestPos);
                }
                return;
            }
            if (conqueringPlayer != null && this.canPlayerLoot(conqueringPlayer)) {
                this.recordPlayerLoot(conqueringPlayer);
            }
        }
        if (this.field_145850_b.func_180495_p(chestPos).func_177230_c() == Blocks.field_150486_ae) {
            this.field_145850_b.func_175698_g(chestPos);
        }
    }

    private void containNearbyTargets() {
        List entities = this.field_145850_b.func_175647_a(EntityLivingBase.class, this.containmentField, e -> e instanceof EntityPlayer || e instanceof EntityWizard || e instanceof EntityEvilWizard);
        for (EntityLivingBase entity : entities) {
            entity.func_70690_d(new PotionEffect(WizardryPotions.containment, 219));
            NBTExtras.storeTagSafely(entity.getEntityData(), "containmentPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.field_174879_c));
        }
    }

    private void removeContainmentFromNearbyTargets() {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("activated", this.activated);
        compound.func_74757_a("conquered", this.conquered);
        compound.func_74772_a("regenerationTime", this.regenerationTime);
        compound.func_74772_a("lastRegenerationTime", this.lastRegenerationTime);
        if (this.shrineElement != null) {
            compound.func_74768_a("shrineElement", this.shrineElement.ordinal());
        }
        if (this.linkedContainer != null) {
            NBTExtras.storeTagSafely(compound, "linkedContainerPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.linkedContainer.func_174877_v()));
        }
        NBTTagList wizardTagList = new NBTTagList();
        for (UUID uuid : this.linkedWizards) {
            if (uuid == null) continue;
            wizardTagList.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)uuid));
        }
        NBTExtras.storeTagSafely(compound, "wizards", (NBTBase)wizardTagList);
        NBTTagList playerTagList = new NBTTagList();
        for (UUID uuid : this.lootedPlayers) {
            playerTagList.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)uuid));
        }
        NBTExtras.storeTagSafely(compound, "lootedPlayers", (NBTBase)playerTagList);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.activated = compound.func_74767_n("activated");
        this.conquered = compound.func_74767_n("conquered");
        this.regenerationTime = compound.func_74763_f("regenerationTime");
        this.lastRegenerationTime = compound.func_74763_f("lastRegenerationTime");
        if (compound.func_74764_b("shrineElement")) {
            this.shrineElement = Element.values()[compound.func_74762_e("shrineElement")];
        }
        this.linkedContainerPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("linkedContainerPos"));
        NBTTagList wizardTagList = compound.func_150295_c("wizards", 10);
        int i = 0;
        for (NBTBase tag : wizardTagList) {
            if (tag instanceof NBTTagCompound) {
                this.linkedWizards[i++] = NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)tag));
                continue;
            }
            Wizardry.logger.warn("Unexpected tag type in NBT tag list of compound tags!");
        }
        this.lootedPlayers.clear();
        if (compound.func_74764_b("lootedPlayers")) {
            NBTTagList playerTagList = compound.func_150295_c("lootedPlayers", 10);
            for (NBTBase tag : playerTagList) {
                if (!(tag instanceof NBTTagCompound)) continue;
                this.lootedPlayers.add(NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)tag)));
            }
        }
        super.func_145839_a(compound);
        this.initContainmentField(this.field_174879_c);
    }
}

