/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.block.BlockStatue;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WallOfFrost
extends SpellRay {
    private static final int MINIMUM_PLACEMENT_RANGE = 2;

    public WallOfFrost() {
        super("wall_of_frost", SpellActions.POINT, true);
        this.particleVelocity(1.0);
        this.particleSpacing(0.5);
        this.addProperties("duration");
        this.soundValues(0.5f, 1.0f, 0.0f);
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLiving && !world.field_72995_K && ((BlockStatue)WizardryBlocks.ice_statue).convertToStatue((EntityLiving)target, caster, (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)))) {
            target.func_184185_a(WizardrySounds.MISC_FREEZE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K && EntityUtils.canDamageBlocks((Entity)caster, world)) {
            if (BlockUtils.canBlockBeReplaced(world, pos)) {
                pos = pos.func_177972_a(side.func_176734_d());
            }
            if (origin.func_186679_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > 4.0 && world.func_180495_p(pos).func_177230_c() != WizardryBlocks.ice_statue && world.func_180495_p(pos).func_177230_c() != WizardryBlocks.dry_frosted_ice) {
                pos = pos.func_177972_a(side);
                int duration = (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
                if (BlockUtils.canBlockBeReplaced(world, pos) && BlockUtils.canPlaceBlock((Entity)caster, world, pos)) {
                    world.func_175656_a(pos, WizardryBlocks.dry_frosted_ice.func_176223_P());
                    world.func_175684_a(pos.func_185334_h(), WizardryBlocks.dry_frosted_ice, duration);
                }
                if (side == EnumFacing.UP && BlockUtils.canBlockBeReplaced(world, pos = pos.func_177972_a(side)) && BlockUtils.canPlaceBlock((Entity)caster, world, pos)) {
                    world.func_175656_a(pos, WizardryBlocks.dry_frosted_ice.func_176223_P());
                    world.func_175684_a(pos.func_185334_h(), WizardryBlocks.dry_frosted_ice, duration);
                }
            }
        }
        return true;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = world.field_73012_v.nextFloat();
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(12)).clr(0.4f + 0.6f * brightness, 0.6f + 0.4f * brightness, 1.0f).spawn(world);
        ParticleBuilder.create(ParticleBuilder.Type.SNOW).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(12)).spawn(world);
    }
}

