/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpellConstruct<T extends EntityMagicConstruct>
extends Spell {
    protected final Function<World, T> constructFactory;
    protected final boolean permanent;
    protected boolean requiresFloor = false;
    protected boolean allowOverlap = false;

    public SpellConstruct(String name, EnumAction action, Function<World, T> constructFactory, boolean permanent) {
        this("ebwizardry", name, action, constructFactory, permanent);
    }

    public SpellConstruct(String modID, String name, EnumAction action, Function<World, T> constructFactory, boolean permanent) {
        super(modID, name, action, false);
        this.constructFactory = constructFactory;
        this.permanent = permanent;
        this.npcSelector((e, o) -> true);
        if (!permanent) {
            this.addProperties("duration");
        }
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    public SpellConstruct<T> floor(boolean requiresFloor) {
        this.requiresFloor = requiresFloor;
        return this;
    }

    public SpellConstruct<T> overlap(boolean allowOverlap) {
        this.allowOverlap = allowOverlap;
        return this;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.field_70122_E || !this.requiresFloor) {
            if (!this.spawnConstruct(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, (EnumFacing)(caster.field_70122_E ? EnumFacing.UP : null), (EntityLivingBase)caster, modifiers)) {
                return false;
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null && (caster.field_70122_E || !this.requiresFloor)) {
            if (!this.spawnConstruct(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, (EnumFacing)(caster.field_70122_E ? EnumFacing.UP : null), (EntityLivingBase)caster, modifiers)) {
                return false;
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        Integer floor = (int)y;
        if (this.requiresFloor) {
            floor = BlockUtils.getNearestFloor(world, new BlockPos(x, y, z), 1);
            direction = EnumFacing.UP;
        }
        if (floor != null) {
            if (!this.spawnConstruct(world, x, floor.intValue(), z, direction, null, modifiers)) {
                return false;
            }
            this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    protected boolean spawnConstruct(World world, double x, double y, double z, @Nullable EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            EntityMagicConstruct construct = (EntityMagicConstruct)((Object)this.constructFactory.apply(world));
            construct.func_70107_b(x, y, z);
            construct.setCaster(caster);
            construct.lifetime = this.permanent ? -1 : (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
            construct.damageMultiplier = modifiers.get("potency");
            if (construct instanceof EntityScaledConstruct) {
                ((EntityScaledConstruct)construct).setSizeMultiplier(modifiers.get(WizardryItems.blast_upgrade));
            }
            this.addConstructExtras(construct, side, caster, modifiers);
            if (!this.allowOverlap && !world.func_72872_a(((Object)((Object)construct)).getClass(), construct.func_174813_aQ()).isEmpty()) {
                return false;
            }
            world.func_72838_d((Entity)construct);
        }
        return true;
    }

    protected void addConstructExtras(T construct, EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
    }
}

