/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.EntityMeteor;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Meteor
extends SpellRay {
    public static final String BLAST_STRENGTH = "blast_strength";

    public Meteor() {
        super("meteor", SpellActions.POINT, false);
        this.soundValues(3.0f, 1.0f, 0.0f);
        this.ignoreLivingEntities(true);
        this.addProperties(BLAST_STRENGTH);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ItemArtefact.isArtefactActive(caster, WizardryItems.ring_meteor)) {
            if (!world.field_72995_K) {
                EntityMeteor meteor = new EntityMeteor(world, caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e(), caster.field_70161_v, modifiers.get(WizardryItems.blast_upgrade), EntityUtils.canDamageBlocks((Entity)caster, world));
                Vec3d direction = caster.func_70040_Z().func_186678_a((double)(2.0f * modifiers.get(WizardryItems.range_upgrade)));
                meteor.field_70159_w = direction.field_72450_a;
                meteor.field_70181_x = direction.field_72448_b;
                meteor.field_70179_y = direction.field_72449_c;
                world.func_72838_d((Entity)meteor);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return super.cast(world, caster, hand, ticksInUse, modifiers);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (world.func_175710_j(pos.func_177984_a())) {
            if (!world.field_72995_K) {
                EntityMeteor meteor = new EntityMeteor(world, pos.func_177958_n(), pos.func_177956_o() + 50, pos.func_177952_p(), modifiers.get(WizardryItems.blast_upgrade), EntityUtils.canDamageBlocks((Entity)caster, world));
                world.func_72838_d((Entity)meteor);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

