/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Settings;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockCrystalOre;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RelativeFacing;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Divination
extends Spell {
    private static final float NUDGE_SPEED = 0.2f;

    public Divination() {
        super("divination", SpellActions.THRUST, false);
        this.addProperties("range");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        List<BlockPos> sphere = BlockUtils.getBlockSphere(caster.func_180425_c(), range);
        sphere.removeIf(b -> {
            Block block = world.func_180495_p(b).func_177230_c();
            return !(block instanceof BlockOre) && !(block instanceof BlockRedstoneOre) && !(block instanceof BlockCrystalOre) && !Settings.containsMetaBlock(Wizardry.settings.divinationOreWhitelist, world.func_180495_p(b));
        });
        Strength strength = Strength.NOTHING;
        EnumFacing direction = EnumFacing.DOWN;
        if (!sphere.isEmpty()) {
            sphere.sort(Comparator.comparingDouble(b -> Divination.calculateWeight(world, caster, b, range, modifiers)));
            BlockPos target = sphere.get(sphere.size() - 1);
            direction = EnumFacing.func_176737_a((float)((float)((double)target.func_177958_n() + 0.5 - caster.field_70165_t)), (float)((float)((double)target.func_177956_o() + 0.5 - (caster.field_70163_u + (double)caster.func_70047_e()))), (float)((float)((double)target.func_177952_p() + 0.5 - caster.field_70161_v)));
            strength = Strength.forWeight(Divination.calculateWeight(world, caster, target, range, modifiers));
        }
        if (!world.field_72995_K) {
            caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + "." + strength.key, new Object[]{new TextComponentTranslation("spell." + this.getUnlocalisedName() + "." + RelativeFacing.relativise((EnumFacing)direction, (Entity)caster).name, new Object[0])}), false);
        } else {
            switch (strength) {
                case NOTHING: {
                    break;
                }
                case WEAK: {
                    break;
                }
                case MODERATE: {
                    Divination.spawnHintParticles(world, (Entity)caster, 3, direction);
                    break;
                }
                case STRONG: {
                    Divination.spawnHintParticles(world, (Entity)caster, 8, direction);
                    break;
                }
                case VERY_STRONG: {
                    Divination.spawnHintParticles(world, (Entity)caster, 12, direction);
                    caster.func_70024_g((double)((float)direction.func_82601_c() * 0.2f), (double)((float)direction.func_96559_d() * 0.2f), (double)((float)direction.func_82599_e() * 0.2f));
                }
            }
        }
        return true;
    }

    private static void spawnHintParticles(World world, Entity caster, int count, EnumFacing direction) {
        Vec3d vec = new Vec3d((Vec3i)caster.func_180425_c().func_177972_a(EnumFacing.UP).func_177967_a(direction, 2)).func_72441_c(0.5, 0.5, 0.5);
        for (int i = 0; i < count; ++i) {
            ParticleBuilder.create(ParticleBuilder.Type.FLASH, world.field_73012_v, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.7, false).time(20 + world.field_73012_v.nextInt(5)).clr(0.6f + world.field_73012_v.nextFloat() * 0.4f, 0.6f + world.field_73012_v.nextFloat() * 0.4f, 0.6f + world.field_73012_v.nextFloat() * 0.4f).scale(0.3f).spawn(world);
        }
    }

    protected static float calculateWeight(World world, EntityPlayer caster, BlockPos pos, double range, SpellModifiers modifiers) {
        Block block = world.func_180495_p(pos).func_177230_c();
        float weightModifier = modifiers.get("potency") - 1.0f;
        float xp = block.getExpDrop(world.func_180495_p(pos), (IBlockAccess)world, pos, 0);
        if (xp == 0.0f) {
            xp = 4.0f * FurnaceRecipes.func_77602_a().func_151398_b(new ItemStack(block));
        }
        return (float)(1.0 - caster.func_70011_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) / range + 0.2 * (double)weightModifier * (double)xp);
    }

    protected static enum Strength {
        NOTHING("nothing", -1.0f),
        WEAK("weak", 0.0f),
        MODERATE("moderate", 0.25f),
        STRONG("strong", 0.5f),
        VERY_STRONG("very_strong", 0.75f);

        String key;
        float minWeight;

        private Strength(String key, float minWeight) {
            this.key = key;
            this.minWeight = minWeight;
        }

        protected static Strength forWeight(float weight) {
            return Arrays.stream(Strength.values()).filter(s -> s.minWeight < weight).max(Comparator.naturalOrder()).orElse(NOTHING);
        }
    }
}

