/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.misc;

import com.google.common.collect.ImmutableMap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.packet.PacketRequestDonationPerks;
import electroblob.wizardry.packet.PacketSyncDonationPerks;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.util.Box;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class DonationPerksHandler {
    private static final Map<UUID, Box<Element>> DONOR_UUID_MAP = ImmutableMap.builder().put((Object)UUID.fromString("4b29263e-007b-48ef-b3e6-ce86cca989e9"), new Box<Element>(Element.MAGIC)).put((Object)UUID.fromString("2b583703-1407-4ec6-93d2-d9c03b0c08fc"), new Box<Element>(Element.MAGIC)).put((Object)UUID.fromString("f6c7001f-4ce8-43f7-b4a1-a9d9d5fadb93"), new Box<Element>(Element.MAGIC)).put((Object)UUID.fromString("01535a73-ff8d-4d6c-851e-c71f89e936aa"), new Box<Element>(Element.MAGIC)).put((Object)UUID.fromString("32ca0099-c1d6-4682-82ab-8f06059bb801"), new Box<Element>(Element.MAGIC)).put((Object)UUID.fromString("0a704e20-1e7a-413e-9122-fae5b244a05e"), new Box<Element>(Element.MAGIC)).put((Object)UUID.fromString("41fec037-12a5-4b19-868e-b62e39952e96"), new Box<Element>(Element.MAGIC)).put((Object)UUID.fromString("3f5e0cec-949a-4dd4-ae60-f4eae481dd06"), new Box<Element>(Element.MAGIC)).put((Object)UUID.fromString("3ad78c5f-d8cf-47f1-bff9-a890f8e638ff"), new Box<Element>(Element.MAGIC)).put((Object)UUID.fromString("93479771-d23a-4d80-8868-2950e144500b"), new Box<Element>(Element.MAGIC)).build();

    public static boolean isDonor(EntityPlayer player) {
        return DONOR_UUID_MAP.containsKey(player.func_110124_au());
    }

    public static void setElements(List<Element> elements) {
        if (elements.size() < DONOR_UUID_MAP.size()) {
            Wizardry.logger.warn("Received fewer perk settings than the number of donors, cannot sync!");
            return;
        }
        DONOR_UUID_MAP.forEach((k, v) -> v.set(elements.remove(0)));
        if (!elements.isEmpty()) {
            Wizardry.logger.warn("Received more perk settings than the number of donors, something must have gone wrong!");
        }
    }

    public static void setElement(EntityPlayerMP player, Element element) {
        Box<Element> box = DONOR_UUID_MAP.get(player.func_110124_au());
        if (box != null && box.get() != element) {
            box.set(element);
            DonationPerksHandler.syncAll(player.field_71093_bK);
        }
    }

    public static Element getElement(EntityPlayer player) {
        Box<Element> box = DONOR_UUID_MAP.get(player.func_110124_au());
        return box == null ? null : box.get();
    }

    private static void syncAll(int dimension) {
        Wizardry.logger.info("Sending global donation perk settings to all players");
        PacketSyncDonationPerks.Message packet = new PacketSyncDonationPerks.Message(DONOR_UUID_MAP.values().stream().map(Box::get).collect(Collectors.toList()));
        WizardryPacketHandler.net.sendToDimension((IMessage)packet, dimension);
    }

    private static void syncWith(EntityPlayerMP player) {
        Wizardry.logger.info("Sending global donation perk settings to {}", (Object)player.func_70005_c_());
        PacketSyncDonationPerks.Message packet = new PacketSyncDonationPerks.Message(DONOR_UUID_MAP.values().stream().map(Box::get).collect(Collectors.toList()));
        WizardryPacketHandler.net.sendTo((IMessage)packet, player);
    }

    public static void sendToServer(EntityPlayer player) {
        Wizardry.logger.info("Sending donation perk settings for {} to server", (Object)player.func_70005_c_());
        PacketRequestDonationPerks.Message message = new PacketRequestDonationPerks.Message(Wizardry.settings.donationPerkElement);
        WizardryPacketHandler.net.sendToServer((IMessage)message);
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            DonationPerksHandler.syncWith((EntityPlayerMP)event.getEntity());
        } else if (event.getEntity() instanceof EntityPlayer && DonationPerksHandler.isDonor((EntityPlayer)event.getEntity())) {
            DonationPerksHandler.sendToServer((EntityPlayer)event.getEntity());
        }
    }
}

