/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer.overlay;

import electroblob.wizardry.client.WizardryClientEventHandler;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RenderSixthSense {
    private static final ResourceLocation SCREEN_OVERLAY_TEXTURE = new ResourceLocation("ebwizardry", "textures/gui/sixth_sense_overlay.png");
    private static final ResourceLocation PASSIVE_MOB_MARKER_TEXTURE = new ResourceLocation("ebwizardry", "textures/gui/sixth_sense_marker_passive.png");
    private static final ResourceLocation HOSTILE_MOB_MARKER_TEXTURE = new ResourceLocation("ebwizardry", "textures/gui/sixth_sense_marker_hostile.png");
    private static final ResourceLocation PLAYER_MARKER_TEXTURE = new ResourceLocation("ebwizardry", "textures/gui/sixth_sense_marker_player.png");

    @SubscribeEvent
    public static void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET && Minecraft.func_71410_x().field_71439_g.func_70644_a(WizardryPotions.sixth_sense)) {
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            WizardryClientEventHandler.renderScreenOverlay(event.getResolution(), SCREEN_OVERLAY_TEXTURE);
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEvent(RenderLivingEvent.Post<EntityLivingBase> event) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = event.getRenderer().func_177068_d();
        float effectRadius = Spells.sixth_sense.getProperty("effect_radius").floatValue();
        float distance = event.getEntity().func_70032_d((Entity)mc.field_71439_g);
        if (mc.field_71439_g.func_70644_a(WizardryPotions.sixth_sense) && !(event.getEntity() instanceof EntityArmorStand) && event.getEntity() != mc.field_71439_g && mc.field_71439_g.func_70660_b(WizardryPotions.sixth_sense) != null && distance < effectRadius * (1.0f + (float)mc.field_71439_g.func_70660_b(WizardryPotions.sixth_sense).func_76458_c() * Constants.RANGE_INCREASE_PER_LEVEL)) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179097_i();
            GlStateManager.func_179137_b((double)event.getX(), (double)(event.getY() + (double)event.getEntity().field_70131_O * 0.6), (double)event.getZ());
            float yaw = mc.field_71474_y.field_74320_O == 2 ? renderManager.field_78732_j : -renderManager.field_78732_j;
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)yaw, (float)1.0f, (float)0.0f, (float)0.0f);
            float alpha = 1.0f;
            float f = 5.0f * (1.0f - distance / effectRadius);
            if (f <= 1.0f) {
                alpha = f;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            ResourceLocation texture = PASSIVE_MOB_MARKER_TEXTURE;
            if (ItemArtefact.isArtefactActive((EntityPlayer)mc.field_71439_g, WizardryItems.charm_sixth_sense)) {
                if (event.getEntity() instanceof IMob) {
                    texture = HOSTILE_MOB_MARKER_TEXTURE;
                } else if (event.getEntity() instanceof EntityPlayer) {
                    texture = PLAYER_MARKER_TEXTURE;
                }
            }
            mc.field_71446_o.func_110577_a(texture);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(-0.6, 0.6, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.6, 0.6, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.6, -0.6, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(-0.6, -0.6, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
    }
}

