/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.block;

import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCrystalFlowerPot
extends Block {
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public BlockCrystalFlowerPot() {
        super(Material.field_151594_q);
        this.func_149715_a(0.4f);
        this.func_149675_a(true);
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        if (world.field_72995_K && random.nextBoolean()) {
            ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos((double)pos.func_177958_n() + 0.3 + random.nextDouble() * 0.4, (double)pos.func_177956_o() + 0.6 + random.nextDouble() * 0.3, (double)pos.func_177952_p() + 0.3 + random.nextDouble() * 0.4).vel(0.0, 0.01, 0.0).time(20 + random.nextInt(10)).clr(0.5f + random.nextFloat() / 2.0f, 0.5f + random.nextFloat() / 2.0f, 0.5f + random.nextFloat() / 2.0f).spawn(world);
        }
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFlowerPot(Item.func_150898_a((Block)WizardryBlocks.crystal_flower), 0);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = new ItemStack(WizardryBlocks.crystal_flower);
        if (player.func_184586_b(hand).func_190926_b()) {
            player.func_184611_a(hand, stack);
        } else if (!player.func_191521_c(stack)) {
            player.func_71019_a(stack, false);
        }
        world.func_175656_a(pos, Blocks.field_150457_bL.func_176223_P());
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(WizardryBlocks.crystal_flower);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        drops.add((Object)new ItemStack(WizardryBlocks.crystal_flower));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151162_bE;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(world, pos) && (downState.func_185896_q() || downState.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighbour) {
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        if (!downState.func_185896_q() && downState.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) != BlockFaceShape.SOLID) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }
}

