/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.editor;

public class BoundingBox2D<T> {
    public final T owner;
    public int x0;
    public int x1;
    public int y0;
    public int y1;

    public BoundingBox2D(T owner) {
        this.owner = owner;
    }

    public BoundingBox2D(T owner, int x, int y, int w, int h) {
        this(owner);
        this.x0 = x;
        this.x1 = x + w;
        this.y0 = y;
        this.y1 = y + h;
    }

    public boolean isPointInside(int x, int y) {
        return x >= this.x0 && x < this.x1 && y >= this.y0 && y < this.y1;
    }

    public boolean overlapsWith(BoundingBox2D<?> box) {
        return box.x1 > this.x0 && box.x0 < this.x1 && box.y1 > this.y0 && box.y0 < this.y1 && box.owner != this.owner;
    }

    public boolean enclosedBy(BoundingBox2D<?> box) {
        return this.x0 >= box.x0 && this.x1 <= box.x1 && this.y0 >= box.y0 && this.y1 <= box.y1;
    }

    public void move(int dx, int dy) {
        this.x0 += dx;
        this.x1 += dx;
        this.y0 += dy;
        this.y1 += dy;
    }

    public BoundingBox2D<T> offset(int dx, int dy) {
        return new BoundingBox2D<T>(this.owner, this.x0 + dx, this.y0 + dy, this.x1 - this.x0, this.y1 - this.y0);
    }

    public int width() {
        return this.x1 - this.x0;
    }

    public int height() {
        return this.y1 - this.y0;
    }
}

