/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.compile;

import cd4017be.rscpl.compile.Context;
import cd4017be.rscpl.compile.Node;
import cd4017be.rscpl.compile.NodeCompiler;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Dep
implements Comparable<Dep> {
    public final Node src;
    public final Node dst;
    public final Type type;

    Dep(Node src, Node dst, Type type) {
        this.src = src;
        this.dst = dst;
        this.type = type;
        src.users.add(this);
        src.commonUser = null;
    }

    public void compile(MethodVisitor mv, Context context) {
        NodeCompiler code = this.src.code;
        Type st = code.getOutType();
        if (this.type != Type.VOID_TYPE) {
            if (this.src.localIdx >= 0) {
                mv.visitVarInsn(st.getOpcode(21), this.src.localIdx);
                if (--this.src.remUses <= 0) {
                    context.releaseLocal(this.src.localIdx, st);
                }
            } else {
                code.compile(this.src.deps, this.src.param, mv, context);
                if (this.src.getNumOfUsers() > 1) {
                    int i = this.src.localIdx = context.newLocal(st);
                    mv.visitVarInsn(st.getOpcode(54), i);
                    mv.visitVarInsn(st.getOpcode(21), i);
                } else {
                    this.src.localIdx = Integer.MAX_VALUE;
                }
                --this.src.remUses;
            }
            Dep.convert(st, this.type, mv);
            return;
        }
        if (this.src.localIdx >= 0) {
            return;
        }
        code.compile(this.src.deps, this.src.param, mv, context);
        if (st == Type.VOID_TYPE) {
            this.src.localIdx = Integer.MAX_VALUE;
            return;
        }
        if (this.src.getNumOfUsers() == 0) {
            this.src.localIdx = Integer.MAX_VALUE;
            mv.visitInsn(st.getSize() == 1 ? 87 : 88);
            return;
        }
        this.src.localIdx = context.newLocal(st);
        mv.visitVarInsn(st.getOpcode(54), this.src.localIdx);
    }

    public void compile(MethodVisitor mv, Context context, Label target, boolean cond) {
        if (this.type.getSort() > 5) {
            throw new IllegalStateException();
        }
        NodeCompiler code = this.src.code;
        Type st = code.getOutType();
        if (this.src.localIdx >= 0) {
            mv.visitVarInsn(st.getOpcode(21), this.src.localIdx);
            if (--this.src.remUses <= 0) {
                context.releaseLocal(this.src.localIdx, st);
            }
        } else if (this.src.getNumOfUsers() > 1) {
            code.compile(this.src.deps, this.src.param, mv, context);
            int i = this.src.localIdx = context.newLocal(st);
            mv.visitVarInsn(st.getOpcode(54), i);
            mv.visitVarInsn(st.getOpcode(21), i);
            --this.src.remUses;
        } else {
            this.src.localIdx = Integer.MAX_VALUE;
            if (code instanceof NodeCompiler.Bool) {
                ((NodeCompiler.Bool)code).compile(this.src.deps, this.src.param, mv, context, target, cond);
                return;
            }
            code.compile(this.src.deps, this.src.param, mv, context);
        }
        Dep.convert(st, this.type, mv);
        mv.visitJumpInsn(cond ? 154 : 153, target);
    }

    public void ensureDependencyEvaluation(MethodVisitor mv, Context context, boolean needsOwn) {
        this.recCompDeps(this.src, mv, context, needsOwn ? this.dst.order - 1 : this.dst.order, new HashSet<Node>());
    }

    private void recCompDeps(Node src, MethodVisitor mv, Context context, int order, Set<Node> visited) {
        if (src.localIdx >= 0) {
            return;
        }
        if (src.users.size() > 1) {
            if (src.getCommonUser().order >= order) {
                new Dep(src, this.dst, Type.VOID_TYPE).compile(mv, context);
                return;
            }
            if (!visited.add(src)) {
                return;
            }
        }
        for (Dep d : src.deps) {
            if (d == null) continue;
            this.recCompDeps(d.src, mv, context, order, visited);
        }
    }

    @Override
    public int compareTo(Dep o) {
        if (this.type == Type.BOOLEAN_TYPE) {
            if (o.type != Type.BOOLEAN_TYPE) {
                return -1;
            }
            return this.src.order - o.src.order;
        }
        if (o.type == Type.BOOLEAN_TYPE) {
            return 1;
        }
        return o.src.order - this.src.order;
    }

    public static boolean canConvert(Type from, Type to, boolean strict) {
        if (to == Type.VOID_TYPE) {
            return true;
        }
        if (from == Type.VOID_TYPE) {
            return false;
        }
        if (from.equals((Object)to)) {
            return true;
        }
        int st = from.getSort();
        int dt = to.getSort();
        if (strict && st > dt) {
            return false;
        }
        return st < 9 && dt < 9;
    }

    public static void convert(Type from, Type to, MethodVisitor mv) {
        int op;
        int dt;
        int st = from.getSort();
        if (st == (dt = to.getSort()) || st >= 9 || dt >= 9) {
            return;
        }
        if (dt == 1) {
            switch (st) {
                case 6: {
                    mv.visitInsn(150);
                    return;
                }
                case 7: {
                    mv.visitInsn(148);
                    return;
                }
                case 8: {
                    mv.visitInsn(152);
                    return;
                }
            }
            return;
        }
        if (st < 5) {
            st = 5;
        } else if (st > 5 && dt <= 5) {
            switch (st) {
                case 6: {
                    op = 139;
                    break;
                }
                case 7: {
                    op = 136;
                    break;
                }
                case 8: {
                    op = 142;
                    break;
                }
                default: {
                    return;
                }
            }
            mv.visitInsn(op);
            st = 5;
        }
        if (st == dt) {
            return;
        }
        switch ((st << 2) + dt) {
            case 22: {
                op = 146;
                break;
            }
            case 23: {
                op = 145;
                break;
            }
            case 24: {
                op = 147;
                break;
            }
            case 26: {
                op = 134;
                break;
            }
            case 27: {
                op = 133;
                break;
            }
            case 28: {
                op = 135;
                break;
            }
            case 31: {
                op = 140;
                break;
            }
            case 32: {
                op = 141;
                break;
            }
            case 34: {
                op = 137;
                break;
            }
            case 36: {
                op = 138;
                break;
            }
            case 38: {
                op = 144;
                break;
            }
            case 39: {
                op = 143;
                break;
            }
            default: {
                return;
            }
        }
        mv.visitInsn(op);
    }
}

