/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.frame.IFrameOperator;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.lib.render.HybridFastTESR;
import cd4017be.lib.util.DimPos;
import cd4017be.lib.util.MovedBlock;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.gui.BlockButton;
import cd4017be.rs_ctr.render.FrameRenderer;
import cd4017be.rs_ctr.render.ISpecialRenderComp;
import cd4017be.rs_ctr.tileentity.Teleporter;
import java.util.HashMap;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StructTeleporter
extends Teleporter
implements IFrameOperator,
IntConsumer,
Supplier<String>,
ISpecialRenderComp,
IInteractiveComponent.ITESRenderComp {
    static final int INNER_AREA = 2;
    static final int OUTER_FRAME = 4;
    static final int INVALID_FRAME = -3;
    public static int RANGE = 64;
    BlockButton button = new BlockButton(this, () -> null, this).setSize(0.5f, 0.25f);
    public int[] area = new int[6];
    public byte missingFrames = (byte)-1;
    boolean showFrame = true;

    public StructTeleporter() {
        this.ports[0].setLocation(0.875, 0.125, 0.0, EnumFacing.NORTH);
        this.ports[1].setLocation(0.125, 0.125, 0.0, EnumFacing.NORTH);
        this.ports[2].setLocation(0.625, 0.125, 0.0, EnumFacing.NORTH);
        this.ports[3].setLocation(0.375, 0.125, 0.0, EnumFacing.NORTH);
        this.ports[4].setLocation(0.5, 0.375, 0.0, EnumFacing.NORTH);
    }

    @Override
    protected int run() {
        BlockPos size;
        DimPos pa;
        boolean skipInner;
        if (this.action == 1) {
            return super.run();
        }
        if (this.missingFrames != 0 || this.area[3] <= 0 || this.area[4] <= 0 || this.area[5] <= 0) {
            return -3;
        }
        if (this.dest == null || this.ref == null || this.ref.dim != this.field_145850_b.field_73011_w.getDimension() || !this.isInArea(this.ref.pos)) {
            return -1;
        }
        double distance = StructTeleporter.attenuatedDistance(new DimPos((Vec3i)this.ref.pos, this.ref.dim), new DimPos((Vec3i)this.dest.pos, this.dest.dim));
        if (distance == 0.0) {
            return 100;
        }
        if ((this.action & 4) != 0) {
            skipInner = (this.action & 2) == 0;
            pa = new DimPos(this.area[0] - 1, this.area[1], this.area[2] - 1, this.ref.dim);
            size = new BlockPos(this.area[3] + 2, this.area[4], this.area[5] + 2);
        } else {
            skipInner = false;
            pa = new DimPos(this.area[0], this.area[1], this.area[2], this.ref.dim);
            size = new BlockPos(this.area[3], this.area[4], this.area[5]);
        }
        DimPos pb = new DimPos((Vec3i)this.dest.pos.func_177973_b((Vec3i)this.ref.pos).func_177971_a((Vec3i)pa), this.dest.dim);
        if (!(this.field_145850_b.func_175701_a((BlockPos)pa) && this.field_145850_b.func_175701_a((BlockPos)pb) && this.field_145850_b.func_175701_a((BlockPos)pa.add(size.func_177958_n() - 1, size.func_177956_o() - 1, size.func_177952_p() - 1)) && this.field_145850_b.func_175701_a((BlockPos)pb.add(size.func_177958_n() - 1, size.func_177956_o() - 1, size.func_177952_p() - 1)))) {
            return -2;
        }
        int count = 0;
        int inner = this.area[3] * this.area[5];
        if ((this.action & 2) != 0) {
            count += inner;
        }
        if ((this.action & 4) != 0) {
            count += (this.area[3] + 1) * (this.area[5] + 1) - inner;
        }
        long needed = Math.round((double)(count *= this.area[4]) * distance * ENERGY_PER_BLOCK);
        return this.initTeleport(() -> {
            if (this.unloaded) {
                return;
            }
            this.buffer -= needed;
            StructTeleporter.swapArea(pa, pb, size, skipInner);
            List<Entity> entitiesA = StructTeleporter.getEntities(pa, size, skipInner);
            List<Entity> entitiesB = StructTeleporter.getEntities(pb, size, skipInner);
            StructTeleporter.moveEntities(entitiesA, (BlockPos)pa, pb);
            StructTeleporter.moveEntities(entitiesB, (BlockPos)pb, pa);
        }, needed);
    }

    private boolean isInArea(BlockPos pos) {
        int i = pos.func_177958_n() - this.area[0];
        if (i < -1 || i > this.area[3]) {
            return false;
        }
        i = pos.func_177956_o() - this.area[1];
        if (i < 0 || i >= this.area[4]) {
            return false;
        }
        i = pos.func_177952_p() - this.area[2];
        return i >= -1 && i <= this.area[5];
    }

    private static void swapArea(DimPos pa, DimPos pb, BlockPos size, boolean skipInner) {
        int rx = size.func_177958_n();
        int ry = size.func_177956_o();
        int rz = size.func_177952_p();
        int dx = 1;
        int dy = 1;
        int dz = 1;
        if (pb.func_177958_n() < pa.func_177958_n()) {
            pa = pa.add(rx, 0, 0);
            pb = pb.add(rx, 0, 0);
            rx = -rx;
            dx = -1;
        } else {
            pa = pa.add(-1, 0, 0);
            pb = pb.add(-1, 0, 0);
        }
        if (pb.func_177956_o() < pa.func_177956_o()) {
            pa = pa.add(0, ry, 0);
            pb = pb.add(0, ry, 0);
            ry = -ry;
            dy = -1;
        } else {
            pa = pa.add(0, -1, 0);
            pb = pb.add(0, -1, 0);
        }
        if (pb.func_177952_p() < pa.func_177952_p()) {
            pa = pa.add(0, 0, rz);
            pb = pb.add(0, 0, rz);
            rz = -rz;
            dz = -1;
        } else {
            pa = pa.add(0, 0, -1);
            pb = pb.add(0, 0, -1);
        }
        HashMap<DimPos, NBTTagCompound> tiles = new HashMap<DimPos, NBTTagCompound>();
        for (int x = rx; x != 0; x -= dx) {
            for (int z = rz; z != 0; z -= dz) {
                if (skipInner && x != dx && z != dz && x != rx && z != rz) continue;
                for (int y = ry; y != 0; y -= dy) {
                    StructTeleporter.swap(pa.add(x, y, z), pb.add(x, y, z), tiles);
                }
            }
        }
        MovedBlock.addTileEntities(tiles);
    }

    @Override
    public void onFrameBreak(BlockPos pos) {
        int i = 0;
        int d = pos.func_177958_n() - this.area[0];
        if (d == this.area[3]) {
            i |= 1;
        } else if (d != -1) {
            return;
        }
        d = pos.func_177956_o() - this.area[1];
        if (d == this.area[4] - 1) {
            i |= 2;
        } else if (d != 0) {
            return;
        }
        d = pos.func_177952_p() - this.area[2];
        if (d == this.area[5]) {
            i |= 4;
        } else if (d != -1) {
            return;
        }
        this.missingFrames = (byte)(this.missingFrames | 1 << i);
        this.markDirty(2);
    }

    @Override
    public String get() {
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            return TooltipUtil.translate((String)("port.rs_ctr.show_sel" + (this.showFrame ? (char)'1' : '0')));
        }
        int dx = this.area[3];
        int dy = this.area[4];
        int dz = this.area[5];
        char status = dx <= 0 || dy <= 0 || dz <= 0 ? (char)'2' : (this.missingFrames != 0 ? (char)'1' : '0');
        return TooltipUtil.format((String)("port.rs_ctr.area" + status), (Object[])new Object[]{dx, dy, dz, Integer.bitCount(this.missingFrames & 0xFF)});
    }

    @Override
    public void accept(int value) {
        if ((value & 1) != 0) {
            return;
        }
        if ((value & 2) == 0) {
            if (this.area[3] <= 0 || this.area[4] <= 0 || this.area[5] <= 0 || (this.missingFrames = (byte)IFrameOperator.checkCorners(this.field_145850_b, this.field_174879_c, this.area)) != 0) {
                IFrameOperator.unlinkCorners(this.field_145850_b, this.field_174879_c, this.area, ~this.missingFrames);
                IFrameOperator.scanArea(this.field_145850_b, this.field_174879_c, this.area, RANGE, this.getOrientation().front);
                this.missingFrames = (byte)IFrameOperator.checkCorners(this.field_145850_b, this.field_174879_c, this.area);
            }
        } else {
            this.showFrame = !this.showFrame;
        }
        this.markDirty(2);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        IFrameOperator.writeArea(this.area, nbt, this.field_174879_c);
        nbt.func_74774_a("frame", this.missingFrames);
        nbt.func_74757_a("dsp", this.showFrame);
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        IFrameOperator.readArea(this.area, nbt, this.field_174879_c);
        this.missingFrames = nbt.func_74771_c("frame");
        this.showFrame = nbt.func_74767_n("dsp");
    }

    @Override
    public void breakBlock() {
        super.breakBlock();
        IFrameOperator.unlinkCorners(this.field_145850_b, this.field_174879_c, this.area, ~this.missingFrames);
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        list.add(this.button);
    }

    @Override
    protected void orient(Orientation o) {
        super.orient(o);
        this.button.setLocation(0.5, 0.75, 0.0, o);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpecial(double x, double y, double z, float t, FontRenderer fr) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        int mf = this.missingFrames & 0xFF;
        if (mf == 0) {
            return;
        }
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        int i = 0;
        while (i < 8) {
            if ((mf & 1) != 0) {
                BlockPos p = IFrameOperator.getCorner(this.area, i).func_177973_b((Vec3i)this.field_174879_c);
                double x1 = x + (double)p.func_177958_n();
                double y1 = y + (double)p.func_177956_o();
                double z1 = z + (double)p.func_177952_p();
                RenderGlobal.func_189694_a((double)x1, (double)y1, (double)z1, (double)(x1 + 1.0), (double)(y1 + 1.0), (double)(z1 + 1.0), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            ++i;
            mf >>= 1;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return this.missingFrames == 0 && !HybridFastTESR.isAimedAt((TileEntity)this);
    }

    public double func_145833_n() {
        int d = this.area[3];
        double d2 = super.func_145833_n() + (double)(d * d);
        d = this.area[4];
        double d3 = d2 + (double)(d * d);
        d = this.area[5];
        return d3 + (double)(d * d);
    }

    public void render(World world, BlockPos pos, double x, double y, double z, int light, BufferBuilder buffer) {
        if (this.showFrame) {
            FrameRenderer.renderFrame(x - 0.0625, y - 0.0625, z - 0.0625, (x += (double)(this.area[0] - pos.func_177958_n())) + (double)this.area[3] + 0.0625, (y += (double)(this.area[1] - pos.func_177956_o())) + (double)this.area[4] + 0.0625, (z += (double)(this.area[2] - pos.func_177952_p())) + (double)this.area[5] + 0.0625, buffer, this.missingFrames == 0 ? 0x7FFF007F : 0x7F0000FF);
        }
    }

    public AxisAlignedBB getRenderBB(World world, BlockPos pos) {
        return new AxisAlignedBB((double)(this.area[0] - 1), (double)this.area[1], (double)(this.area[2] - 1), (double)(this.area[0] + this.area[3] + 1), (double)(this.area[1] + this.area[4]), (double)(this.area[2] + this.area[5] + 1));
    }
}

