/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.network.SyncNetworkHandler;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.CommonProxy;
import cd4017be.rs_ctr.render.PortRenderer;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class PowerHub
extends WallMountGate
implements EnergyHandler,
IEnergyStorage,
TickRegistry.IUpdatable,
IPlayerPacketReceiver,
IServerPacketReceiver,
IInteractiveComponent,
IInteractiveComponent.IBlockRenderComp {
    public static long FE_UNIT = 100L;
    ItemStack battery = ItemStack.field_190927_a;
    public long charge;
    public long cap;
    Set<EntityPlayerMP> watching;
    boolean update;

    public PowerHub() {
        this.ports = new MountedPort[8];
        for (int i = 0; i < 8; ++i) {
            this.ports[i] = new MountedPort((IPortProvider)this, i, EnergyHandler.class, false).setLocation(i < 4 ? 0.125 : 0.875, 0.125 + (double)(i & 3) * 0.25, 0.5, EnumFacing.SOUTH).setName("port.rs_ctr.energy_io");
        }
        this.watching = null;
    }

    public EnergyHandler getPortCallback(int pin) {
        return this;
    }

    public void setPortCallback(int pin, Object callback) {
    }

    @Override
    protected void resetPin(int pin) {
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        nbt.func_74772_a("E", this.charge);
        nbt.func_74772_a("C", this.cap);
        if (!this.battery.func_190926_b()) {
            nbt.func_74782_a("bat", (NBTBase)this.battery.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        this.charge = nbt.func_74763_f("E");
        this.cap = nbt.func_74763_f("C");
        this.battery = nbt.func_150297_b("bat", 10) ? new ItemStack(nbt.func_74775_l("bat")) : ItemStack.field_190927_a;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityEnergy.ENERGY && facing == this.o.front;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        return (T)(cap == CapabilityEnergy.ENERGY && facing == this.o.front ? this : null);
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        list.add(this);
    }

    @Override
    public void breakBlock() {
        super.breakBlock();
        this.onRemove(null);
        this.charge = 0L;
        this.cap = 0L;
    }

    public Pair<Vec3d, EnumFacing> rayTrace(Vec3d start, Vec3d dir) {
        return IInteractiveComponent.rayTraceFlat((Vec3d)start, (Vec3d)dir, (Vec3d)new Vec3d(0.5, 0.5, 0.5), (EnumFacing)this.o.back, (float)0.25f, (float)0.375f);
    }

    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        ItemStack stack = player.func_184614_ca();
        if (hit || player.func_70093_af() && stack.func_190926_b()) {
            this.onRemove(player);
            this.charge = 0L;
            this.cap = 0L;
            this.markDirty(3);
        } else if (!stack.func_190926_b()) {
            IEnergyStorage es = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (es != null && es.canExtract() && es.canReceive()) {
                this.onRemove(player);
                this.charge += (long)es.extractEnergy(Integer.MAX_VALUE, false) * FE_UNIT;
                this.cap = (long)es.receiveEnergy(Integer.MAX_VALUE, true) * FE_UNIT;
            } else {
                this.cap = CommonProxy.getCap(stack);
                if (this.cap != 0L) {
                    this.onRemove(player);
                } else {
                    return false;
                }
            }
            this.battery = stack;
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            if (this.charge > this.cap) {
                this.charge = this.cap;
            }
            this.markDirty(3);
        } else {
            return false;
        }
        return true;
    }

    private void onRemove(EntityPlayer player) {
        if (this.battery.func_190926_b()) {
            return;
        }
        IEnergyStorage es = (IEnergyStorage)this.battery.getCapability(CapabilityEnergy.ENERGY, null);
        if (es != null) {
            this.charge -= (long)es.receiveEnergy((int)(this.charge / FE_UNIT), false) * FE_UNIT;
        }
        if (player != null) {
            ItemFluidUtil.dropStack((ItemStack)this.battery, (Entity)player);
        } else {
            ItemFluidUtil.dropStack((ItemStack)this.battery, (World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
        this.battery = ItemStack.field_190927_a;
    }

    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        return Pair.of((Object)new Vec3d(0.5, 0.5, 0.5), (Object)(this.battery.func_190926_b() ? TooltipUtil.translate((String)"port.rs_ctr.battery0") : this.battery.func_82833_r() + "\n" + TooltipUtil.format((String)"port.rs_ctr.battery", (Object[])new Object[]{this.cap < 0L ? Double.NaN : (double)this.charge / 1000.0, this.cap < 0L ? Double.NaN : (double)this.cap / 1000.0})));
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        if (this.battery.func_190926_b()) {
            return;
        }
        PortRenderer.PORT_RENDER.drawModel(quads, 0.5f, 0.5f, 0.5f, this.o, "_battery");
    }

    public int changeEnergy(int dE, boolean sim) {
        if (this.cap < 0L) {
            return dE;
        }
        long E = this.charge + (long)dE;
        if (E < 0L) {
            dE = (int)((long)dE - E);
            E = 0L;
        } else if (E > this.cap) {
            dE = (int)((long)dE - (E - this.cap));
            E = this.cap;
        }
        if (!sim) {
            this.charge = E;
            this.markDirty(0);
        }
        return dE;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long dE = (this.cap - this.charge) / FE_UNIT;
        if (dE < (long)maxReceive) {
            maxReceive = (int)dE;
        }
        if (!simulate) {
            this.charge += (long)maxReceive * FE_UNIT;
            this.markDirty(0);
        }
        return maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        long dE = this.charge / FE_UNIT;
        if (dE < (long)maxExtract) {
            maxExtract = (int)dE;
        }
        if (!simulate) {
            this.charge -= (long)maxExtract * FE_UNIT;
            this.markDirty(0);
        }
        return maxExtract;
    }

    public int getEnergyStored() {
        return (int)(this.charge / FE_UNIT);
    }

    public int getMaxEnergyStored() {
        return (int)(this.cap / FE_UNIT);
    }

    public boolean canExtract() {
        return this.cap > 0L;
    }

    public boolean canReceive() {
        return this.cap > 0L;
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        this.watching = null;
    }

    public void markDirty(int mode) {
        super.markDirty(mode);
        if (mode == 0 && this.watching != null && !this.update) {
            this.update = true;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
        }
    }

    public void process() {
        this.update = false;
        if (this.watching == null) {
            return;
        }
        Iterator<EntityPlayerMP> it = this.watching.iterator();
        while (it.hasNext()) {
            EntityPlayerMP player = it.next();
            if (!player.field_70128_L && !(player.func_174831_c(this.field_174879_c) > 30.0)) continue;
            it.remove();
        }
        if (this.watching.isEmpty()) {
            this.watching = null;
        } else {
            PacketBuffer pkt = SyncNetworkHandler.preparePacket((BlockPos)this.field_174879_c);
            pkt.writeLong(this.charge);
            SyncNetworkHandler.instance.sendToPlayers(pkt, this.watching);
        }
    }

    public void handleServerPacket(PacketBuffer pkt) throws Exception {
        this.charge = pkt.readLong();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        if (super.hasFastRenderer()) {
            this.watching = null;
            return true;
        }
        if (this.watching == null) {
            this.watching = Collections.emptySet();
            SyncNetworkHandler.instance.sendToServer(SyncNetworkHandler.preparePacket((BlockPos)this.field_174879_c));
        }
        return false;
    }

    public void handlePlayerPacket(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        if (sender.field_70128_L || sender.func_174831_c(this.field_174879_c) > 30.0) {
            return;
        }
        if (this.watching == null) {
            this.watching = new HashSet<EntityPlayerMP>(2);
        }
        if (this.watching.add(sender)) {
            this.markDirty(0);
        }
    }

    @Override
    public Object getState(int id) {
        return null;
    }
}

