/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.network.SyncNetworkHandler;
import cd4017be.lib.render.Util;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.ClientProxy;
import cd4017be.rs_ctr.render.ISpecialRenderComp;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import cd4017be.rs_ctr.tileentity.part.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Panel
extends WallMountGate
implements TickRegistry.IUpdatable,
IServerPacketReceiver,
IPlayerPacketReceiver,
IGuiHandlerTile,
Module.IPanel,
ISpecialRenderComp,
IInteractiveComponent.IBlockRenderComp,
AdvancedBlock.ITilePlaceHarvest {
    public static double UPDATE_RANGE0 = 256.0;
    public static double UPDATE_RANGE1 = UPDATE_RANGE0 * 1.2;
    public static double TEXT_RANGE = 100.0;
    Orientation oldO = Orientation.N;
    Module[] modules = new Module[0];
    Set<EntityPlayerMP> watching;
    boolean update;
    int cachedLight;

    public Panel() {
        this.ports = new MountedPort[0];
        this.watching = null;
        this.cachedLight = -1;
    }

    @Override
    public Port getPort(int pin) {
        Port p = super.getPort(pin);
        if (p == null) {
            for (MountedPort port : this.ports) {
                if (port.pin != pin) continue;
                return port;
            }
        }
        return p;
    }

    public Object getPortCallback(int pin) {
        return this.modules[pin >> 1].getPortCallback();
    }

    public void setPortCallback(int pin, Object callback) {
        this.modules[pin >> 1].setPortCallback(callback);
    }

    @Override
    protected void resetPin(int pin) {
        Module m = this.modules[pin >> 1];
        if (m != null) {
            m.resetInput();
        }
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        NBTTagList list = new NBTTagList();
        for (Module m : this.modules) {
            list.func_74742_a((NBTBase)(m != null ? m.serializeNBT() : new NBTTagCompound()));
        }
        nbt.func_74782_a("modules", (NBTBase)list);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        int n;
        NBTTagList list = nbt.func_150295_c("modules", 10);
        if (mode != 2) {
            for (n = list.func_74745_c(); n > 0 && list.func_150305_b(n - 1).func_82582_d(); --n) {
            }
        }
        if (n != this.modules.length) {
            this.modules = Arrays.copyOf(this.modules, n);
        }
        ArrayList<MountedPort> ports = new ArrayList<MountedPort>(this.modules.length);
        for (int i = 0; i < this.modules.length; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            String id = tag.func_74779_i("id");
            Module m = this.modules[i];
            if (m == null || !m.id().equals(id)) {
                if (m != null) {
                    m.onUnload();
                }
                this.modules[i] = m = Module.get(id);
            }
            if (m == null) continue;
            m.deserializeNBT((NBTBase)tag);
            m.init(ports, i, this);
            if (!this.unloaded) {
                m.onLoad(this);
            }
            if (mode != 4) continue;
            m.resetInput();
        }
        n = ports.size();
        this.ports = ports.toArray(this.ports.length == n ? this.ports : new MountedPort[n]);
        super.loadState(nbt, mode);
    }

    @Override
    public void onLoad() {
        for (Module m : this.modules) {
            if (m == null) continue;
            m.onLoad(this);
        }
        super.onLoad();
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        for (Module m : this.modules) {
            if (m == null) continue;
            m.onUnload();
        }
        this.watching = null;
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        for (Module m : this.modules) {
            if (m == null) continue;
            list.add(m);
        }
    }

    @Override
    public ArrayList<IInteractiveComponent.IBlockRenderComp> getBMRComponents() {
        Collection list = super.getBMRComponents();
        ((ArrayList)list).add(this);
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        Orientation o = this.getOrientation();
        Vec3d dx = o.X.func_186678_a(-0.25);
        Vec3d dy = o.Y.func_186678_a(0.25);
        Vec3d p = o.Z.func_186678_a(-0.005).func_178788_d(dx.func_186678_a(0.5)).func_178788_d(dy.func_186678_a(0.5));
        for (MountedPort port : this.ports) {
            int i;
            int n = i = port.isMaster ? 4 : 0;
            int j = port.type == SignalHandler.class ? 0 : (port.type == BlockReference.BlockHandler.class ? 4 : (port.type == EnergyHandler.class ? 8 : 12));
            Vec3d p1 = p;
            Vec3d dx1 = dx;
            if (port.face == o.back) {
                p1 = dx.func_186678_a(0.5).func_178788_d(dy.func_186678_a(0.5));
                dx1 = dx.func_186678_a(-1.0);
            }
            quads.add(new BakedQuad(Util.texturedRect((Vec3d)port.pos.func_178787_e(p1), (Vec3d)dx1, (Vec3d)dy, (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_sockets, (float)i, (float)j), (Vec2f)Util.getUV((TextureAtlasSprite)ClientProxy.t_sockets, (float)(i + 4), (float)(j + 4)), (int)-1, (int)0), -1, port.face, ClientProxy.t_sockets, true, DefaultVertexFormats.field_176600_a));
        }
    }

    @Override
    public void remove(int id) {
        int l = this.ports.length;
        for (int i = 0; i < l; ++i) {
            MountedPort port = this.ports[i];
            if (port.pin >> 1 != id) continue;
            port.setConnector(null, null);
            port.onUnload();
            this.ports[i--] = this.ports[--l];
        }
        Module m = this.modules[id];
        if (m != null) {
            m.onUnload();
            this.modules[id] = null;
        }
        if (l < this.ports.length) {
            this.ports = Arrays.copyOf(this.ports, l);
            Arrays.sort(this.ports);
        }
        this.gui = null;
        this.markDirty(3);
    }

    @Override
    public boolean add(Module m) {
        int b = m.getBounds();
        int i = -1;
        for (int j = 0; j < this.modules.length; ++j) {
            Module mod = this.modules[j];
            if (mod != null) {
                if ((mod.getBounds() & b) == 0) continue;
                return false;
            }
            if (i >= 0) continue;
            i = j;
        }
        if (i < 0) {
            i = this.modules.length;
            this.modules = Arrays.copyOf(this.modules, i + 1);
        }
        this.modules[i] = m;
        ArrayList<MountedPort> list = new ArrayList<MountedPort>();
        m.init(list, i, this);
        m.onLoad(this);
        if (!list.isEmpty()) {
            i = this.ports.length;
            this.ports = Arrays.copyOf(this.ports, i + list.size());
            for (MountedPort port : list) {
                this.ports[i++] = port;
            }
            Arrays.sort(this.ports);
            for (MountedPort port : list) {
                port.onLoad();
            }
        }
        this.markDirty(3);
        this.gui = null;
        return true;
    }

    @Override
    public void updateDisplay() {
        if (this.watching != null && !this.update) {
            this.update = true;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
        }
        this.markDirty(0);
    }

    public void process() {
        this.update = false;
        if (this.watching == null) {
            return;
        }
        Iterator<EntityPlayerMP> it = this.watching.iterator();
        while (it.hasNext()) {
            EntityPlayerMP player = it.next();
            if (!player.field_70128_L && !(player.func_174831_c(this.field_174879_c) > UPDATE_RANGE1)) continue;
            it.remove();
        }
        if (this.watching.isEmpty()) {
            this.watching = null;
        } else {
            PacketBuffer pkt = SyncNetworkHandler.preparePacket((BlockPos)this.field_174879_c);
            for (Module m : this.modules) {
                if (m == null) continue;
                m.writeSync(pkt, false);
            }
            SyncNetworkHandler.instance.sendToPlayers(pkt, this.watching);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleServerPacket(PacketBuffer pkt) throws Exception {
        for (Module m : this.modules) {
            if (m == null) continue;
            m.readSync(pkt);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        double d = Minecraft.func_71410_x().field_71439_g.func_174831_c(this.field_174879_c);
        if (d > UPDATE_RANGE0) {
            this.watching = null;
        } else if (this.watching == null) {
            this.watching = Collections.emptySet();
            SyncNetworkHandler.instance.sendToServer(SyncNetworkHandler.preparePacket((BlockPos)this.field_174879_c));
        }
        return d > TEXT_RANGE;
    }

    public void handlePlayerPacket(PacketBuffer pkt, EntityPlayerMP sender) {
        if (sender.field_70128_L || sender.func_174831_c(this.field_174879_c) > UPDATE_RANGE1) {
            return;
        }
        if (this.watching == null) {
            this.watching = new HashSet<EntityPlayerMP>(2);
        }
        if (this.watching.add(sender)) {
            pkt = SyncNetworkHandler.preparePacket((BlockPos)this.field_174879_c);
            for (Module m : this.modules) {
                if (m == null) continue;
                m.writeSync(pkt, true);
            }
            SyncNetworkHandler.instance.sendToPlayer(pkt, sender);
        }
    }

    @Override
    public World world() {
        return this.field_145850_b;
    }

    public Container getContainer(EntityPlayer player, int id) {
        return id < this.modules.length ? this.modules[id].getCfgContainer(player) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGuiScreen(EntityPlayer player, int id) {
        return id < this.modules.length ? this.modules[id].getCfgScreen(player) : null;
    }

    @Override
    public void renderSpecial(double x, double y, double z, float t, FontRenderer fr) {
        GlStateManager.func_179094_E();
        Util.moveAndOrientToBlock((double)x, (double)y, (double)z, (Orientation)this.o);
        GlStateManager.func_179137_b((double)-0.5, (double)0.5, (double)0.505);
        GlStateManager.func_179139_a((double)0.0078125, (double)-0.0078125, (double)-1.0);
        Util.luminate((TileEntity)this, (EnumFacing)this.o.back, (int)0);
        for (Module m : this.modules) {
            if (m == null) continue;
            m.drawText(fr);
        }
        GlStateManager.func_179121_F();
        this.cachedLight = -1;
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (item.func_77942_o()) {
            this.loadState(item.func_77978_p(), 4);
            this.markDirty(3);
        }
        if (entity instanceof EntityPlayerMP) {
            this.handlePlayerPacket(null, (EntityPlayerMP)entity);
        }
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        if (this.modules.length != 0) {
            for (Module m : this.modules) {
                if (m == null) continue;
                return this.makeDefaultDrops();
            }
        }
        return this.makeDefaultDrops(null);
    }

    @Override
    public int frontLight() {
        int l = this.cachedLight;
        if (l >= 0) {
            return l;
        }
        this.cachedLight = this.field_145850_b.func_175626_b(this.field_174879_c.func_177972_a(this.o.back), 0);
        return this.cachedLight;
    }

    @Override
    public Object getState(int id) {
        return this.modules[id >> 1].getState(id & 1);
    }
}

