/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.computers.ComputerAPI;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.TickRegistry;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import java.util.Map;
import li.cil.oc.api.Driver;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers"), @Optional.Interface(iface="net.minecraft.util.ITickable", modid="opencomputers"), @Optional.Interface(iface="cd4017be.api.rs_ctr.com.EnergyHandler", modid="opencomputers")})
public class OC_Adapter
extends WallMountGate
implements Environment,
ITickable,
TickRegistry.IUpdatable,
EnergyHandler {
    public static double OC_UNIT = 1000.0;
    public static int MAX_BUFFER = 64;
    private Object node = ComputerAPI.newOCnode((TileEntity)this, (String)"rsio", (boolean)true);
    private final SignalHandler[] out = new SignalHandler[8];
    private final int[] state = new int[16];
    private int update;
    private int interrupt;
    private String target = "";
    private int[] bufIN;
    private int[] bufOUT;
    private long changes;
    private int nIN;
    private int nOUT;
    private int tIN;
    private int tOUT;
    private int time;
    private byte tick;

    public OC_Adapter() {
        int i;
        this.ports = new MountedPort[20];
        for (i = 0; i < 16; ++i) {
            this.ports[i] = new MountedPort((IPortProvider)this, i, SignalHandler.class, i < 8).setLocation(0.125 + 0.25 * (double)(i & 3), 0.125 + 0.25 * (double)(i >> 2), 0.75, EnumFacing.SOUTH).setName((i < 8 ? "port.rs_ctr.o" : "port.rs_ctr.i") + (i & 7));
        }
        for (i = 16; i < 20; ++i) {
            this.ports[i] = new MountedPort((IPortProvider)this, i, EnergyHandler.class, false).setLocation(i < 18 ? 0.125 : 0.875, 0.375 + (double)(i & 1) * 0.25, 0.0, EnumFacing.NORTH).setName("port.rs_ctr.energy_io");
        }
    }

    public Object getPortCallback(int pin) {
        if (this.node == null) {
            return pin < 16 ? val -> {
                if (val == this.state[pin]) {
                    return;
                }
                this.state[pin] = val;
            } : EnergyHandler.NOP;
        }
        return pin < 16 ? val -> {
            if (val == this.state[pin]) {
                return;
            }
            this.state[pin] = val;
            int ipin = pin - 8;
            if ((this.interrupt >> ipin & 1) != 0) {
                ((Node)this.node).sendToAddress(this.target, "computer.signal", new Object[]{"rs_change", ipin, val});
            }
            if (ipin < this.nIN && this.tick == TickRegistry.TICK) {
                this.bufIN[ipin + (this.time & this.tIN) * this.nIN] = val;
            }
        } : this;
    }

    public void setPortCallback(int pin, Object callback) {
        if (callback instanceof SignalHandler) {
            this.out[pin] = (SignalHandler)callback;
            this.out[pin].updateSignal(this.state[pin]);
        } else {
            this.out[pin] = null;
        }
    }

    @Override
    protected void resetPin(int pin) {
        if (pin < 16) {
            ((SignalHandler)this.getPortCallback(pin)).updateSignal(0);
        }
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        if (mode == 0) {
            NBTTagCompound tag;
            if (this.node != null) {
                ComputerAPI.saveNode((Object)this.node, (NBTTagCompound)nbt);
            }
            nbt.func_74778_a("event", this.target);
            nbt.func_74774_a("int", (byte)this.interrupt);
            nbt.func_74774_a("update", (byte)this.update);
            nbt.func_74783_a("io", this.state);
            nbt.func_74768_a("time", this.time);
            if (this.bufIN != null) {
                tag = new NBTTagCompound();
                tag.func_74774_a("n", (byte)this.nIN);
                tag.func_74774_a("t", (byte)this.tIN);
                tag.func_74783_a("buf", this.bufIN);
                nbt.func_74782_a("in", (NBTBase)tag);
            }
            if (this.bufOUT != null) {
                tag = new NBTTagCompound();
                tag.func_74774_a("n", (byte)this.nOUT);
                tag.func_74774_a("t", (byte)this.tOUT);
                tag.func_74783_a("buf", this.bufOUT);
                tag.func_74772_a("c", this.changes);
                nbt.func_74782_a("out", (NBTBase)tag);
            }
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 0) {
            if (this.node != null) {
                ComputerAPI.readNode((Object)this.node, (NBTTagCompound)nbt);
            }
            this.target = nbt.func_74779_i("event");
            this.interrupt = nbt.func_74771_c("int") & 0xFF;
            this.update = nbt.func_74771_c("update");
            int[] arr = nbt.func_74759_k("io");
            System.arraycopy(arr, 0, this.state, 0, Math.min(arr.length, this.state.length));
            NBTTagCompound tag = nbt.func_74775_l("in");
            this.nIN = tag.func_74771_c("n");
            this.tIN = tag.func_74771_c("t");
            this.bufIN = tag.func_74759_k("buf");
            if (this.nIN == 0 || arr.length != this.nIN * (this.tIN + 1)) {
                this.bufIN = null;
                this.tIN = 0;
                this.nIN = 0;
            }
            tag = nbt.func_74775_l("out");
            this.nOUT = tag.func_74771_c("n");
            this.tOUT = tag.func_74771_c("t");
            this.bufOUT = tag.func_74759_k("buf");
            this.changes = tag.func_74763_f("c");
            if (this.nOUT == 0 || arr.length != this.nOUT * (this.tOUT + 1)) {
                this.bufOUT = null;
                this.tOUT = 0;
                this.nOUT = 0;
            }
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.update != 0 && !this.field_145850_b.field_72995_K) {
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
        }
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        ComputerAPI.removeOCnode((Object)this.node);
    }

    public Node node() {
        return (Node)this.node;
    }

    public void onConnect(Node arg0) {
    }

    public void onDisconnect(Node arg0) {
    }

    public void onMessage(Message arg0) {
    }

    public void func_73660_a() {
        int c;
        int t;
        if (this.node == null) {
            return;
        }
        ComputerAPI.update((TileEntity)this, (Object)this.node, (double)0.0);
        ++this.time;
        this.tick = TickRegistry.TICK;
        if (this.bufIN != null) {
            t = (this.time & this.tIN) * this.nIN;
            for (int i = this.nIN - 1; i >= 0; --i) {
                this.bufIN[i + t] = this.state[i + 8];
            }
        }
        if (this.bufOUT != null && (c = (int)(this.changes >> (t = (this.time & this.tOUT) * this.nOUT)) & 255 >> 8 - this.nOUT) != 0) {
            this.changes ^= (long)c << t;
            for (int i = this.nOUT - 1; i >= 0; --i) {
                if ((c >> i & 1) == 0) continue;
                this.setOut(i, this.bufOUT[i + t]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        int[] nArray = this.state;
        synchronized (this.state) {
            for (int i = 0; i < 8; ++i) {
                if ((this.update >> i & 1) == 0 || this.out[i] == null) continue;
                this.out[i].updateSignal(this.state[i]);
            }
            this.update = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Optional.Method(modid="opencomputers")
    @Callback(direct=true, limit=100, doc="function(port:number[, time:number]):number -- returns the signal currently (or at the given buffered time < time()) received at given input port [0-7].")
    public Object[] getInput(Context context, Arguments args) throws Exception {
        int i = args.checkInteger(0);
        if (i < 0 || i >= 8) {
            return null;
        }
        if (args.count() > 1 && i < this.nIN) {
            int t = args.checkInteger(1);
            return new Object[]{this.time() > t && this.time - t <= this.tIN ? (double)this.bufIN[i + (t & this.tIN) * this.nIN] : Double.NaN};
        }
        return new Object[]{this.state[i + 8]};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Optional.Method(modid="opencomputers")
    @Callback(direct=true, limit=25, doc="function(port:number[, time:number], value:number):bool -- sets the signal value of given output port [0-7] for the next tick (or given future time > time()).")
    public Object[] setOutput(Context context, Arguments args) throws Exception {
        if (args.count() > 2) {
            int i = args.checkInteger(0);
            if (i < 0 || i >= this.nOUT) {
                return null;
            }
            int t = args.checkInteger(1) - 1;
            int v = args.checkInteger(2);
            if (t - this.time > this.tOUT + 1) {
                return new Object[]{false};
            }
            if (t > this.time) {
                this.bufOUT[i += (t & this.tOUT) * this.nOUT] = v;
                this.changes |= 1L << i;
                return new Object[]{true};
            } else {
                int[] nArray = this.state;
                synchronized (this.state) {
                    this.setOut(i, v);
                    // ** MonitorExit[var6_9] (shouldn't be in output)
                    return new Object[]{true};
                }
            }
        }
        int[] nArray = this.state;
        synchronized (this.state) {
            if (args.isTable(0)) {
                for (Map.Entry e : args.checkTable(0).entrySet()) {
                    this.setOut(((Number)e.getKey()).intValue(), ((Number)e.getValue()).intValue());
                }
            } else {
                this.setOut(args.checkInteger(0), args.checkInteger(1));
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return new Object[]{true};
        }
    }

    @Optional.Method(modid="opencomputers")
    @Callback(direct=true, doc="function(bitmask:number) -- registers the caller to receive {\"rs_change\", port, value} events when any of the input ports specified by bitmask changes.")
    public Object[] registerEvent(Context context, Arguments args) throws Exception {
        this.interrupt = args.checkInteger(0);
        this.target = context.node().address();
        return null;
    }

    @Optional.Method(modid="opencomputers")
    @Callback(direct=true, doc="function([setTime:number]):number -- returns the internal timer in ticks or resets it to the given value")
    public Object[] time(Context context, Arguments args) throws Exception {
        if (args.count() > 0) {
            this.time = args.checkInteger(0);
        }
        return new Object[]{this.time()};
    }

    private int time() {
        return this.tick == TickRegistry.TICK ? this.time : this.time + 1;
    }

    @Optional.Method(modid="opencomputers")
    @Callback(direct=false, doc="function(inputs:number, ticks:number) -- configures the first given number of inputs to be buffered over given number of ticks to support tick precise reading.")
    public Object[] bufferInput(Context context, Arguments args) throws Exception {
        int n = args.checkInteger(0);
        if (n <= 0) {
            this.nIN = 0;
            this.tIN = 0;
            this.bufIN = null;
        } else {
            int t;
            if (n > 8) {
                n = 8;
            }
            if ((t = Integer.highestOneBit(args.checkInteger(1) - 1) << 1) <= 1 || t * n > MAX_BUFFER) {
                throw new Exception("buffer size out of range 2*inputs..." + MAX_BUFFER);
            }
            this.nIN = n;
            this.tIN = t - 1;
            this.bufIN = new int[n * t];
        }
        return null;
    }

    @Optional.Method(modid="opencomputers")
    @Callback(direct=false, doc="function(inputs:number, ticks:number) -- configures the first given number of outputs to be buffered over given number of ticks to support tick precise writing.")
    public Object[] bufferOutput(Context context, Arguments args) throws Exception {
        int n = args.checkInteger(0);
        if (n <= 0) {
            this.nOUT = 0;
            this.tOUT = 0;
            this.bufOUT = null;
        } else {
            int t;
            if (n > 8) {
                n = 8;
            }
            if ((t = Integer.highestOneBit(args.checkInteger(1) - 1) << 1) <= 1 || t * n > MAX_BUFFER) {
                throw new Exception("buffer size out of range 2*inputs..." + MAX_BUFFER);
            }
            this.nOUT = n;
            this.tOUT = t - 1;
            this.bufOUT = new int[n * t];
            this.changes = 0L;
        }
        return null;
    }

    private void setOut(int i, int v) {
        if (i < 0 || i >= 8 || this.state[i] == v) {
            return;
        }
        this.state[i] = v;
        if (this.update == 0) {
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
        }
        this.update |= 1 << i;
    }

    @Optional.Method(modid="opencomputers")
    public int changeEnergy(int dE, boolean sim) {
        if (!(this.node instanceof Connector)) {
            return 0;
        }
        Connector c = (Connector)this.node;
        double d = (double)dE / OC_UNIT;
        if (!sim) {
            return (int)Math.rint((d - c.changeBuffer(d)) * OC_UNIT);
        }
        d += c.globalBuffer();
        if (dE > 0) {
            if ((d -= c.globalBufferSize()) <= 0.0) {
                return dE;
            }
            return dE - (int)Math.ceil(d * OC_UNIT);
        }
        if (d >= 0.0) {
            return dE;
        }
        return dE - (int)Math.floor(d * OC_UNIT);
    }

    @Optional.Method(modid="opencomputers")
    public static void registerAPI() {
        Driver.add(stack -> stack.func_77973_b() == Objects.oc_adapter ? OC_Adapter.class : null);
    }

    @Override
    public Object getState(int id) {
        return id < this.state.length ? Integer.valueOf(this.state[id]) : null;
    }
}

