/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.gui.BlockButton;
import cd4017be.rs_ctr.tileentity.SignalCombiner;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class LogicCombiner
extends SignalCombiner {
    byte[] inModes = new byte[4];
    int outInv;
    BlockButton[] buttons = new BlockButton[5];

    public LogicCombiner() {
        for (int i = 0; i < 4; ++i) {
            int pin = i;
            this.buttons[i] = new BlockButton(a -> {
                this.inModes[pin] = (byte)(this.inModes[pin] + ((a & 2) != 0 ? -1 : 1) & 3);
                this.refreshInput(pin);
                this.markDirty(3);
            }, () -> "_buttons.logic(" + this.inModes[pin] + ")", () -> TooltipUtil.translate((String)("port.rs_ctr.logic" + this.inModes[pin]))).setSize(0.0625f, 0.0625f);
        }
        this.buttons[4] = new BlockButton(a -> {
            this.outInv ^= 0xFFFF;
            this.scheduleUpdate();
            this.markDirty(3);
        }, () -> "_buttons.logic(" + (this.outInv != 0 ? 3 : 2) + ")", () -> TooltipUtil.translate((String)("port.rs_ctr.logic" + (this.outInv != 0 ? 5 : 4)))).setSize(0.0625f, 0.0625f);
    }

    @Override
    protected int computeResult() {
        return (this.inputs[0] | this.inputs[1] | this.inputs[2] | this.inputs[3]) ^ this.outInv;
    }

    @Override
    public SignalHandler getPortCallback(int pin) {
        switch (this.inModes[pin]) {
            case 0: {
                return val -> this.setInput(pin, val > 0 ? 65535 : 0);
            }
            case 1: {
                return val -> this.setInput(pin, val <= 0 ? 65535 : 0);
            }
            case 2: {
                return val -> this.setInput(pin, val & 0xFFFF);
            }
        }
        return val -> this.setInput(pin, ~val & 0xFFFF);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        nbt.func_74777_a("mode", (short)(this.inModes[0] | this.inModes[1] << 2 | this.inModes[2] << 4 | this.inModes[3] << 6 | this.outInv & 0x100));
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        short m = nbt.func_74765_d("mode");
        for (int i = 0; i < this.inModes.length; ++i) {
            this.inModes[i] = (byte)(m >> i * 2 & 3);
        }
        this.outInv = (m & 0x100) != 0 ? 65535 : 0;
        super.loadState(nbt, mode);
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        Collections.addAll(list, this.buttons);
    }

    @Override
    protected void orient(Orientation o) {
        for (int i = 0; i < 4; ++i) {
            this.buttons[i].setLocation(0.375, 0.125f + (float)i * 0.25f, 0.25, o);
        }
        this.buttons[4].setLocation(0.625, 0.5, 0.25, o);
        super.orient(o);
    }

    @Override
    public Object getState(int id) {
        if (id < 4 && (this.inModes[id] & 1) != 0) {
            return this.inputs[id] ^ 0xFFFF;
        }
        return super.getState(id);
    }
}

