/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemTranslocator
extends WallMountGate
implements BaseTileEntity.ITickableServerOnly {
    public static int BASE_COST = -100;
    public static int TRANSFER_COST = -400;
    BlockReference ref0;
    BlockReference ref1;
    EnergyHandler energy = EnergyHandler.NOP;
    SignalHandler out;
    int slot0;
    int slot1;
    int amIn;
    int amOut;
    int clk;
    boolean update;

    public ItemTranslocator() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, BlockReference.BlockHandler.class, false).setLocation(0.875, 0.625, 0.25, EnumFacing.NORTH).setName("port.rs_ctr.inv0"), new MountedPort((IPortProvider)this, 1, BlockReference.BlockHandler.class, false).setLocation(0.125, 0.625, 0.25, EnumFacing.NORTH).setName("port.rs_ctr.inv1"), new MountedPort((IPortProvider)this, 2, EnergyHandler.class, true).setLocation(0.375, 0.25, 0.125, EnumFacing.UP).setName("port.rs_ctr.energy_i"), new MountedPort((IPortProvider)this, 3, SignalHandler.class, false).setLocation(0.875, 0.875, 0.25, EnumFacing.NORTH).setName("port.rs_ctr.slot0"), new MountedPort((IPortProvider)this, 4, SignalHandler.class, false).setLocation(0.125, 0.875, 0.25, EnumFacing.NORTH).setName("port.rs_ctr.slot1"), new MountedPort((IPortProvider)this, 5, SignalHandler.class, false).setLocation(0.625, 0.25, 0.125, EnumFacing.UP).setName("port.rs_ctr.clk"), new MountedPort((IPortProvider)this, 6, SignalHandler.class, false).setLocation(0.875, 0.25, 0.125, EnumFacing.UP).setName("port.rs_ctr.am_i"), new MountedPort((IPortProvider)this, 7, SignalHandler.class, true).setLocation(0.125, 0.25, 0.125, EnumFacing.UP).setName("port.rs_ctr.am_o")};
    }

    public Object getPortCallback(int pin) {
        switch (pin) {
            case 0: {
                return ref -> {
                    this.ref0 = ref;
                };
            }
            case 1: {
                return ref -> {
                    this.ref1 = ref;
                };
            }
            case 3: {
                return val -> {
                    this.slot0 = val;
                };
            }
            case 4: {
                return val -> {
                    this.slot1 = val;
                };
            }
            case 5: {
                return val -> {
                    if (val == this.clk) {
                        return;
                    }
                    this.clk = val;
                    this.update = true;
                };
            }
            case 6: {
                return val -> {
                    this.amIn = val;
                };
            }
        }
        return null;
    }

    public void setPortCallback(int pin, Object callback) {
        switch (pin) {
            case 2: {
                this.energy = callback instanceof EnergyHandler ? (EnergyHandler)callback : EnergyHandler.NOP;
                break;
            }
            case 7: {
                if (callback instanceof SignalHandler) {
                    this.out = (SignalHandler)callback;
                    this.out.updateSignal(this.amOut);
                    break;
                }
                this.out = null;
            }
        }
    }

    @Override
    protected void resetPin(int pin) {
        switch (pin) {
            case 0: {
                this.ref0 = null;
                break;
            }
            case 1: {
                this.ref1 = null;
                break;
            }
            case 3: {
                this.slot0 = 0;
                break;
            }
            case 4: {
                this.slot1 = 0;
                break;
            }
            case 5: {
                this.clk = 0;
                break;
            }
            case 6: {
                this.amIn = 0;
            }
        }
    }

    public void func_73660_a() {
        if (!this.update) {
            return;
        }
        this.update = false;
        int n = this.transfer(this.amIn);
        if (this.amOut != n) {
            this.amOut = n;
            if (this.out != null) {
                this.out.updateSignal(n);
            }
        }
    }

    private int transfer(int am) {
        if (am == 0 || this.ref0 == null || this.ref1 == null || !this.ref0.isLoaded() || !this.ref1.isLoaded()) {
            return 0;
        }
        int e = ItemTranslocator.cost(am);
        if (this.energy.changeEnergy(e, true) != e) {
            return 0;
        }
        IItemHandler inv0 = (IItemHandler)this.ref0.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        IItemHandler inv1 = (IItemHandler)this.ref1.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        am = am > 0 ? this.transfer(am, inv0, this.slot0, inv1, this.slot1) : -this.transfer(-am, inv1, this.slot1, inv0, this.slot0);
        this.energy.changeEnergy(ItemTranslocator.cost(am), false);
        return am;
    }

    private static int cost(int am) {
        if (am < 0) {
            am = -am;
        }
        return (int)Math.min((long)am * (long)TRANSFER_COST / 64L + (long)BASE_COST, Integer.MAX_VALUE);
    }

    private int transfer(int am, IItemHandler fromInv, int fromSlot, IItemHandler toInv, int toSlot) {
        if (fromInv == null || toInv == null || fromSlot >= fromInv.getSlots() || toSlot >= toInv.getSlots() || fromSlot < 0 && toSlot < 0) {
            return 0;
        }
        if (fromSlot < 0) {
            int n = am;
            ItemStack stack = ItemFluidUtil.drain((IItemHandler)fromInv, s -> n - toInv.insertItem(toSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)s, (int)n), true).func_190916_E());
            if ((am = stack.func_190916_E()) > 0) {
                toInv.insertItem(toSlot, stack, false);
            }
        } else {
            ItemStack stack = fromInv.extractItem(fromSlot, am, true);
            if ((am = stack.func_190916_E()) > 0 && (am -= (toSlot >= 0 ? toInv.insertItem(toSlot, stack, false) : ItemHandlerHelper.insertItemStacked((IItemHandler)toInv, (ItemStack)stack, (boolean)false)).func_190916_E()) > 0) {
                fromInv.extractItem(fromSlot, am, false);
            }
        }
        return am;
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            nbt.func_74757_a("update", this.update);
            nbt.func_74768_a("in", this.amIn);
            nbt.func_74768_a("out", this.amOut);
            nbt.func_74768_a("clk", this.clk);
            nbt.func_74768_a("slot0", this.slot0);
            nbt.func_74768_a("slot1", this.slot1);
            if (this.ref0 != null) {
                nbt.func_74782_a("inv0", (NBTBase)this.ref0.serializeNBT());
            } else {
                nbt.func_82580_o("inv0");
            }
            if (this.ref1 != null) {
                nbt.func_74782_a("inv1", (NBTBase)this.ref1.serializeNBT());
            } else {
                nbt.func_82580_o("inv1");
            }
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            this.update = nbt.func_74767_n("update");
            this.amIn = nbt.func_74762_e("in");
            this.amOut = nbt.func_74762_e("out");
            this.clk = nbt.func_74762_e("clk");
            this.slot0 = nbt.func_74762_e("slot0");
            this.slot1 = nbt.func_74762_e("slot1");
            this.ref0 = nbt.func_150297_b("inv0", 10) ? new BlockReference(nbt.func_74775_l("inv0")) : null;
            this.ref1 = nbt.func_150297_b("inv1", 10) ? new BlockReference(nbt.func_74775_l("inv1")) : null;
        }
        super.loadState(nbt, mode);
    }

    @Override
    public Object getState(int id) {
        switch (id) {
            case 0: {
                return this.ref0;
            }
            case 1: {
                return this.ref1;
            }
            case 3: {
                return this.slot0;
            }
            case 4: {
                return this.slot1;
            }
            case 5: {
                return this.clk;
            }
            case 6: {
                return this.amIn;
            }
            case 7: {
                return this.amOut;
            }
        }
        return null;
    }
}

