/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.HidableSlot;
import cd4017be.lib.Gui.SlotArmor;
import cd4017be.lib.Gui.SlotOffhand;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.capability.LinkedInventory;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.SaferFakePlayer;
import cd4017be.rs_ctr.gui.GuiItemPlacer;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import cd4017be.rs_ctr.util.FullHotbarInventory;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;

public class ItemPlacer
extends WallMountGate
implements BaseTileEntity.ITickableServerOnly,
SignalHandler,
BlockReference.BlockHandler,
AdvancedBlock.ITilePlaceHarvest,
IGuiHandlerTile,
AdvancedContainer.IStateInteractionHandler,
AdvancedContainer.IQuickTransferHandler {
    public static float BASE_ENERGY = 500.0f;
    public static float SPEED_MOD = 8.0f;
    private static final int S_SUCCESS = 0;
    private static final int S_PASS = -1;
    private static final int S_FAIL = 1;
    private static final int S_NOENERGY = 2;
    private GameProfile gp = new GameProfile(new UUID(0L, 0L), "dummyPlayer");
    private FakePlayer player;
    private InventoryPlayer inv = new FullHotbarInventory(null);
    private IItemHandler mainhand = new LinkedInventory(1, 64, i -> (ItemStack)this.inv.field_70462_a.get(this.inv.field_70461_c), (stack, i) -> {
        ItemStack cfr_ignored_0 = (ItemStack)this.inv.field_70462_a.set(this.inv.field_70461_c, stack);
    });
    private IItemHandler offhand = new LinkedInventory(1, 64, i -> (ItemStack)this.inv.field_184439_c.get(0), (stack, i) -> {
        ItemStack cfr_ignored_0 = (ItemStack)this.inv.field_184439_c.set(0, stack);
    });
    private IItemHandler maininv;
    private IItemHandler armorinv;
    public boolean creative;
    private BlockReference block;
    private EnergyHandler energy;
    private SignalHandler out;
    private int clk;
    private int status;
    private int idle;
    public int aim;
    private boolean update;
    private static final StateSynchronizer.Builder ssb = StateSynchronizer.builder().addFix(new int[]{4});

    public ItemPlacer() {
        this.maininv = new LinkedInventory(this.inv.field_70462_a.size(), 64, arg_0 -> ((NonNullList)this.inv.field_70462_a).get(arg_0), (stack, i) -> {
            ItemStack cfr_ignored_0 = (ItemStack)this.inv.field_70462_a.set(i, stack);
        });
        this.armorinv = new PlayerArmorInvWrapper(this.inv);
        this.energy = EnergyHandler.NOP;
        this.idle = 1000;
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.bi").setLocation(0.75, 0.625, 0.875, EnumFacing.EAST), new MountedPort((IPortProvider)this, 1, SignalHandler.class, false).setName("port.rs_ctr.place").setLocation(0.875, 0.25, 0.875, EnumFacing.UP), new MountedPort((IPortProvider)this, 2, SignalHandler.class, false).setName("port.rs_ctr.clk").setLocation(0.875, 0.25, 0.625, EnumFacing.UP), new MountedPort((IPortProvider)this, 3, SignalHandler.class, true).setName("port.rs_ctr.status").setLocation(0.875, 0.25, 0.125, EnumFacing.UP), new MountedPort((IPortProvider)this, 4, EnergyHandler.class, true).setName("port.rs_ctr.energy_i").setLocation(0.875, 0.25, 0.375, EnumFacing.UP)};
    }

    public Object getPortCallback(int pin) {
        return pin == 1 ? this::updateAim : this;
    }

    public void setPortCallback(int pin, Object callback) {
        if (pin == 3) {
            SignalHandler signalHandler = this.out = callback instanceof SignalHandler ? (SignalHandler)callback : null;
            if (this.out != null) {
                this.out.updateSignal(this.status);
            }
        } else {
            this.energy = callback instanceof EnergyHandler ? (EnergyHandler)callback : EnergyHandler.NOP;
        }
    }

    @Override
    protected void resetPin(int pin) {
        if (pin == 0) {
            this.block = null;
        } else if (pin == 1) {
            this.updateAim(0);
        }
    }

    public void updateBlock(BlockReference ref) {
        this.block = ref;
    }

    public void updateSignal(int value) {
        if (value == this.clk) {
            return;
        }
        this.clk = value;
        this.update = true;
    }

    public void updateAim(int value) {
        if ((value &= this.creative ? 0xFFDFBF : 0xFFDF3F) == this.aim) {
            return;
        }
        this.aim = value;
        this.inv.field_70461_c = this.aim & 0x3F;
        if (this.inv.field_70461_c >= 36) {
            this.inv.field_70461_c = 0;
        }
        this.markDirty(0);
    }

    public void func_73660_a() {
        ++this.idle;
        if (!this.update) {
            return;
        }
        this.update = false;
        int status = this.block != null && this.block.isLoaded() ? this.placeBlock(this.block) : -1;
        if (status != this.status) {
            this.status = status;
            if (this.out != null) {
                this.out.updateSignal(status);
            }
        }
        if (status != 2) {
            this.idle = 0;
        }
    }

    private void initializePlayer() {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        this.player = new SaferFakePlayer((WorldServer)this.field_145850_b, this.gp);
        this.player.field_71075_bZ.field_75101_c = true;
        this.player.field_71075_bZ.field_75102_a = true;
        this.player.field_71075_bZ.field_75100_b = true;
        this.player.field_71071_by = this.inv;
        this.inv.field_70458_d = this.player;
    }

    private int placeBlock(BlockReference ref) {
        int e = this.energyCost();
        if (this.energy.changeEnergy(e, true) != e) {
            return 2;
        }
        if (this.player == null) {
            this.initializePlayer();
        }
        if ((this.aim & 0x4000) != 0 && !ref.getState().func_177230_c().func_176200_f((IBlockAccess)ref.world(), ref.pos)) {
            return 1;
        }
        RayTraceResult res = ItemPlacer.setupInteraction(this.player, ref, this.aim);
        EnumActionResult ar = null;
        boolean useItem = false;
        if ((this.aim & 0x8000) != 0) {
            ItemStack stack = this.player.func_184614_ca();
            if (stack.func_190926_b()) {
                ar = EnumActionResult.PASS;
            } else {
                ar = this.player.field_71134_c.func_187250_a((EntityPlayer)this.player, this.player.field_70170_p, stack, EnumHand.MAIN_HAND);
                useItem = true;
            }
        } else {
            BlockPos pos = res.func_178782_a();
            float X = (float)res.field_72307_f.field_72450_a - (float)pos.func_177958_n();
            float Y = (float)res.field_72307_f.field_72448_b - (float)pos.func_177956_o();
            float Z = (float)res.field_72307_f.field_72449_c - (float)pos.func_177952_p();
            for (EnumHand hand : EnumHand.values()) {
                ItemStack stack = this.player.func_184586_b(hand);
                if (ar != null && stack.func_190926_b()) break;
                useItem |= !stack.func_190926_b();
                ar = this.player.field_71134_c.func_187251_a((EntityPlayer)this.player, this.player.field_70170_p, stack, hand, pos, res.field_178784_b, X, Y, Z);
                if (ar != EnumActionResult.PASS) break;
            }
        }
        this.energy.changeEnergy(useItem ? e : -((int)BASE_ENERGY), false);
        return ar == EnumActionResult.SUCCESS ? 0 : (ar == EnumActionResult.FAIL ? 1 : -1);
    }

    private int energyCost() {
        float h = BASE_ENERGY;
        h += h * SPEED_MOD / (float)this.idle;
        return -((int)h);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            nbt.func_74768_a("clk", this.clk);
            nbt.func_74774_a("out", (byte)this.status);
            nbt.func_74768_a("aim", this.aim);
            nbt.func_74768_a("t", this.idle);
            nbt.func_74757_a("update", this.update);
            if (this.block != null) {
                nbt.func_74782_a("ref", (NBTBase)this.block.serializeNBT());
            } else {
                nbt.func_82580_o("ref");
            }
            nbt.func_186854_a("FPuuid", this.gp.getId());
            nbt.func_74778_a("FPname", this.gp.getName());
            nbt.func_74782_a("FPinv", (NBTBase)this.inv.func_70442_a(new NBTTagList()));
        }
        if (mode <= 1) {
            nbt.func_74757_a("creative", this.creative);
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            this.clk = nbt.func_74762_e("clk");
            this.status = nbt.func_74771_c("out");
            this.aim = nbt.func_74762_e("aim");
            this.idle = nbt.func_74762_e("t");
            this.block = nbt.func_150297_b("ref", 10) ? new BlockReference(nbt.func_74775_l("ref")) : null;
            this.gp = new GameProfile(nbt.func_186857_a("FPuuid"), nbt.func_74779_i("FPname"));
            this.inv.func_70443_b(nbt.func_150295_c("FPinv", 10));
            this.inv.field_70461_c = this.aim & 0x3F;
            if (this.inv.field_70461_c >= 36) {
                this.inv.field_70461_c = 0;
            }
        }
        if (mode <= 1) {
            this.creative = nbt.func_74767_n("creative");
        }
        super.loadState(nbt, mode);
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return null;
        }
        if (this.player == null) {
            this.initializePlayer();
        }
        Orientation o = this.getOrientation();
        if (facing == o.front) {
            return (T)this.mainhand;
        }
        if (facing == o.back) {
            return (T)this.offhand;
        }
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return (T)this.maininv;
        }
        return (T)this.armorinv;
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.gp = player.func_146103_bH();
            this.creative = player.func_184812_l_();
        }
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        return this.makeDefaultDrops();
    }

    private static RayTraceResult setupInteraction(FakePlayer player, BlockReference block, int aim) {
        player.func_70095_a((aim & 0x1000) != 0);
        player.field_71075_bZ.field_75098_d = (aim & 0x80) != 0;
        boolean air = (aim & 0x8000) != 0;
        boolean noBlock = (aim & 0x4000) != 0;
        Vec3d vec = new Vec3d(0.46875 - (double)(aim >> 16 & 0xF) * 0.0625, (double)(aim >> 20 & 0xF) * 0.0625 - 0.46875, air ? 0.0 : -2.0);
        aim >>= 8;
        switch (block.face) {
            case WEST: {
                aim = aim + 3 & 3 | aim & 0xC;
                break;
            }
            case SOUTH: {
                aim = aim & 0xF ^ 2;
                break;
            }
            case EAST: {
                aim = aim + 1 & 3 | aim & 0xC;
                break;
            }
            default: {
                aim &= 0xF;
            }
        }
        Orientation o = Orientation.values()[aim];
        BlockPos pos = block.pos;
        vec = o.rotate(vec).func_72441_c((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        player.field_71093_bK = block.dim;
        player.field_70170_p = block.world();
        player.func_70012_b(vec.field_72450_a, vec.field_72448_b - (double)player.func_70047_e(), vec.field_72449_c, (float)((aim & 3) * 90), (float)((((aim >> 2) + 1 & 3) - 1) * -90));
        player.field_70758_at = player.field_70759_as = player.field_70177_z;
        Vec3d dir = vec.func_72441_c((double)o.back.func_82601_c() * 3.5, (double)o.back.func_96559_d() * 3.5, (double)o.back.func_82599_e() * 3.5);
        if (air) {
            return null;
        }
        RayTraceResult res = null;
        if (noBlock) {
            BlockPos pos1 = pos.func_177972_a(o.back);
            IBlockState state = player.field_70170_p.func_180495_p(pos1);
            if (!state.func_177230_c().func_176200_f((IBlockAccess)player.field_70170_p, pos1)) {
                res = state.func_185910_a(player.field_70170_p, pos1, vec, dir);
            }
        } else {
            res = block.getState().func_185910_a(player.field_70170_p, pos, vec, dir);
        }
        if (res != null) {
            return res;
        }
        return new RayTraceResult(dir, o.front, pos);
    }

    public AdvancedContainer getContainer(EntityPlayer player, int id) {
        int i;
        AdvancedContainer cont = new AdvancedContainer((AdvancedContainer.IStateInteractionHandler)this, ssb.build(this.field_145850_b.field_72995_K), player);
        int x = 26;
        int y = 26;
        for (i = 0; i < 9; ++i) {
            cont.addItemSlot((Slot)new HidableSlot((IInventory)this.inv, i, x + i * 18, y + 58), false);
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                cont.addItemSlot((Slot)new HidableSlot((IInventory)this.inv, i * 9 + j + 9, x + j * 18, y + i * 18), false);
            }
        }
        for (i = 0; i < 4; ++i) {
            cont.addItemSlot((Slot)new SlotArmor(this.inv, i + 36, x - 18, y - i * 18 + 36, EntityEquipmentSlot.values()[i + 2]), false);
        }
        cont.addItemSlot((Slot)new SlotOffhand((IInventory)this.inv, 40, x - 18, y + 58), false);
        cont.addPlayerInventory(26, 124, true, false);
        cont.transferHandlers.add(this);
        return cont;
    }

    public boolean transfer(ItemStack stack, AdvancedContainer cont) {
        return cont.func_75135_a(stack, 36, 40, false) || cont.func_75135_a(stack, 0, 36, false);
    }

    public void writeState(StateSyncServer state, AdvancedContainer cont) {
        state.putAll(new Object[]{this.aim}).endFixed();
    }

    public void readState(StateSyncClient state, AdvancedContainer cont) {
        this.aim = state.get(this.aim);
    }

    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        return this.canPlayerAccessUI(player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiItemPlacer getGuiScreen(EntityPlayer player, int id) {
        return new GuiItemPlacer(this, player);
    }

    @Override
    public Object getState(int id) {
        switch (id) {
            case 0: {
                return this.block;
            }
            case 1: {
                return this.aim;
            }
            case 2: {
                return this.clk;
            }
            case 3: {
                return this.status;
            }
        }
        return null;
    }
}

