/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.interact.IInteractiveDevice;
import cd4017be.api.rs_ctr.port.IStateInfo;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.IHookAttachable;
import cd4017be.api.rs_ctr.wire.RelayPort;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.render.HybridFastTESR;
import cd4017be.lib.templates.Cover;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.render.ISpecialRenderComp;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;

public abstract class Gate
extends BaseTileEntity
implements IHookAttachable,
AdvancedBlock.IInteractiveTile,
AdvancedBlock.ISelfAwareTile,
IInteractiveDevice,
AdvancedBlock.ICoverableTile,
IStateInfo {
    protected MountedPort[] ports;
    protected IInteractiveComponent[] gui;
    protected Int2ObjectOpenHashMap<RelayPort> hooks = new Int2ObjectOpenHashMap();
    protected Orientation o = Orientation.N;
    public Cover cover = new Cover();
    protected ArrayList<IInteractiveComponent.ITESRenderComp> tesrComps = null;
    protected AxisAlignedBB tesrBB = null;

    public Port getPort(int pin) {
        Port port = (Port)this.hooks.get(pin);
        if (port != null) {
            return port;
        }
        if (pin < this.ports.length) {
            port = this.ports[pin];
            if (port.pin == pin) {
                return port;
            }
        }
        return null;
    }

    public Orientation getOrientation() {
        return this.o;
    }

    public Int2ObjectMap<RelayPort> getHookPins() {
        return this.hooks;
    }

    public IInteractiveComponent[] getComponents() {
        if (this.gui == null) {
            ArrayList<IInteractiveComponent> list = new ArrayList<IInteractiveComponent>();
            Collections.addAll(list, this.ports);
            for (RelayPort port : this.hooks.values()) {
                if (!port.isMaster) continue;
                list.add((IInteractiveComponent)port);
            }
            this.initGuiComps(list);
            this.gui = list.toArray(new IInteractiveComponent[list.size()]);
        }
        return this.gui;
    }

    protected void initGuiComps(List<IInteractiveComponent> list) {
    }

    protected abstract void resetPin(int var1);

    public void onPortModified(Port port, int event) {
        int mode;
        if (event == 2 && !port.isMaster && port.pin < 32768) {
            this.resetPin(port.pin);
        }
        if ((event & 0x300) != 0) {
            if (this.unloaded) {
                return;
            }
            this.gui = null;
            mode = 3;
        } else {
            mode = (event & 0x18) == 24 || (event & 0x10) != 0 && ((MountedPort)port).getConnector() instanceof IInteractiveComponent.IBlockRenderComp ? 3 : 2;
        }
        this.markDirty(mode);
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        if (this.cover.interact((BaseTileEntity)this, player, hand, item, s, X, Y, Z)) {
            return true;
        }
        Triple r = this.rayTrace((Entity)player, 1.0f);
        return r != null && (this.field_145850_b.field_72995_K || ((IInteractiveComponent)r.getLeft()).onInteract(player, false, (EnumFacing)r.getRight(), (Vec3d)r.getMiddle()));
    }

    public void onClicked(EntityPlayer player) {
        if (this.cover.hit((BaseTileEntity)this, player) || this.field_145850_b.field_72995_K) {
            return;
        }
        Triple r = this.rayTrace((Entity)player, 1.0f);
        if (r != null) {
            ((IInteractiveComponent)r.getLeft()).onInteract(player, true, (EnumFacing)r.getRight(), (Vec3d)r.getMiddle());
        }
    }

    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode <= 2) {
            NBTTagCompound ctag;
            NBTTagList list = new NBTTagList();
            for (MountedPort port : this.ports) {
                list.func_74742_a((NBTBase)port.serializeNBT());
            }
            if (!list.func_82582_d()) {
                nbt.func_74782_a("ports", (NBTBase)list);
            }
            if ((ctag = this.storeHooks()) != null) {
                nbt.func_74782_a("hooks", (NBTBase)ctag);
            }
        }
        this.cover.writeNBT(nbt, "cover", mode == 2);
    }

    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode <= 2) {
            NBTTagList list = nbt.func_150295_c("ports", 10);
            for (int i = 0; i < this.ports.length; ++i) {
                this.ports[i].deserializeNBT(list.func_150305_b(i));
            }
            this.loadHooks(nbt.func_74775_l("hooks"));
        }
        this.cover.readNBT(nbt, "cover", (TileEntity)(mode == 2 ? this : null));
        this.tesrComps = null;
        this.tesrBB = null;
        this.gui = null;
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (MountedPort port : this.ports) {
            port.onLoad();
        }
        for (MountedPort port : this.hooks.values()) {
            port.onLoad();
        }
    }

    protected void onUnload() {
        super.onUnload();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (MountedPort port : this.ports) {
            port.onUnload();
        }
        for (MountedPort port : this.hooks.values()) {
            port.onUnload();
        }
    }

    public void breakBlock() {
        for (MountedPort port : this.ports) {
            port.setConnector(null, null);
        }
        this.unloaded = true;
        for (MountedPort pin : (ObjectIterator)this.hooks.keySet().toIntArray()) {
            this.removeHook((int)pin, null);
        }
        if (this.cover.stack != null) {
            ItemFluidUtil.dropStack((ItemStack)this.cover.stack, (World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
        if (!this.field_145850_b.field_72995_K) {
            for (MountedPort port : this.ports) {
                port.disconnect();
            }
            for (MountedPort port : this.hooks.values()) {
                port.disconnect();
            }
        }
    }

    public ArrayList<IInteractiveComponent.IBlockRenderComp> getBMRComponents() {
        ArrayList<IInteractiveComponent.IBlockRenderComp> res = new ArrayList<IInteractiveComponent.IBlockRenderComp>();
        for (IInteractiveComponent c : this.getComponents()) {
            if (c instanceof IInteractiveComponent.IBlockRenderComp) {
                res.add((IInteractiveComponent.IBlockRenderComp)c);
            }
            if (!(c instanceof MountedPort)) continue;
            ((MountedPort)c).addRenderComps(res, IInteractiveComponent.IBlockRenderComp.class);
        }
        return res;
    }

    public <T> T getModuleState(int m) {
        return (T)(m == 0 ? this.getBMRComponents() : this.cover.module());
    }

    public boolean isModulePresent(int m) {
        return m != 0 && super.isModulePresent(m);
    }

    public Cover getCover() {
        return this.cover;
    }

    public ArrayList<IInteractiveComponent.ITESRenderComp> getTESRComponents() {
        if (this.tesrComps == null) {
            this.tesrComps = new ArrayList();
            if (this instanceof IInteractiveComponent.ITESRenderComp) {
                this.tesrComps.add((IInteractiveComponent.ITESRenderComp)this);
            }
            for (IInteractiveComponent c : this.getComponents()) {
                if (c instanceof IInteractiveComponent.ITESRenderComp) {
                    this.tesrComps.add((IInteractiveComponent.ITESRenderComp)c);
                }
                if (!(c instanceof MountedPort)) continue;
                ((MountedPort)c).addRenderComps(this.tesrComps, IInteractiveComponent.ITESRenderComp.class);
            }
        }
        return this.tesrComps;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.tesrBB == null) {
            this.tesrBB = super.getRenderBoundingBox();
            for (IInteractiveComponent.ITESRenderComp c : this.getTESRComponents()) {
                AxisAlignedBB bb = c.getRenderBB(this.field_145850_b, this.field_174879_c);
                if (bb == null) continue;
                this.tesrBB = this.tesrBB.func_111270_a(bb);
            }
        }
        return this.tesrBB;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return !(this instanceof ISpecialRenderComp) && !HybridFastTESR.isAimedAt((TileEntity)this);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.orient(super.getOrientation());
        for (RelayPort port : this.hooks.values()) {
            port.orient(this.o);
        }
        this.gui = null;
    }

    protected void orient(Orientation o) {
        if (o == this.o) {
            return;
        }
        for (MountedPort port : this.ports) {
            Vec3d pos = o.rotate(this.o.invRotate(port.pos.func_72441_c(-0.5, -0.5, -0.5)));
            EnumFacing side = o.rotate(this.o.invRotate(port.face));
            port.setLocation(pos.field_72450_a + 0.5, pos.field_72448_b + 0.5, pos.field_72449_c + 0.5, side);
        }
        this.o = o;
    }

    @Override
    public Port[] availablePorts() {
        return this.ports;
    }
}

