/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyValve
extends WallMountGate
implements IEnergyStorage,
SignalHandler {
    public static final IEnergyStorage NULL_RECEIVE = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int getMaxEnergyStored() {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public boolean canReceive() {
            return false;
        }

        public boolean canExtract() {
            return true;
        }
    };
    SignalHandler flowOut;
    IEnergyStorage out;
    int amIn;
    int flow;
    int limit;
    int amOut;
    int clk;
    boolean update = true;

    public EnergyValve() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, SignalHandler.class, false).setName("port.rs_ctr.clk").setLocation(0.25, 0.625, 0.5, EnumFacing.WEST), new MountedPort((IPortProvider)this, 1, SignalHandler.class, false).setName("port.rs_ctr.rf_i").setLocation(0.25, 0.375, 0.375, EnumFacing.WEST), new MountedPort((IPortProvider)this, 2, SignalHandler.class, true).setName("port.rs_ctr.rf_o").setLocation(0.25, 0.375, 0.625, EnumFacing.WEST)};
    }

    public Object getPortCallback(int pin) {
        return pin == 0 ? this : v -> {
            this.amIn = v;
        };
    }

    public void setPortCallback(int pin, Object callback) {
        SignalHandler signalHandler = this.flowOut = callback instanceof SignalHandler ? (SignalHandler)callback : null;
        if (this.flowOut != null) {
            this.flowOut.updateSignal(this.amOut);
        }
    }

    @Override
    protected void resetPin(int pin) {
        if (pin == 1) {
            this.amIn = 0;
        }
    }

    public void updateSignal(int value) {
        if (value == this.clk) {
            return;
        }
        this.clk = value;
        this.update = true;
        if (this.flow != this.amOut && this.flowOut != null) {
            this.flowOut.updateSignal(this.flow);
        }
        this.amOut = this.flow;
        this.flow = 0;
        this.markDirty(0);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        if (mode == 0) {
            nbt.func_74768_a("amIn", this.amIn);
            nbt.func_74768_a("flow", this.flow);
            nbt.func_74768_a("amOut", this.amOut);
            nbt.func_74768_a("clk", this.clk);
            nbt.func_74757_a("update", this.update);
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 0) {
            this.limit = this.amIn = nbt.func_74762_e("amIn");
            this.flow = nbt.func_74762_e("flow");
            this.amOut = nbt.func_74762_e("amOut");
            this.clk = nbt.func_74762_e("clk");
            this.update = nbt.func_74767_n("update");
        }
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        EnumFacing front = this.getOrientation().front;
        return cap == CapabilityEnergy.ENERGY && (facing == front || facing == front.func_176734_d());
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            EnumFacing front = this.getOrientation().front;
            if (facing == front) {
                this.out = (IEnergyStorage)Utils.neighborCapability((TileEntity)this, (EnumFacing)front.func_176734_d(), (Capability)CapabilityEnergy.ENERGY);
                return (T)this;
            }
            if (facing == front.func_176734_d()) {
                return (T)NULL_RECEIVE;
            }
        }
        return null;
    }

    public int receiveEnergy(int am, boolean sim) {
        if (this.update) {
            this.update = false;
            this.limit = this.amIn;
            this.markDirty(0);
        }
        if ((am = Math.min(am, this.limit - this.flow)) > 0 && this.out != null) {
            am = this.out.receiveEnergy(am, sim);
            if (!sim) {
                this.flow += am;
            }
            return am;
        }
        return 0;
    }

    public int extractEnergy(int am, boolean sim) {
        return 0;
    }

    public int getEnergyStored() {
        return this.flow;
    }

    public int getMaxEnergyStored() {
        return this.limit;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public Object getState(int id) {
        return id == 0 ? this.clk : (id == 1 ? this.amIn : this.amOut);
    }
}

