/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.frame.IFrameOperator;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.render.HybridFastTESR;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.IChunkLoader;
import cd4017be.rs_ctr.Main;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.gui.BlockButton;
import cd4017be.rs_ctr.item.ItemChunkLoaderFuel;
import cd4017be.rs_ctr.render.FrameRenderer;
import cd4017be.rs_ctr.render.ISpecialRenderComp;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChunkLoader
extends WallMountGate
implements IFrameOperator,
SignalHandler,
IntConsumer,
Supplier<String>,
ISpecialRenderComp,
IInteractiveComponent.ITESRenderComp,
IChunkLoader,
BaseTileEntity.ITickableServerOnly {
    public static int RANGE = 64;
    public static int MAX_CHUNKS;
    public static int MAX_MINUTES;
    BlockButton button = new BlockButton(this, () -> null, this).setSize(0.5f, 0.25f);
    SignalHandler out = SignalHandler.NOP;
    int minutes;
    public int[] area = new int[]{0, -1, 0, -1, 1, -1};
    public byte missingFrames = (byte)-1;
    public byte mode;
    boolean showFrame = true;
    ForgeChunkManager.Ticket ticket;
    String owner = "";

    public ChunkLoader() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, SignalHandler.class, false).setName("port.rs_ctr.load").setLocation(0.875, 0.125, 0.0, EnumFacing.NORTH), new MountedPort((IPortProvider)this, 1, SignalHandler.class, true).setName("port.rs_ctr.time").setLocation(0.125, 0.125, 0.0, EnumFacing.NORTH)};
    }

    public SignalHandler getPortCallback(int pin) {
        return this;
    }

    public void setPortCallback(int pin, Object callback) {
        this.out = callback instanceof SignalHandler ? (SignalHandler)callback : SignalHandler.NOP;
        this.out.updateSignal(this.minutes);
    }

    @Override
    protected void resetPin(int pin) {
        this.getPortCallback(pin).updateSignal(0);
    }

    public void updateSignal(int value) {
        if (value < 0) {
            value = 0;
        } else if (value > 2) {
            value = 2;
        }
        if (this.mode == value) {
            return;
        }
        this.mode = (byte)value;
        this.turnOn();
        this.markDirty(2);
    }

    public void func_73660_a() {
        boolean reduce;
        if (this.ticket == null) {
            return;
        }
        long t = this.field_145850_b.func_82737_E();
        if ((t & 0xFL) != 0L || t % 1200L != 0L) {
            return;
        }
        int chunks = this.chunkCount();
        boolean all = this.ticket.getModData().func_74767_n("all");
        boolean bl = reduce = all && this.mode == 1 || this.missingFrames != 0 || this.ticket.getChunkListDepth() > 0 && chunks > this.ticket.getChunkListDepth();
        if (!all || reduce) {
            chunks = 1;
        } else if (chunks > 2) {
            chunks = 2;
        }
        if (this.mode > 0 && this.minutes >= chunks) {
            if (reduce) {
                this.forceChunks(false);
            }
            this.out.updateSignal(this.minutes -= chunks);
        } else {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            this.ticket = null;
        }
        this.markDirty(2);
    }

    @Override
    public boolean setTicket(ForgeChunkManager.Ticket ticket) {
        if (this.ticket != null && this.ticket != ticket) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = ticket;
        this.forceChunks(ticket.getModData().func_74767_n("all"));
        return true;
    }

    private int chunkCount() {
        return ((this.area[0] + this.area[3] >> 4) - (this.area[0] - 1 >> 4) + 1) * ((this.area[2] + this.area[5] >> 4) - (this.area[2] - 1 >> 4) + 1);
    }

    private void forceChunks(boolean all) {
        if (this.ticket == null) {
            this.ticket = ForgeChunkManager.requestPlayerTicket((Object)Main.instance, (String)this.owner, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (this.ticket == null) {
                return;
            }
            this.ticket.getModData().func_74772_a("pos", this.field_174879_c.func_177986_g());
        }
        ChunkPos me = this.getChunk().func_76632_l();
        int cx1 = this.area[0] + this.area[3] >> 4;
        for (int cx = this.area[0] >> 4; cx <= cx1; ++cx) {
            int cz1 = this.area[2] + this.area[5] >> 4;
            for (int cz = this.area[2] >> 4; cz <= cz1; ++cz) {
                ChunkPos pos = new ChunkPos(cx, cz);
                if (all) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)pos);
                    continue;
                }
                if (pos.equals((Object)me)) continue;
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)pos);
            }
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)me);
        this.ticket.getModData().func_74757_a("all", all);
    }

    private void turnOn() {
        boolean all;
        if (this.mode <= 0) {
            return;
        }
        int chunks = this.chunkCount();
        boolean bl = all = this.mode > 1 && this.missingFrames == 0 && chunks <= MAX_CHUNKS;
        if (!all) {
            chunks = 1;
        } else if (chunks > 2) {
            chunks = 2;
        }
        if (this.ticket != null) {
            if (!all || this.ticket.getModData().func_74767_n("all")) {
                return;
            }
            --chunks;
        }
        if (this.minutes < chunks * 2) {
            return;
        }
        this.minutes -= chunks;
        this.forceChunks(all);
    }

    @Override
    public void onFrameBreak(BlockPos pos) {
        int i = 0;
        int d = pos.func_177958_n() - this.area[0];
        if (d == this.area[3]) {
            i |= 1;
        } else if (d != -1) {
            return;
        }
        d = pos.func_177956_o() - this.area[1];
        if (d != 0) {
            return;
        }
        d = pos.func_177952_p() - this.area[2];
        if (d == this.area[5]) {
            i |= 4;
        } else if (d != -1) {
            return;
        }
        this.missingFrames = (byte)(this.missingFrames | 5 << i);
        this.markDirty(2);
    }

    @Override
    public String get() {
        char state;
        char status;
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            return TooltipUtil.translate((String)("port.rs_ctr.show_sel" + (this.showFrame ? (char)'1' : '0')));
        }
        int dx = this.area[3] + 2;
        int dz = this.area[5] + 2;
        int t = this.minutes;
        int n = this.chunkCount();
        char c = n > MAX_CHUNKS ? (char)'2' : (status = this.missingFrames != 0 ? (char)'1' : '0');
        if (this.mode > 1 && n > 1) {
            state = '2';
            t >>= 1;
        } else {
            state = this.mode <= 0 ? (char)'0' : '1';
        }
        return TooltipUtil.format((String)("port.rs_ctr.area_cl" + status), (Object[])new Object[]{dx, dz, n, MAX_CHUNKS, Integer.bitCount(this.missingFrames & 0xFF) >> 1}) + '\n' + TooltipUtil.format((String)("port.rs_ctr.time_cl" + state), (Object[])new Object[]{t / 60, t % 60});
    }

    @Override
    public void accept(int value) {
        if ((value & 1) != 0) {
            if (this.minutes <= 0) {
                return;
            }
            ItemStack stack = new ItemStack((Item)Objects.cl_fuel);
            if ((this.minutes -= stack.func_77958_k()) < 0) {
                stack.func_77964_b(-this.minutes);
                this.minutes = 0;
            }
            ItemFluidUtil.dropStack((ItemStack)stack, (World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(this.o.front));
            this.out.updateSignal(this.minutes);
            this.markDirty(2);
        }
        if ((value & 2) == 0) {
            if (this.area[3] <= 0 || this.area[4] <= 0 || this.area[5] <= 0 || (this.missingFrames = (byte)IFrameOperator.checkCorners(this.field_145850_b, this.field_174879_c, this.area)) != 0) {
                IFrameOperator.unlinkCorners(this.field_145850_b, this.field_174879_c, this.area, ~this.missingFrames);
                IFrameOperator.scanArea(this.field_145850_b, this.field_174879_c, this.area, RANGE, this.getOrientation().front);
                this.area[1] = this.field_174879_c.func_177956_o();
                this.area[4] = 1;
                this.missingFrames = (byte)IFrameOperator.checkCorners(this.field_145850_b, this.field_174879_c, this.area);
            }
            this.turnOn();
        } else {
            this.showFrame = !this.showFrame;
        }
        this.markDirty(2);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        if (item.func_77973_b() instanceof ItemChunkLoaderFuel) {
            if (this.minutes >= MAX_MINUTES) {
                return false;
            }
            if (!(this.field_145850_b instanceof WorldServer)) {
                return true;
            }
            if (((WorldServer)this.field_145850_b).func_73046_m().func_184103_al().func_177451_a(player.func_110124_au()) == null) {
                return false;
            }
            if ((this.minutes += (item = item.func_77979_a(1)).func_77958_k() - item.func_77952_i()) > MAX_MINUTES) {
                item.func_77964_b(item.func_77958_k() - this.minutes + MAX_MINUTES);
                ItemFluidUtil.dropStack((ItemStack)item, (Entity)player);
                this.minutes = MAX_MINUTES;
            }
            this.owner = player.func_70005_c_();
            this.turnOn();
            this.out.updateSignal(this.minutes);
            this.markDirty(2);
            return true;
        }
        return super.onActivated(player, hand, item, s, X, Y, Z);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            nbt.func_74778_a("owner", this.owner);
        }
        nbt.func_74768_a("mode", (int)(mode == 0 ? this.mode : (byte)(this.ticket == null ? 0 : (this.ticket.getModData().func_74767_n("all") ? 2 : 1))));
        IFrameOperator.writeArea(this.area, nbt, this.field_174879_c);
        nbt.func_74774_a("frame", this.missingFrames);
        nbt.func_74757_a("dsp", this.showFrame);
        nbt.func_74768_a("t", this.minutes);
        if (mode == 1) {
            nbt.func_74768_a("lim", ForgeChunkManager.getMaxChunkDepthFor((String)"rs_ctr"));
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            this.owner = nbt.func_74779_i("owner");
        }
        this.mode = nbt.func_74771_c("mode");
        IFrameOperator.readArea(this.area, nbt, this.field_174879_c);
        this.missingFrames = nbt.func_74771_c("frame");
        this.showFrame = nbt.func_74767_n("dsp");
        this.minutes = nbt.func_74762_e("t");
        if (mode == 1 && nbt.func_150297_b("lim", 3) && (MAX_CHUNKS = nbt.func_74762_e("lim")) <= 0) {
            MAX_CHUNKS = Integer.MAX_VALUE;
        }
        super.loadState(nbt, mode);
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        if (this.ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            this.ticket = null;
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.turnOn();
    }

    @Override
    public void breakBlock() {
        super.breakBlock();
        int cap = Objects.cl_fuel.func_77612_l();
        ItemFluidUtil.dropStack((ItemStack)new ItemStack((Item)Objects.cl_fuel, this.minutes / cap), (World)this.field_145850_b, (BlockPos)this.field_174879_c);
        if ((this.minutes %= cap) > 0) {
            ItemFluidUtil.dropStack((ItemStack)new ItemStack((Item)Objects.cl_fuel, 1, cap - this.minutes), (World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
        this.minutes = 0;
        IFrameOperator.unlinkCorners(this.field_145850_b, this.field_174879_c, this.area, ~this.missingFrames);
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        list.add(this.button);
    }

    @Override
    protected void orient(Orientation o) {
        if (this.area[1] < 0) {
            this.area[0] = this.field_174879_c.func_177958_n() + 1;
            this.area[1] = this.field_174879_c.func_177956_o();
            this.area[2] = this.field_174879_c.func_177952_p() + 1;
        }
        this.button.setLocation(0.5, 0.625, 0.0, o);
        super.orient(o);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpecial(double x, double y, double z, float t, FontRenderer fr) {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        int mf = this.missingFrames & 0xFF;
        if (mf == 0) {
            return;
        }
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        int i = 0;
        while (i < 8) {
            if ((mf & 1) != 0) {
                BlockPos p = IFrameOperator.getCorner(this.area, i).func_177973_b((Vec3i)this.field_174879_c);
                double x1 = x + (double)p.func_177958_n();
                double y1 = y + (double)p.func_177956_o();
                double z1 = z + (double)p.func_177952_p();
                RenderGlobal.func_189694_a((double)x1, (double)y1, (double)z1, (double)(x1 + 1.0), (double)(y1 + 1.0), (double)(z1 + 1.0), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            ++i;
            mf >>= 1;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return this.missingFrames == 0 && !HybridFastTESR.isAimedAt((TileEntity)this);
    }

    public double func_145833_n() {
        int d = this.area[3];
        double d2 = super.func_145833_n() + (double)(d * d);
        d = this.area[4];
        double d3 = d2 + (double)(d * d);
        d = this.area[5];
        return d3 + (double)(d * d);
    }

    public void render(World world, BlockPos pos, double x, double y, double z, int light, BufferBuilder buffer) {
        if (this.showFrame) {
            FrameRenderer.renderFrame(x - 1.03125, y - 0.03125, z - 1.03125, (x += (double)(this.area[0] - pos.func_177958_n())) + (double)this.area[3] + 1.03125, (y += (double)(this.area[1] - pos.func_177956_o())) + (double)this.area[4] + 0.03125, (z += (double)(this.area[2] - pos.func_177952_p())) + (double)this.area[5] + 1.03125, buffer, this.missingFrames != 0 ? 0x7F0000FF : (this.mode > 1 ? 0x7FFF0000 : 0x7F00FF00));
        }
    }

    public AxisAlignedBB getRenderBB(World world, BlockPos pos) {
        return new AxisAlignedBB((double)(this.area[0] - 1), (double)this.area[1], (double)(this.area[2] - 1), (double)(this.area[0] + this.area[3] + 1), (double)(this.area[1] + this.area[4]), (double)(this.area[2] + this.area[5] + 1));
    }

    @Override
    public Object getState(int id) {
        return id == 0 ? this.mode : this.minutes;
    }

    static {
        MAX_MINUTES = 2880;
    }
}

